/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalInstantiate;
import org.openl.ie.constrainer.IntBoolVar;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.constrainer.UndoImpl;
import org.openl.ie.constrainer.Undoable;
import org.openl.ie.constrainer.impl.IntBoolExpImpl;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.SubjectImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public class IntBoolVarImpl
extends IntBoolExpImpl
implements IntBoolVar {
    protected int _max = 1;
    protected int _min = 0;

    public IntBoolVarImpl(Constrainer constrainer) {
        this(constrainer, "");
    }

    public IntBoolVarImpl(Constrainer constrainer, String name) {
        super(constrainer, name);
    }

    @Override
    public Undo createUndo() {
        return UndoIntBoolVar.getBoolVarUndo();
    }

    @Override
    public int domainType() {
        return 3;
    }

    @Override
    public void forceInsert(int val) {
        this.abort("Temporary method???");
    }

    @Override
    public void forceMax(int max) {
        this._max = max;
    }

    @Override
    public void forceMin(int min) {
        this._min = min;
    }

    @Override
    public void forceSize(int max) {
        this.abort("Temporary method???");
    }

    @Override
    public Goal instantiate() {
        return new GoalInstantiate(this);
    }

    @Override
    public int max() {
        return this._max;
    }

    @Override
    public int min() {
        return this._min;
    }

    @Override
    public void propagate() throws Failure {
        this.notifyObservers(IntEventBool.getEvent(this, this._min == 1));
    }

    @Override
    public void setMax(int max) throws Failure {
        if (max < this._min) {
            this._constrainer.fail("set max bool var");
        }
        if (max < this._max) {
            this.constrainer().addUndo(UndoIntBoolVarValue.getUndo(this));
            this._max = max;
            this.notifyObservers(IntEventBoolFalse.the);
        }
    }

    @Override
    public void setMin(int min) throws Failure {
        if (min > this._max) {
            this._constrainer.fail("set min bool var");
        }
        if (min > this._min) {
            this.constrainer().addUndo(UndoIntBoolVarValue.getUndo(this));
            this._min = min;
            this.notifyObservers(IntEventBoolTrue.the);
        }
    }

    @Override
    public void removeValue(int value) throws Failure {
        if (value == 1) {
            this.setMax(0);
        } else {
            this.setMin(1);
        }
    }

    static final class UndoIntBoolVarValue
    extends UndoImpl {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new UndoIntBoolVarValue();
            }
        };

        UndoIntBoolVarValue() {
        }

        static UndoIntBoolVarValue getUndo(IntBoolVarImpl v) {
            UndoIntBoolVarValue undo = (UndoIntBoolVarValue)_factory.getElement();
            undo.undoable(v);
            return undo;
        }

        @Override
        public String toString() {
            return "UndoIntBoolVarValue " + this.undoable();
        }

        @Override
        public void undo() {
            IntBoolVar var = (IntBoolVar)this.undoable();
            var.forceMin(0);
            var.forceMax(1);
            super.undo();
        }
    }

    static final class UndoIntBoolVar
    extends SubjectImpl.UndoSubject {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new UndoIntBoolVar();
            }
        };
        int _min;
        int _max;

        UndoIntBoolVar() {
        }

        static UndoIntBoolVar getBoolVarUndo() {
            return (UndoIntBoolVar)_factory.getElement();
        }

        @Override
        public String toString() {
            return "UndoIntBoolVar " + this.undoable();
        }

        @Override
        public void undo() {
            IntBoolVar var = (IntBoolVar)this.undoable();
            var.forceMin(this._min);
            var.forceMax(this._max);
            super.undo();
        }

        @Override
        public void undoable(Undoable u) {
            super.undoable(u);
            IntBoolVarImpl var = (IntBoolVarImpl)u;
            this._min = var.min();
            this._max = var.max();
        }
    }

    static final class IntEventBoolTrue
    extends IntEvent {
        public static final IntEventBoolTrue the = new IntEventBoolTrue();

        IntEventBoolTrue() {
        }

        @Override
        public void free() {
        }

        @Override
        public int max() {
            return 1;
        }

        @Override
        public int min() {
            return 1;
        }

        @Override
        public String name() {
            return "IntBoolEventTrue";
        }

        @Override
        public int numberOfRemoves() {
            return 0;
        }

        @Override
        public int oldmax() {
            return 1;
        }

        @Override
        public int oldmin() {
            return 0;
        }

        @Override
        public int removed(int i) {
            return -1;
        }

        @Override
        public int type() {
            return 3;
        }
    }

    static final class IntEventBoolFalse
    extends IntEvent {
        public static final IntEventBoolFalse the = new IntEventBoolFalse();

        IntEventBoolFalse() {
        }

        @Override
        public void free() {
        }

        @Override
        public int max() {
            return 0;
        }

        @Override
        public int min() {
            return 0;
        }

        @Override
        public String name() {
            return "IntBoolEventFalse";
        }

        @Override
        public int numberOfRemoves() {
            return 0;
        }

        @Override
        public int oldmax() {
            return 1;
        }

        @Override
        public int oldmin() {
            return 0;
        }

        @Override
        public int removed(int i) {
            return -1;
        }

        @Override
        public int type() {
            return 5;
        }
    }

    static final class IntEventBool
    extends IntEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new IntEventBool();
            }
        };
        int _int_value;
        int _type;

        IntEventBool() {
        }

        static IntEventBool getEvent(IntExp exp, boolean val) {
            IntEventBool ev = (IntEventBool)_factory.getElement();
            ev.init(exp, val);
            return ev;
        }

        public void init(IntExp exp, boolean val) {
            this.exp(exp);
            if (val) {
                this._int_value = 1;
                this._type = 3;
            } else {
                this._int_value = 0;
                this._type = 5;
            }
        }

        @Override
        public int max() {
            return this._int_value;
        }

        @Override
        public int min() {
            return this._int_value;
        }

        @Override
        public String name() {
            return "IntBoolEvent";
        }

        @Override
        public int numberOfRemoves() {
            return 0;
        }

        @Override
        public int oldmax() {
            return 1;
        }

        @Override
        public int oldmin() {
            return 0;
        }

        @Override
        public int removed(int i) {
            return -1;
        }

        @Override
        public int type() {
            return this._type;
        }
    }
}

