/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Arrays;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;

final class IntCalc {
    IntCalc() {
    }

    public static int binarySearch(int[] a, int key) {
        return Arrays.binarySearch(a, key);
    }

    public static int[] differentSortedValues(int[] v) {
        if (IntCalc.isDiffSorted(v)) {
            return v;
        }
        Arrays.sort(v);
        int dst = 0;
        for (int src = 1; src < v.length; ++src) {
            if (v[src] == v[dst]) continue;
            v[++dst] = v[src];
        }
        int size = dst + 1;
        if (size == v.length) {
            return v;
        }
        int[] v1 = new int[size];
        System.arraycopy(v, 0, v1, 0, size);
        return v1;
    }

    public static int divTruncToNegInf(int x1, int x2) {
        int v = x1 / x2;
        if (v * x2 == x1) {
            return v;
        }
        boolean vIsPositive = x1 > 0 && x2 > 0 || x1 < 0 && x2 < 0;
        return vIsPositive ? v : v - 1;
    }

    public static int divTruncToPosInf(int x1, int x2) {
        int v = x1 / x2;
        if (v * x2 == x1) {
            return v;
        }
        boolean vIsPositive = x1 > 0 && x2 > 0 || x1 < 0 && x2 < 0;
        return vIsPositive ? v + 1 : v;
    }

    public static int divTruncToZero(int x1, int x2) {
        return x1 / x2;
    }

    static boolean isDiffSorted(int[] v) {
        int i = 0;
        while (i + 1 < v.length) {
            if (v[i] >= v[i + 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int productMax(int min1, int max1, int min2, int max2) {
        if (min1 >= 0) {
            return IntCalc.productMaxP(min1, max1, max2);
        }
        if (max1 <= 0) {
            return IntCalc.productMaxN(min1, max1, min2);
        }
        if (min2 >= 0) {
            return max1 * max2;
        }
        if (max2 <= 0) {
            return min1 * min2;
        }
        return Math.max(min1 * min2, max1 * max2);
    }

    public static int productMaxN(int min1, int max1, int min2) {
        if (min2 >= 0) {
            return max1 * min2;
        }
        return min1 * min2;
    }

    public static int productMaxP(int min1, int max1, int max2) {
        if (max2 >= 0) {
            return max1 * max2;
        }
        return min1 * max2;
    }

    public static int productMin(int min1, int max1, int min2, int max2) {
        if (min1 >= 0) {
            return IntCalc.productMinP(min1, max1, min2);
        }
        if (max1 <= 0) {
            return IntCalc.productMinN(min1, max1, max2);
        }
        if (min2 >= 0) {
            return min1 * max2;
        }
        if (max2 <= 0) {
            return max1 * min2;
        }
        return Math.min(max1 * min2, min1 * max2);
    }

    public static int productMinN(int min1, int max1, int max2) {
        if (max2 >= 0) {
            return min1 * max2;
        }
        return max1 * max2;
    }

    public static int productMinP(int min1, int max1, int min2) {
        if (min2 >= 0) {
            return min1 * min2;
        }
        return max1 * min2;
    }

    public static void productSetMax(int max, IntExp exp1, IntExp exp2) throws Failure {
        int min1 = exp1.min();
        if (min1 >= 0) {
            IntCalc.productSetMaxP(max, min1, exp1.max(), exp2);
        } else {
            int max1 = exp1.max();
            if (max1 <= 0) {
                IntCalc.productSetMaxN(max, min1, max1, exp2);
            } else if (max < 0) {
                int m = IntCalc.divTruncToPosInf(max1, max);
                int M = IntCalc.divTruncToNegInf(min1, max);
                if (m * max == max1) {
                    ++m;
                }
                if (M * max == min1) {
                    --M;
                }
                if (m <= M) {
                    exp2.removeRange(m, M);
                }
            }
        }
    }

    public static void productSetMaxN(int max, int min1, int max1, IntExp exp2) throws Failure {
        if (max == 0) {
            if (max1 < 0) {
                exp2.setMin(0);
            }
        } else {
            int v;
            int n = v = max > 0 ? max1 : min1;
            if (v != 0) {
                int min2 = IntCalc.divTruncToPosInf(max, v);
                exp2.setMin(min2);
            }
        }
    }

    public static void productSetMaxP(int max, int min1, int max1, IntExp exp2) throws Failure {
        if (max == 0) {
            if (min1 > 0) {
                exp2.setMax(0);
            }
        } else {
            int v;
            int n = v = max > 0 ? min1 : max1;
            if (v != 0) {
                int max2 = IntCalc.divTruncToNegInf(max, v);
                exp2.setMax(max2);
            }
        }
    }

    public static void productSetMin(int min, IntExp exp1, IntExp exp2) throws Failure {
        int min1 = exp1.min();
        if (min1 >= 0) {
            IntCalc.productSetMinP(min, min1, exp1.max(), exp2);
        } else {
            int max1 = exp1.max();
            if (max1 <= 0) {
                IntCalc.productSetMinN(min, min1, max1, exp2);
            } else if (min > 0) {
                int m = IntCalc.divTruncToPosInf(min1, min);
                int M = IntCalc.divTruncToNegInf(max1, min);
                if (m * min == min1) {
                    ++m;
                }
                if (M * min == max1) {
                    --M;
                }
                if (m <= M) {
                    exp2.removeRange(m, M);
                }
            }
        }
    }

    public static void productSetMinN(int min, int min1, int max1, IntExp exp2) throws Failure {
        if (min == 0) {
            if (max1 < 0) {
                exp2.setMax(0);
            }
        } else {
            int v;
            int n = v = min > 0 ? min1 : max1;
            if (v != 0) {
                int max2 = IntCalc.divTruncToNegInf(min, v);
                exp2.setMax(max2);
            }
        }
    }

    public static void productSetMinP(int min, int min1, int max1, IntExp exp2) throws Failure {
        if (min == 0) {
            if (min1 > 0) {
                exp2.setMin(0);
            }
        } else {
            int v;
            int n = v = min > 0 ? max1 : min1;
            if (v != 0) {
                int min2 = IntCalc.divTruncToPosInf(min, v);
                exp2.setMin(min2);
            }
        }
    }

    public static int sqrMax(int min, int max) {
        return Math.max(min * min, max * max);
    }

    public static int sqrMin(int min, int max) {
        if (min >= 0) {
            return min * min;
        }
        if (max >= 0) {
            return 0;
        }
        return max * max;
    }

    public static int sqrtInt(int value) {
        int sqrtValue = (int)Math.sqrt(value);
        return sqrtValue * sqrtValue == value ? sqrtValue : -1;
    }
}

