/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.io.Serializable;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.tools.FastVectorInt;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class IntDomainHistory
implements Serializable {
    static final int MIN_IDX = 0;
    static final int MAX_IDX = 1;
    static final int SIZE_IDX = 2;
    static final int REMOVE_IDX = 3;
    static final int LAST_IDX = 4;
    IntVar _var;
    FastVectorInt _history;
    FastVectorInt _remove_history;
    int _currentIndex = -1;
    int _mask;
    int _min;
    int _max;

    public IntDomainHistory(IntVar var) {
        this._var = var;
        int max_size = Math.min(this._var.size(), 30);
        this._history = new FastVectorInt(2 * max_size);
        this._remove_history = new FastVectorInt(max_size);
        this.save();
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public int getRemove(int i) {
        return this._remove_history.elementAt(i);
    }

    public int max() {
        return this._max;
    }

    public int min() {
        return this._min;
    }

    public int numberOfRemoves() {
        return this._remove_history.size() - this.removeIndex();
    }

    public int oldmax() {
        return this._history.elementAt(this._currentIndex + 1);
    }

    public int oldmin() {
        return this._history.elementAt(this._currentIndex + 0);
    }

    void propagate() throws Failure {
        if ((this._var.publisherMask() & this._mask) != 0) {
            IntEventDomain ev = IntEventDomain.getEvent(this);
            this.save();
            this._var.notifyObservers(ev);
        } else {
            this.save();
        }
    }

    void remove(int val) {
        if (this._min < val && val < this._max) {
            this._remove_history.add(val);
            this._mask |= 8;
        }
    }

    void remove(int range_min, int range_max) {
        int t_min = Math.max(this._min, range_min);
        int t_max = Math.min(this._max, range_max);
        for (int i = t_min; i <= t_max; ++i) {
            this._remove_history.add(i);
        }
        this._mask |= 8;
    }

    public int removeIndex() {
        return this._history.elementAt(this._currentIndex + 3);
    }

    public void restore(int index) {
        this._var.forceSize(this._history.elementAt(index + 2));
        this._min = this._history.elementAt(index + 0);
        this._var.forceMin(this._min);
        this._max = this._history.elementAt(index + 1);
        this._var.forceMax(this._max);
        int firstRemoveIndex = this._history.elementAt(index + 3);
        for (int i = this._remove_history.size() - 1; i >= firstRemoveIndex; --i) {
            this._var.forceInsert(this._remove_history.elementAt(i));
        }
        this._remove_history.cutSize(firstRemoveIndex);
        this._history.cutSize(index + 4);
        this._currentIndex = index;
        this._mask = 0;
    }

    int save() {
        int old = this._currentIndex;
        this._currentIndex = this._history.size();
        this._min = this._var.min();
        this._history.add(this._min);
        this._max = this._var.max();
        this._history.add(this._max);
        this._history.add(this._var.size());
        this._history.add(this._remove_history.size());
        this._mask = 0;
        return old;
    }

    public void saveUndo() {
        if (this._mask != 0) {
            this.save();
        }
    }

    void setMax(int val) {
        if (val < this._max) {
            this._max = val;
            this._mask |= 4;
            if (this._min == this._max) {
                this._mask |= 1;
                this._mask &= 0xFFFFFFF7;
            }
        }
    }

    void setMin(int val) {
        if (val > this._min) {
            this._min = val;
            this._mask |= 2;
            if (this._min == this._max) {
                this._mask |= 1;
                this._mask &= 0xFFFFFFF7;
            }
        }
    }

    public String toString() {
        return "History: " + this._history + ":" + this._currentIndex + "(" + this._min + "-" + this._max + ")" + "mask: " + this._mask;
    }

    static final class IntEventDomain
    extends IntEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new IntEventDomain();
            }
        };
        protected int _min;
        protected int _max;
        protected int _oldmin;
        protected int _oldmax;
        protected int _type_mask;
        IntDomainHistory _history;
        int _removeIndex;
        int _numberOfRemoves;

        IntEventDomain() {
        }

        static IntEventDomain getEvent(IntDomainHistory history) {
            IntEventDomain ev = (IntEventDomain)_factory.getElement();
            ev.init(history);
            return ev;
        }

        public void init(IntDomainHistory hist) {
            this.exp(hist._var);
            this._min = hist.min();
            this._max = hist.max();
            this._oldmin = hist.oldmin();
            this._oldmax = hist.oldmax();
            this._type_mask = hist._mask;
            this._removeIndex = hist.removeIndex();
            this._numberOfRemoves = hist.numberOfRemoves();
            this._history = hist;
        }

        @Override
        public int max() {
            return this._max;
        }

        public void max(int max) {
            this._max = max;
        }

        @Override
        public int maxdiff() {
            return this._max - this._oldmax;
        }

        @Override
        public int min() {
            return this._min;
        }

        public void min(int min) {
            this._min = min;
        }

        @Override
        public int mindiff() {
            return this._min - this._oldmin;
        }

        @Override
        public String name() {
            return "Event Domain";
        }

        @Override
        public int numberOfRemoves() {
            return this._numberOfRemoves;
        }

        @Override
        public int oldmax() {
            return this._oldmax;
        }

        public void oldmax(int oldmax) {
            this._oldmax = oldmax;
        }

        @Override
        public int oldmin() {
            return this._oldmin;
        }

        public void oldmin(int oldmin) {
            this._oldmin = oldmin;
        }

        @Override
        public int removed(int i) {
            return this._history.getRemove(this._removeIndex + i);
        }

        @Override
        public int type() {
            return this._type_mask;
        }
    }
}

