/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntExpImpl;

public final class IntExpRangeViolation
extends IntExpImpl {
    private IntExp _exp;
    private int _rangeMin;
    private int _rangeMax;
    private Observer _observer;
    private IntVar _domain;

    public IntExpRangeViolation(IntExp exp, int rangeMin, int rangeMax) {
        super(exp.constrainer());
        this._exp = exp;
        this._rangeMin = rangeMin;
        this._rangeMax = rangeMax;
        if (this.constrainer().showInternalNames()) {
            this._name = "((" + exp.name() + "<" + rangeMin + ")*(" + rangeMin + "-" + exp.name() + ")+" + "(" + exp.name() + ">" + rangeMax + ")*(" + exp.name() + "-" + rangeMax + ")" + ")";
        }
        int trace = 0;
        this._domain = this.constrainer().addIntVarTraceInternal(this.calc_min(), this.calc_max(), this._name, 0, trace);
        this._observer = new ExpRangeViolationObserver();
        this._exp.attachObserver(this._observer);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._domain.attachObserver(observer);
    }

    int calc_max() {
        return Math.max(this.calc_v(this._exp.min()), this.calc_v(this._exp.max()));
    }

    int calc_min() {
        int expMin = this._exp.min();
        int expMax = this._exp.max();
        if (expMin >= this._rangeMax) {
            return expMin - this._rangeMax;
        }
        if (expMax <= this._rangeMin) {
            return this._rangeMin - expMax;
        }
        return 0;
    }

    int calc_v(int x) {
        if (x < this._rangeMin) {
            return this._rangeMin - x;
        }
        if (x > this._rangeMax) {
            return x - this._rangeMax;
        }
        return 0;
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._domain.detachObserver(observer);
    }

    @Override
    public int max() {
        return this._domain.max();
    }

    @Override
    public int min() {
        return this._domain.min();
    }

    @Override
    public void propagate() throws Failure {
        int min = this._domain.min();
        int max = this._domain.max();
        if (max >= 0) {
            this._exp.setMin(this._rangeMin - max);
            this._exp.setMax(this._rangeMax + max);
        }
        if (min > 0) {
            int holeMin = this._rangeMin - min + 1;
            int holeMax = this._rangeMax + min - 1;
            for (int i = holeMin; i <= holeMax; ++i) {
                this._exp.removeValue(i);
            }
        }
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._domain.reattachObserver(observer);
    }

    @Override
    public void setMax(int max) throws Failure {
        if (max >= this._domain.max()) {
            return;
        }
        if (max < this._domain.min()) {
            this.constrainer().fail("IntExpRangeViolation.setMax(): max < min()");
        }
        this._domain.setMax(max);
        if (max < 0) {
            this.abort("IntExpRangeViolation.setMax(): max < 0: " + max);
        }
        this._exp.setMin(this._rangeMin - max);
        this._exp.setMax(this._rangeMax + max);
    }

    @Override
    public void setMin(int min) throws Failure {
        if (min <= this._domain.min()) {
            return;
        }
        if (min > this._domain.max()) {
            this.constrainer().fail("IntExpRangeViolation.setMin(): min > max()");
        }
        this._domain.setMin(min);
        if (min <= 0) {
            this.abort("IntExpRangeViolation.setMin(): min <= 0: " + min);
        }
        int holeMin = this._rangeMin - min + 1;
        int holeMax = this._rangeMax + min - 1;
        for (int i = holeMin; i <= holeMax; ++i) {
            this._exp.removeValue(i);
        }
    }

    @Override
    public int value() throws Failure {
        return this._domain.value();
    }

    class ExpRangeViolationObserver
    extends Observer {
        ExpRangeViolationObserver() {
        }

        @Override
        public Object master() {
            return IntExpRangeViolation.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "ExpRangeViolationObserver: ";
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntExpRangeViolation.this._domain.setMin(IntExpRangeViolation.this.calc_min());
            IntExpRangeViolation.this._domain.setMax(IntExpRangeViolation.this.calc_max());
        }
    }
}

