/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.IntCalc;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class IntExpSqr
extends IntExpImpl {
    private static final int[] event_map = new int[]{6, 2, 6, 4, 1, 1, 8, 8};
    private IntExp _exp;
    private ExpressionObserver _observer;

    public IntExpSqr(IntExp exp) {
        super(exp.constrainer());
        this._exp = exp;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + "*" + exp.name() + ")";
        }
        this._observer = new IntExpSqrObserver();
        this._exp.attachObserver(this._observer);
    }

    @Override
    public int max() {
        return IntCalc.sqrMax(this._exp.min(), this._exp.max());
    }

    @Override
    public int min() {
        return IntCalc.sqrMin(this._exp.min(), this._exp.max());
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void removeValue(int value) throws Failure {
        if (value < 0) {
            return;
        }
        int sqrtValue = IntCalc.sqrtInt(value);
        if (sqrtValue < 0) {
            return;
        }
        this._exp.removeValue(sqrtValue);
        this._exp.removeValue(-sqrtValue);
    }

    @Override
    public void setMax(int max) throws Failure {
        if (max < 0) {
            this.constrainer().fail("max < 0");
        }
        int expMinMax = (int)Math.sqrt(max);
        this._exp.setMax(expMinMax);
        this._exp.setMin(-expMinMax);
    }

    @Override
    public void setMin(int min) throws Failure {
        if (min <= 0) {
            return;
        }
        int expMinMax = (int)Math.sqrt(min);
        if (expMinMax * expMinMax == min) {
            --expMinMax;
        }
        for (int i = -expMinMax; i <= expMinMax; ++i) {
            this._exp.removeValue(i);
        }
    }

    @Override
    public void setValue(int value) throws Failure {
        int sqrtValue;
        if (value < 0) {
            this.constrainer().fail("value < 0");
        }
        if ((sqrtValue = IntCalc.sqrtInt(value)) < 0) {
            this.constrainer().fail("value is not a square");
        }
        this._exp.setValue(sqrtValue);
    }

    @Override
    public String toString() {
        return "sqr(" + this._exp + ")" + this.domainToString();
    }

    class IntExpSqrObserver
    extends ExpressionObserver {
        IntExpSqrObserver() {
            super(event_map);
        }

        @Override
        public Object master() {
            return IntExpSqr.this;
        }

        @Override
        public String toString() {
            return "IntExpSqrObserver: " + IntExpSqr.this._exp;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            IntEventSqr ev = IntEventSqr.getEvent(e, IntExpSqr.this);
            IntExpSqr.this.notifyObservers(ev);
        }
    }

    static final class IntEventSqr
    extends IntEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new IntEventSqr();
            }
        };
        IntEvent _event;
        int _type = 0;

        IntEventSqr() {
        }

        static IntEventSqr getEvent(IntEvent event, IntExp exp) {
            IntEventSqr ev = (IntEventSqr)_factory.getElement();
            ev.init(event, exp);
            return ev;
        }

        void init(IntEvent event, IntExp exp_) {
            this.exp(exp_);
            this._event = event;
            this._type = 0;
            if (this.max() < this.oldmax()) {
                this._type |= 4;
            }
            if (this.min() > this.oldmin()) {
                this._type |= 2;
            }
            if (this.min() == this.max()) {
                this._type |= 1;
            }
        }

        @Override
        public int max() {
            return IntCalc.sqrMax(this._event.min(), this._event.max());
        }

        @Override
        public int min() {
            return IntCalc.sqrMin(this._event.min(), this._event.max());
        }

        @Override
        public String name() {
            return "IntEventSqr";
        }

        @Override
        public int numberOfRemoves() {
            return 0;
        }

        @Override
        public int oldmax() {
            return IntCalc.sqrMax(this._event.oldmin(), this._event.oldmax());
        }

        @Override
        public int oldmin() {
            return IntCalc.sqrMin(this._event.oldmin(), this._event.oldmax());
        }

        @Override
        public int removed(int i) {
            return 0;
        }

        @Override
        public int type() {
            return this._type;
        }
    }
}

