/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.scheduler;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.scheduler.Resource;
import org.openl.ie.scheduler.Schedule;

public class ResourceDiscrete
implements Resource {
    private Object _object;
    private Schedule _schedule;
    private Constrainer _constrainer;
    private String _name;
    private IntExpArray _caps;
    private int _timeMin;
    private int _timeMax;
    private int _duration;

    public ResourceDiscrete(Schedule sch, int capacity) {
        this.init(sch, sch.start(), sch.end(), capacity);
    }

    public ResourceDiscrete(Schedule sch, int timeMin, int timeMax, int capacity) {
        this.init(sch, timeMin, timeMax, capacity);
    }

    @Override
    public IntExpArray caps() {
        return this._caps;
    }

    @Override
    public Constrainer constrainer() {
        return this._constrainer;
    }

    @Override
    public int duration() {
        return this._duration;
    }

    @Override
    public String getAssignment() {
        return this._schedule.getAssignments(this);
    }

    @Override
    public int getCapacityMax(int time) throws Failure {
        return this._caps.get(time - this._timeMin).max();
    }

    @Override
    public int getCapacityMin(int time) throws Failure {
        return this._caps.get(time - this._timeMin).min();
    }

    @Override
    public IntExp getCapacityVar(int time) throws Failure {
        return this._caps.get(time - this._timeMin);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Object getObject() {
        return this._object;
    }

    private void init(Schedule sch, int timeMin, int timeMax, int capacity) {
        this._object = null;
        this._schedule = sch;
        this._constrainer = this._schedule.constrainer();
        this._timeMax = timeMax;
        this._timeMin = timeMin;
        this._duration = this._timeMax - this._timeMin;
        this._caps = new IntExpArray(this._constrainer, this._duration);
        for (int i = 0; i < this._duration; ++i) {
            this._caps.set(this._constrainer.addIntVar(0, capacity), i);
        }
    }

    @Override
    public String mapString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (int i = 0; i < this._duration; ++i) {
            s.append(".").append(this._caps.get(i).max());
        }
        s.append(".]");
        return s.toString();
    }

    @Override
    public void setCapacityMax(int time, int capacity) throws Failure {
        this._caps.get(time - this._timeMin).setMax(capacity);
    }

    @Override
    public void setCapacityMax(int time1, int time2, int capacity) throws Failure {
        for (int i = time1 - this._timeMin; i < time2 - this._timeMin; ++i) {
            this._caps.get(i).setMax(capacity);
        }
    }

    @Override
    public void setCapacityMin(int time, int capacity) throws Failure {
        this._caps.get(time - this._timeMin).setMin(capacity);
    }

    @Override
    public void setCapacityMin(int time1, int time2, int capacity) throws Failure {
        for (int i = time1 - this._timeMin; i < time2 - this._timeMin; ++i) {
            this._caps.get(i).setMin(capacity);
        }
    }

    @Override
    public void setName(String name) {
        this._name = name;
        for (int i = 0; i < this._duration; ++i) {
            Integer v = new Integer(i);
            this._caps.get(i).name(this._name + "." + v);
        }
    }

    @Override
    public void setObject(Object o) {
        this._object = o;
    }

    @Override
    public int timeMax() {
        return this._timeMax;
    }

    @Override
    public int timeMin() {
        return this._timeMin;
    }

    @Override
    public String toString() {
        String assignments = this._schedule.getAssignments(this);
        return this.getName() + (assignments.equalsIgnoreCase("") ? "" : " : " + assignments);
    }
}

