/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.simplex;

public class Param {
    private static double DBL_EPSILON = Param.native_DBL_EPSILON();
    private static int[] params = new int[250];
    public static final int LPX_K_MSGLEV = 1;
    public static final int LPX_K_SCALE = 2;
    public static final int LPX_K_DUAL = 3;
    public static final int LPX_K_PRICE = 4;
    public static final int LPX_K_TOLBND = 5;
    public static final int LPX_K_TOLDJ = 6;
    public static final int LPX_K_TOLPIV = 7;
    public static final int LPX_K_ROUND = 8;
    public static final int LPX_K_OBJLL = 9;
    public static final int LPX_K_OBJUL = 10;
    public static final int LPX_K_ITLIM = 11;
    public static final int LPX_K_ITCNT = 12;
    public static final int LPX_K_TMLIM = 13;
    public static final int LPX_K_OUTFRQ = 14;
    public static final int LPX_K_OUTDLY = 15;
    public static final int LPX_K_BRANCH = 16;
    public static final int LPX_K_BTRACK = 17;
    public static final int LPX_K_TOLINT = 18;
    public static final int LPX_K_TOLOBJ = 19;
    public static final int LPX_K_MPSOBJ = 20;
    public static final int LPX_K_MPSINFO = 21;
    public static final int LPX_K_MPSORIG = 22;
    public static final int LPX_K_MPSWIDE = 23;
    public static final int LPX_K_MPSFREE = 24;
    public static final int LPX_K_MPSSKIP = 25;
    public static final int LPX_K_RELAX = 26;
    public static final int LPX_K_MEMCNT = 100;

    public static int getParam(int code) {
        int param = params[code];
        if (param == 0) {
            throw new IllegalArgumentException("Unexpected parameter's code: " + code);
        }
        return param;
    }

    public static boolean isValidBoolParam(int parm) {
        switch (parm) {
            case 3: 
            case 4: 
            case 8: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidIntParam(int parm) {
        switch (parm) {
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidIntParam(int parm, int val) {
        switch (parm) {
            case 1: {
                return 0 <= val && val <= 3;
            }
            case 2: {
                return 0 <= val && val <= 3;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 14: {
                return val > 0;
            }
            case 16: {
                return val == 0 || val == 1 || val == 2;
            }
            case 17: {
                return val == 0 || val == 1 || val == 2;
            }
            case 20: {
                return val == 0 || val == 1 || val == 2;
            }
        }
        return false;
    }

    public static boolean isValidRealParam(int parm, double val) {
        switch (parm) {
            case 26: {
                return 0.0 <= val && val <= 1.0;
            }
            case 5: {
                return DBL_EPSILON <= val && val <= 0.001;
            }
            case 6: {
                return DBL_EPSILON <= val && val <= 0.001;
            }
            case 7: {
                return DBL_EPSILON <= val && val <= 0.001;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 13: {
                return true;
            }
            case 15: {
                return true;
            }
            case 18: {
                return DBL_EPSILON <= val && val <= 0.001;
            }
            case 19: {
                return DBL_EPSILON <= val && val <= 0.001;
            }
        }
        return false;
    }

    public static boolean isValidRealParm(int parm) {
        switch (parm) {
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    private static native double native_DBL_EPSILON();

    private static native int native_LPX_K_BRANCH();

    private static native int native_LPX_K_BTRACK();

    private static native int native_LPX_K_DUAL();

    private static native int native_LPX_K_ITCNT();

    private static native int native_LPX_K_ITLIM();

    private static native int native_LPX_K_MPSFREE();

    private static native int native_LPX_K_MPSINFO();

    private static native int native_LPX_K_MPSOBJ();

    private static native int native_LPX_K_MPSORIG();

    private static native int native_LPX_K_MPSSKIP();

    private static native int native_LPX_K_MPSWIDE();

    private static native int native_LPX_K_MSGLEV();

    private static native int native_LPX_K_OBJLL();

    private static native int native_LPX_K_OBJUL();

    private static native int native_LPX_K_OUTDLY();

    private static native int native_LPX_K_OUTFRQ();

    private static native int native_LPX_K_PRICE();

    private static native int native_LPX_K_ROUND();

    private static native int native_LPX_K_SCALE();

    private static native int native_LPX_K_TMLIM();

    private static native int native_LPX_K_TOLBND();

    private static native int native_LPX_K_TOLDJ();

    private static native int native_LPX_K_TOLINT();

    private static native int native_LPX_K_TOLOBJ();

    private static native int native_LPX_K_TOLPIV();

    private Param() {
    }

    static {
        Param.params[1] = Param.native_LPX_K_MSGLEV();
        Param.params[2] = Param.native_LPX_K_SCALE();
        Param.params[11] = Param.native_LPX_K_ITLIM();
        Param.params[12] = Param.native_LPX_K_ITCNT();
        Param.params[14] = Param.native_LPX_K_OUTFRQ();
        Param.params[16] = Param.native_LPX_K_BRANCH();
        Param.params[17] = Param.native_LPX_K_BTRACK();
        Param.params[20] = Param.native_LPX_K_MPSOBJ();
        Param.params[3] = Param.native_LPX_K_DUAL();
        Param.params[4] = Param.native_LPX_K_PRICE();
        Param.params[8] = Param.native_LPX_K_ROUND();
        Param.params[21] = Param.native_LPX_K_MPSINFO();
        Param.params[22] = Param.native_LPX_K_MPSORIG();
        Param.params[23] = Param.native_LPX_K_MPSWIDE();
        Param.params[24] = Param.native_LPX_K_MPSFREE();
        Param.params[25] = Param.native_LPX_K_MPSSKIP();
        Param.params[5] = Param.native_LPX_K_TOLBND();
        Param.params[6] = Param.native_LPX_K_TOLDJ();
        Param.params[7] = Param.native_LPX_K_TOLPIV();
        Param.params[9] = Param.native_LPX_K_OBJLL();
        Param.params[10] = Param.native_LPX_K_OBJUL();
        Param.params[13] = Param.native_LPX_K_TMLIM();
        Param.params[15] = Param.native_LPX_K_OUTDLY();
        Param.params[18] = Param.native_LPX_K_TOLINT();
        Param.params[19] = Param.native_LPX_K_TOLOBJ();
    }
}

