/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.tools;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public final class FastVector
implements Cloneable,
Serializable {
    static final int DEFAULT_CAPACITY = 10;
    Object[] m_data;
    int m_size = 0;

    public FastVector() {
        this(10);
    }

    public FastVector(Collection c) {
        this(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public FastVector(int capacity) {
        if (capacity == 0) {
            capacity = 10;
        }
        this.m_data = new Object[capacity];
    }

    public FastVector(Object[] c) {
        this(c, 0, c.length - 1);
    }

    public FastVector(Object[] c, int fromIndex, int toIndex) {
        this(Math.max(0, toIndex - fromIndex + 1));
        if (this.m_size > 0) {
            System.arraycopy(this.m_data, fromIndex, this.m_data, 0, this.m_size);
        }
    }

    public final void add(Object obj) {
        if (this.m_size == this.m_data.length) {
            this.grow();
        }
        this.m_data[this.m_size++] = obj;
    }

    public final void addElement(Object obj) {
        if (this.m_size == this.m_data.length) {
            this.grow();
        }
        this.m_data[this.m_size++] = obj;
    }

    public void clear() {
        this.m_size = 0;
        this.m_data = new Object[this.m_data.length];
    }

    public Object clone() {
        try {
            FastVector v = (FastVector)super.clone();
            v.m_data = (Object[])this.m_data.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object[] data() {
        return this.m_data;
    }

    public Object elementAt(int i) {
        return this.m_data[i];
    }

    public Object firstElement() {
        return this.m_data[0];
    }

    void grow() {
        Object[] old = this.m_data;
        this.m_data = new Object[this.m_data.length * 2];
        System.arraycopy(old, 0, this.m_data, 0, this.m_size);
    }

    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this.m_size; ++i) {
                if (this.m_data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.m_size; ++i) {
                if (!elem.equals(this.m_data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void insertElementAt(Object obj, int index) {
        if (this.m_size == this.m_data.length) {
            this.grow();
        }
        System.arraycopy(this.m_data, index, this.m_data, index + 1, this.m_size - index);
        this.m_data[index] = obj;
        ++this.m_size;
    }

    public final boolean isEmpty() {
        return this.m_size == 0;
    }

    public Object lastElement() {
        return this.m_data[this.m_size - 1];
    }

    public final Object peek() {
        return this.m_data[this.m_size - 1];
    }

    public boolean removeElement(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void removeElementAt(int index) {
        int j = this.m_size - index - 1;
        if (j > 0) {
            System.arraycopy(this.m_data, index + 1, this.m_data, index, j);
        }
        --this.m_size;
        this.m_data[this.m_size] = null;
    }

    public final Object removeLast() {
        return this.m_data[--this.m_size];
    }

    public int size() {
        return this.m_size;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.m_size];
        System.arraycopy(this.m_data, 0, result, 0, this.m_size);
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.m_size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.m_size);
        }
        System.arraycopy(this.m_data, 0, a, 0, this.m_size);
        if (a.length > this.m_size) {
            a[this.m_size] = null;
        }
        return a;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int maxIndex = this.m_size - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(this.m_data[i]));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

