/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.tools;

import java.io.Serializable;

public final class FastVectorDouble
implements Cloneable,
Serializable {
    static final int DEFAULT_CAPACITY = 10;
    static int max_size = 0;
    double[] m_data;
    int m_size = 0;

    public FastVectorDouble() {
        this(10);
    }

    public FastVectorDouble(double[] c) {
        this(c, 0, c.length - 1);
    }

    public FastVectorDouble(double[] c, int fromIndex, int toIndex) {
        this(Math.max(0, toIndex - fromIndex + 1));
        if (this.m_size > 0) {
            System.arraycopy(this.m_data, fromIndex, this.m_data, 0, this.m_size);
        }
    }

    public FastVectorDouble(int capacity) {
        if (capacity == 0) {
            capacity = 10;
        }
        this.m_data = new double[capacity];
    }

    public final void add(double val) {
        if (this.m_size == this.m_data.length) {
            this.grow();
        }
        this.m_data[this.m_size++] = val;
    }

    public final void addElement(double val) {
        if (this.m_size == this.m_data.length) {
            this.grow();
        }
        this.m_data[this.m_size++] = val;
    }

    public void clear() {
        this.m_size = 0;
    }

    public Object clone() {
        try {
            FastVectorDouble v = (FastVectorDouble)super.clone();
            v.m_data = (double[])this.m_data.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void cutSize(int new_size) {
        this.m_size = new_size;
    }

    public double elementAt(int i) {
        return this.m_data[i];
    }

    public double firstElement() {
        return this.m_data[0];
    }

    void grow() {
        double[] old = this.m_data;
        this.m_data = new double[this.m_data.length * 2];
        System.arraycopy(old, 0, this.m_data, 0, this.m_size);
    }

    public void insertElementAt(double val, int index) {
        if (this.m_size == this.m_data.length) {
            this.grow();
        }
        System.arraycopy(this.m_data, index, this.m_data, index + 1, this.m_size - index);
        this.m_data[index] = val;
        ++this.m_size;
    }

    public final boolean isEmpty() {
        return this.m_size == 0;
    }

    public double lastElement() {
        return this.m_data[this.m_size - 1];
    }

    public final double peek() {
        return this.m_data[this.m_size - 1];
    }

    public void removeElementAt(int index) {
        int j = this.m_size - index - 1;
        if (j > 0) {
            System.arraycopy(this.m_data, index + 1, this.m_data, index, j);
        }
        --this.m_size;
    }

    public final double removeLast() {
        return this.m_data[--this.m_size];
    }

    public int size() {
        return this.m_size;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int maxIndex = this.m_size - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(this.m_data[i]));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

