/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openl.CompiledOpenClass;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.message.OpenLMessage;
import org.openl.rules.mapping.OpenLReflectionUtils;
import org.openl.rules.mapping.RulesBeanMapperFactory;
import org.openl.rules.mapping.plugin.CmdLineArgs;
import org.openl.rules.mapping.plugin.CmdLineProcessor;
import org.openl.rules.mapping.plugin.classpath.AdaptorClassLoader;
import org.openl.rules.mapping.plugin.serialize.BeanEntry;
import org.openl.rules.mapping.plugin.serialize.ClassSerializer;
import org.openl.rules.mapping.plugin.serialize.MessageEntry;
import org.openl.rules.mapping.plugin.serialize.MessageSerializer;
import org.openl.rules.mapping.plugin.serialize.xml.XmlWriter;
import org.openl.rules.mapping.plugin.util.AdaptorUtils;
import org.openl.rules.mapping.plugin.util.ClassUtils;
import org.openl.rules.runtime.RulesEngineFactory;
import org.openl.types.IOpenClass;
import org.openl.util.IOUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAdaptor {
    private static final Logger LOG = LoggerFactory.getLogger(PluginAdaptor.class);
    private String jarpath;
    private String outFilename;
    private String inputFilename;
    private boolean exportTypes;
    private boolean exportMessages;
    private String typesXmlPath;
    private boolean quietReflectionErrors;
    private boolean generateTypes;

    private PluginAdaptor(String jarpath, String outFilename, String inputFilename, boolean exportTypes, boolean exportMessages, String typesXmlPath, boolean quietReflectionErrors, boolean generateTypes) {
        this.jarpath = jarpath;
        this.outFilename = outFilename;
        this.inputFilename = inputFilename;
        this.exportTypes = exportTypes;
        this.exportMessages = exportMessages;
        this.typesXmlPath = typesXmlPath;
        this.quietReflectionErrors = quietReflectionErrors;
        this.generateTypes = generateTypes;
    }

    public void process() {
        if (StringUtils.isBlank((CharSequence)this.inputFilename)) {
            throw new RuntimeException("Input source file has to be provided");
        }
        File source = new File(this.inputFilename);
        if (!source.exists() || !source.canRead()) {
            throw new RuntimeException(String.format("Input source file '%s' is not exist or cannot be read", this.inputFilename));
        }
        String[] foldersToScan = AdaptorUtils.getPaths(this.jarpath);
        URL[] jarURLs = AdaptorUtils.scanDirs(foldersToScan);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        AdaptorClassLoader cl = new AdaptorClassLoader(jarURLs, originalClassLoader);
        Thread.currentThread().setContextClassLoader(cl);
        OutputStream out = null;
        try {
            RulesEngineFactory engine = RulesBeanMapperFactory.initEngine(source.toURI().toURL(), false);
            CompiledOpenClass compiledOpenClass = engine.getCompiledOpenClass();
            if (this.generateTypes) {
                out = this.getOutputStream();
                this.writeTypes(out, compiledOpenClass, jarURLs, cl);
            } else if (this.exportTypes) {
                out = this.getOutputStream();
                if (this.typesXmlPath != null) {
                    this.copyPreparedXml(out);
                } else {
                    this.writeTypes(out, compiledOpenClass, jarURLs, cl);
                }
            } else if (this.exportMessages) {
                List<MessageEntry> messages = this.exportMessages(compiledOpenClass.getMessages());
                out = this.getOutputStream();
                this.write(out, null, messages);
            }
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        catch (MalformedURLException e) {
            try {
                throw new RuntimeException(String.format("Input source file '%s' is not exist or cannot be read", this.inputFilename));
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)out);
    }

    private void writeTypes(OutputStream out, CompiledOpenClass compiledOpenClass, URL[] jarURLs, AdaptorClassLoader cl) {
        ModuleOpenClass openClass = (ModuleOpenClass)compiledOpenClass.getOpenClassWithErrors();
        List<BeanEntry> types = this.exportTypes(openClass, jarURLs, cl);
        this.write(out, types, null);
    }

    private void copyPreparedXml(OutputStream out) {
        try {
            IOUtils.copy((InputStream)new FileInputStream(new File(this.typesXmlPath)), (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(OutputStream out, List<BeanEntry> types, List<MessageEntry> messages) {
        try {
            new XmlWriter().write(types, messages, out);
        }
        catch (IOException e) {
            LOG.error("Error  ", (Throwable)e);
        }
    }

    private OutputStream getOutputStream() {
        OutputStream out = null;
        if (StringUtils.isNotBlank((CharSequence)this.outFilename)) {
            try {
                out = new FileOutputStream(this.outFilename);
            }
            catch (FileNotFoundException e) {
                LOG.error(String.format("File '%s' is not found", this.outFilename), (Throwable)e);
            }
        }
        if (out == null) {
            out = System.out;
        }
        return out;
    }

    private List<BeanEntry> exportTypes(ModuleOpenClass openClass, URL[] jarURLs, ClassLoader cl) {
        List<IOpenClass> values = Collections.emptyList();
        IOpenClass[] internalTypes = values.toArray(new IOpenClass[values.size()]);
        ArrayList classes = new ArrayList();
        classes.addAll(Arrays.asList(OpenLReflectionUtils.getInstanceClasses(internalTypes)));
        classes.addAll(ClassUtils.loadClassesFromJars(jarURLs, cl, this.quietReflectionErrors));
        return ClassSerializer.serialize(classes, this.quietReflectionErrors);
    }

    private List<MessageEntry> exportMessages(Collection<OpenLMessage> messages) {
        return MessageSerializer.serialize(messages);
    }

    public static void main(String[] args) {
        CmdLineProcessor cmdLineProcessor = new CmdLineProcessor();
        CmdLineArgs cmdLineArgs = cmdLineProcessor.parse(args);
        if (cmdLineArgs.hasHelpOption()) {
            cmdLineProcessor.printUsage();
        } else {
            PluginAdaptor adaptor = new PluginAdaptor(cmdLineArgs.getJarpath(), cmdLineArgs.getOutpath(), cmdLineArgs.getSourcepath(), cmdLineArgs.hasExportTypesOption(), cmdLineArgs.hasExportMessagesOption(), cmdLineArgs.getTypesXmlPath(), cmdLineArgs.isQuietReflectionErrors(), cmdLineArgs.isGenerateTypes());
            adaptor.process();
        }
    }
}

