/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.plugin.serialize;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLWarnMessage;
import org.openl.rules.mapping.plugin.serialize.MessageEntry;
import org.openl.source.IOpenSourceCodeModule;

public class MessageSerializer {
    public static MessageEntry serialize(OpenLMessage message) {
        OpenLWarnMessage warnMessage;
        Map<String, String> params;
        OpenLErrorMessage errorMessage;
        IOpenSourceCodeModule module;
        MessageEntry entry = new MessageEntry();
        entry.setMessage(message.getSummary());
        entry.setSeverity(message.getSeverity().toString());
        if (message instanceof OpenLErrorMessage && (module = (errorMessage = (OpenLErrorMessage)message).getError().getSourceModule()) != null && StringUtils.isNotBlank((String)module.getUri())) {
            params = MessageSerializer.getURIParams(module.getUri());
            entry.setFilename(params.get("path"));
            entry.setSheet(params.get("sheet"));
            entry.setCell(params.get("cell"));
        }
        if (message instanceof OpenLWarnMessage && (module = (warnMessage = (OpenLWarnMessage)message).getSource().getModule()) != null && StringUtils.isNotBlank((String)module.getUri())) {
            params = MessageSerializer.getURIParams(module.getUri());
            entry.setFilename(params.get("path"));
            entry.setSheet(params.get("sheet"));
            entry.setCell(params.get("cell"));
        }
        return entry;
    }

    public static List<MessageEntry> serialize(Collection<OpenLMessage> messages) {
        ArrayList<MessageEntry> msgs = new ArrayList<MessageEntry>(messages.size());
        for (OpenLMessage msg : messages) {
            msgs.add(MessageSerializer.serialize(msg));
        }
        return msgs;
    }

    private static Map<String, String> getURIParams(String uri) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            URI u = new URI(uri);
            params.put("path", u.getPath());
            params.putAll(MessageSerializer.getQueryParams(u.getQuery()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return params;
    }

    private static Map<String, String> getQueryParams(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)query)) {
            for (String str : query.split("&")) {
                String[] pair = str.split("=");
                params.put(pair[0], pair[1]);
            }
        }
        return params;
    }
}

