/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.plugin.serialize.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.openl.rules.mapping.plugin.serialize.BeanEntry;
import org.openl.rules.mapping.plugin.serialize.FieldEntry;
import org.openl.rules.mapping.plugin.serialize.MessageEntry;
import org.openl.rules.mapping.plugin.serialize.XmlDocument;

public class XmlWriter {
    public void write(List<BeanEntry> beans, List<MessageEntry> messages, OutputStream out) throws IOException {
        XmlDocument document = new XmlDocument();
        document.setTypes(beans);
        document.setMessages(messages);
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.registerConverter((SingleValueConverter)new ClassConverter());
        xStream.alias("root", XmlDocument.class);
        xStream.alias("type", BeanEntry.class);
        xStream.useAttributeFor(BeanEntry.class, "name");
        xStream.useAttributeFor(BeanEntry.class, "extendedType");
        xStream.aliasField("extends", BeanEntry.class, "extendedType");
        xStream.alias("field", FieldEntry.class);
        xStream.useAttributeFor(FieldEntry.class, "name");
        xStream.useAttributeFor(FieldEntry.class, "type");
        xStream.useAttributeFor(FieldEntry.class, "collectionType");
        xStream.useAttributeFor(FieldEntry.class, "collectionItemType");
        xStream.aliasField("collection-type", FieldEntry.class, "collectionType");
        xStream.aliasField("collection-item-type", FieldEntry.class, "collectionItemType");
        xStream.alias("message", MessageEntry.class);
        xStream.useAttributeFor(MessageEntry.class, "message");
        xStream.useAttributeFor(MessageEntry.class, "severity");
        xStream.useAttributeFor(MessageEntry.class, "filename");
        xStream.useAttributeFor(MessageEntry.class, "sheet");
        xStream.useAttributeFor(MessageEntry.class, "cell");
        xStream.aliasField("value", MessageEntry.class, "message");
        out.write(xStream.toXML((Object)document).getBytes());
    }

    private class ClassConverter
    extends AbstractSingleValueConverter {
        private ClassConverter() {
        }

        public boolean canConvert(Class clazz) {
            return Class.class.equals((Object)clazz);
        }

        public Object fromString(String str) {
            throw new UnsupportedOperationException();
        }

        public String toString(Object obj) {
            Class clazz = (Class)obj;
            if (clazz.isArray()) {
                return clazz.getCanonicalName();
            }
            return ((Class)obj).getName();
        }
    }
}

