/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.plugin.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassUtils {
    private static final Log LOG = LogFactory.getLog(ClassUtils.class);
    private static final String CLASS_FILE_SUFFIX = ".class";

    private ClassUtils() {
    }

    public static List<Class<?>> loadClassesFromJars(URL[] jars, ClassLoader cl, boolean quietReflectionErrors) {
        ArrayList classes = new ArrayList();
        for (URL jar : jars) {
            try {
                classes.addAll(ClassUtils.loadClassesFromJar(jar, cl, quietReflectionErrors));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classes;
    }

    public static List<Class<?>> loadClassesFromJar(URL jar, ClassLoader cl, boolean quietReflectionErrors) {
        ArrayList classes = new ArrayList();
        JarInputStream jarFile = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Processing %s", jar));
        }
        try {
            jarFile = new JarInputStream(jar.openStream());
        }
        catch (IOException e) {
            LOG.error((Object)String.format("File '%s' is not found or cannot be open", jar), (Throwable)e);
        }
        if (jarFile != null) {
            while (true) {
                JarEntry jarEntry;
                block11: {
                    jarEntry = null;
                    try {
                        jarEntry = jarFile.getNextJarEntry();
                    }
                    catch (IOException e) {
                        if (quietReflectionErrors) break block11;
                        LOG.error((Object)String.format("An error occurred while open '%s'", jar), (Throwable)e);
                    }
                }
                if (jarEntry == null) break;
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(CLASS_FILE_SUFFIX)) continue;
                String className = entryName.substring(0, entryName.length() - CLASS_FILE_SUFFIX.length()).replaceAll("/", "\\.");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Loading '%s' class", className));
                }
                try {
                    Class<?> clazz = cl.loadClass(className);
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    if (quietReflectionErrors) continue;
                    LOG.error((Object)String.format("Class '%s' is not found", className), (Throwable)e);
                }
                catch (Throwable e) {
                    if (quietReflectionErrors) continue;
                    LOG.error((Object)String.format("Class '%s' cannot be loaded", className), e);
                }
            }
        }
        return classes;
    }
}

