/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping;

import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.openl.classloader.OpenLClassLoaderHelper;
import org.openl.conf.IOpenLConfiguration;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenLConfiguration;
import org.openl.conf.UserContext;
import org.openl.rules.mapping.RulesTypeResolver;
import org.openl.rules.mapping.TypeResolver;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.java.OpenClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenLReflectionUtils {
    private static final String DEFAULT_OPENL_CONFIGURATION_PREFIX = "org.openl.rules.java::";
    private static final String DEFAULT_USER_HOME = ".";

    private OpenLReflectionUtils() {
    }

    public static TypeResolver getTypeResolver(IOpenClass openClass) {
        if (openClass.getMetaInfo() != null && StringUtils.isNotBlank((String)openClass.getMetaInfo().getSourceUrl())) {
            UserContext userContext = new UserContext(OpenLClassLoaderHelper.getContextClassLoader(), DEFAULT_USER_HOME);
            return OpenLReflectionUtils.getTypeResolver(openClass.getMetaInfo().getSourceUrl(), (IUserContext)userContext);
        }
        return null;
    }

    public static TypeResolver getTypeResolver(String sourceURL, IUserContext userContext) {
        String configName = DEFAULT_OPENL_CONFIGURATION_PREFIX + sourceURL;
        IOpenLConfiguration config = OpenLConfiguration.getInstance((String)configName, (IUserContext)userContext);
        if (config != null) {
            return new RulesTypeResolver(config);
        }
        return null;
    }

    public static IOpenMethod findMatchingAccessibleMethod(IOpenClass clazz, String methodName, Class<?>[] parameterTypes) {
        IOpenClass[] openLParameterTypes = OpenClassHelper.getOpenClasses((IOpenClass)clazz, (Class[])parameterTypes);
        IOpenMethod method = clazz.getMatchingMethod(methodName, openLParameterTypes);
        if (method != null) {
            return method;
        }
        IOpenMethod bestMatch = null;
        Class<?>[] bestMatchParameterTypes = null;
        List methods = clazz.getMethods();
        for (IOpenMethod m : methods) {
            IOpenClass[] openClasses;
            Class[] methodParameterTypes;
            if (!m.getName().equals(methodName) || !ClassUtils.isAssignable((Class[])parameterTypes, (Class[])(methodParameterTypes = OpenClassHelper.getInstanceClasses((IOpenClass[])(openClasses = m.getSignature().getParameterTypes()))), (boolean)true) || bestMatch != null && MemberUtils.compareParameterTypes(methodParameterTypes, bestMatchParameterTypes, parameterTypes) >= 0) continue;
            bestMatch = m;
            bestMatchParameterTypes = parameterTypes;
        }
        return bestMatch;
    }

    public static boolean isAssignableFrom(Class<?> classToCheck, Class<?> fromClass) {
        return ClassUtils.isAssignable(classToCheck, fromClass, (boolean)true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MemberUtils {
        private static final Class<?>[] ORDERED_PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};

        MemberUtils() {
        }

        public static int compareParameterTypes(Class<?>[] left, Class<?>[] right, Class<?>[] actual) {
            float rightCost;
            float leftCost = MemberUtils.getTotalTransformationCost(actual, left);
            return leftCost < (rightCost = MemberUtils.getTotalTransformationCost(actual, right)) ? -1 : (rightCost < leftCost ? 1 : 0);
        }

        private static float getTotalTransformationCost(Class<?>[] srcArgs, Class<?>[] destArgs) {
            float totalCost = 0.0f;
            for (int i = 0; i < srcArgs.length; ++i) {
                Class<?> srcClass = srcArgs[i];
                Class<?> destClass = destArgs[i];
                totalCost += MemberUtils.getObjectTransformationCost(srcClass, destClass);
            }
            return totalCost;
        }

        private static float getObjectTransformationCost(Class<?> srcClass, Class<?> destClass) {
            if (destClass.isPrimitive()) {
                return MemberUtils.getPrimitivePromotionCost(srcClass, destClass);
            }
            float cost = 0.0f;
            while (srcClass != null && !destClass.equals(srcClass)) {
                if (destClass.isInterface() && ClassUtils.isAssignable(srcClass, destClass)) {
                    cost += 0.25f;
                    break;
                }
                cost += 1.0f;
                srcClass = srcClass.getSuperclass();
            }
            if (srcClass == null) {
                cost += 1.5f;
            }
            return cost;
        }

        private static float getPrimitivePromotionCost(Class<?> srcClass, Class<?> destClass) {
            float cost = 0.0f;
            Class<?> cls = srcClass;
            if (!cls.isPrimitive()) {
                cost += 0.1f;
                cls = ClassUtils.wrapperToPrimitive(cls);
            }
            for (int i = 0; cls != destClass && i < ORDERED_PRIMITIVE_TYPES.length; ++i) {
                if (cls != ORDERED_PRIMITIVE_TYPES[i]) continue;
                cost += 0.1f;
                if (i >= ORDERED_PRIMITIVE_TYPES.length - 1) continue;
                cls = ORDERED_PRIMITIVE_TYPES[i + 1];
            }
            return cost;
        }
    }
}

