/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.loader;

import org.apache.commons.lang.StringUtils;
import org.openl.rules.mapping.Mapping;

public final class MappingIdFactory {
    private MappingIdFactory() {
    }

    public static String createMappingId(Mapping mapping) {
        StringBuilder result = new StringBuilder();
        result.append(mapping.getClassA().getName());
        result.append(".");
        Object[] fieldA = mapping.getFieldA();
        if (fieldA == null || fieldA.length == 0) {
            result.append("<noname>");
        } else if (fieldA.length == 1) {
            result.append((String)fieldA[0]);
        } else {
            String fieldName = StringUtils.join((Object[])fieldA, (String)",");
            result.append("[" + fieldName + "]");
        }
        result.append("->");
        result.append(mapping.getClassB().getName());
        result.append(".");
        if (StringUtils.isEmpty((String)mapping.getFieldB())) {
            result.append("<noname>");
        } else {
            result.append(mapping.getFieldB());
        }
        if (StringUtils.isNotBlank((String)mapping.getMapId())) {
            result.append(" (map id: " + mapping.getMapId() + ")");
        }
        return result.toString();
    }
}

