/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.loader;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.dozer.CollectionItemDiscriminator;
import org.dozer.CustomConverter;
import org.dozer.FieldMappingCondition;
import org.openl.rules.mapping.ClassMappingConfiguration;
import org.openl.rules.mapping.Converter;
import org.openl.rules.mapping.GlobalConfiguration;
import org.openl.rules.mapping.Mapping;
import org.openl.rules.mapping.TypeResolver;
import org.openl.rules.mapping.definition.BeanMap;
import org.openl.rules.mapping.definition.BeanMapConfiguration;
import org.openl.rules.mapping.definition.CollectionItemDiscriminatorDescriptor;
import org.openl.rules.mapping.definition.ConditionDescriptor;
import org.openl.rules.mapping.definition.Configuration;
import org.openl.rules.mapping.definition.ConverterDescriptor;
import org.openl.rules.mapping.definition.FieldMap;
import org.openl.rules.mapping.exception.RulesMappingException;
import org.openl.rules.mapping.loader.BeanMapKeyFactory;
import org.openl.rules.mapping.loader.MappingDefinitionUtils;
import org.openl.rules.mapping.loader.MappingIdFactory;
import org.openl.rules.mapping.loader.condition.ConditionFactory;
import org.openl.rules.mapping.loader.converter.ConverterFactory;
import org.openl.rules.mapping.loader.converter.ConverterIdFactory;
import org.openl.rules.mapping.loader.discriminator.CollectionItemDiscriminatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesMappingsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(RulesMappingsLoader.class);
    private Class<?> instanceClass;
    private Object instance;
    private TypeResolver typeResolver;
    private Map<String, ConverterDescriptor> customConvertersMap = new HashMap<String, ConverterDescriptor>();

    public RulesMappingsLoader(Class<?> instanceClass, Object instance, TypeResolver typeResolver) {
        this.instanceClass = instanceClass;
        this.instance = instance;
        this.typeResolver = typeResolver;
    }

    public Collection<BeanMap> loadMappings(Map<String, BeanMapConfiguration> mappingConfigurations, Configuration globalConfiguration) {
        List<Mapping> mappings = this.findDeclarations(this.instanceClass, this.instance, Mapping.class);
        if (LOG.isDebugEnabled()) {
            Collection mappingNames = CollectionUtils.collect(mappings, (Transformer)new Transformer(){

                public String transform(Object arg) {
                    Mapping mapping = (Mapping)arg;
                    return MappingIdFactory.createMappingId(mapping);
                }
            });
            LOG.debug("Found mapping declarations:\n" + StringUtils.join((Collection)mappingNames, (String)",\n"));
        }
        return this.processMappings(mappings, mappingConfigurations, globalConfiguration);
    }

    public Configuration loadConfiguration() {
        List<GlobalConfiguration> globalConfigurations = this.findDeclarations(this.instanceClass, this.instance, GlobalConfiguration.class);
        return this.processConfiguration(globalConfigurations);
    }

    public Map<String, BeanMapConfiguration> loadBeanMapConfiguraitons(Configuration globalConfiguration) {
        List<ClassMappingConfiguration> configs = this.findDeclarations(this.instanceClass, this.instance, ClassMappingConfiguration.class);
        return this.processClassConfigurations(configs, globalConfiguration);
    }

    private Map<String, BeanMapConfiguration> processClassConfigurations(List<ClassMappingConfiguration> configs, Configuration globalConfiguration) {
        HashMap<String, BeanMapConfiguration> beanMapConfigs = new HashMap<String, BeanMapConfiguration>();
        for (ClassMappingConfiguration classConfiguration : configs) {
            Class<?> srcClass = classConfiguration.getClassA();
            Class<?> destClass = classConfiguration.getClassB();
            BeanMapConfiguration beanMapConfiguration = this.createBeanMapConfiguration(srcClass, destClass, globalConfiguration);
            beanMapConfiguration.setDateFormat(classConfiguration.getDateFormat());
            beanMapConfiguration.setMapEmptyStrings(classConfiguration.getMapEmptyStrings());
            beanMapConfiguration.setMapNulls(classConfiguration.getMapNulls());
            beanMapConfiguration.setRequiredFields(classConfiguration.getRequiredFields());
            beanMapConfiguration.setRequiredFields(classConfiguration.getRequiredFields());
            beanMapConfiguration.setTrimStrings(classConfiguration.getTrimStrings());
            beanMapConfiguration.setWildcard(classConfiguration.getWildcard());
            beanMapConfiguration.setClassABeanFactory(classConfiguration.getClassABeanFactory());
            beanMapConfiguration.setClassBBeanFactory(classConfiguration.getClassBBeanFactory());
            String key = BeanMapKeyFactory.createKey(srcClass, destClass);
            beanMapConfigs.put(key, beanMapConfiguration);
            String reverseKey = BeanMapKeyFactory.createKey(destClass, srcClass);
            if (beanMapConfigs.get(reverseKey) != null) continue;
            beanMapConfigs.put(reverseKey, this.reverseBeanMapConfiguration(beanMapConfiguration));
        }
        return beanMapConfigs;
    }

    public Collection<ConverterDescriptor> loadDefaultConverters() {
        List<Converter> defaultConverters = this.findDeclarations(this.instanceClass, this.instance, Converter.class);
        return this.processDefaultConverters(defaultConverters);
    }

    private <T> List<T> findDeclarations(Class<?> instanceClass, Object instance, Class<T> declarationType) {
        ArrayList<Object> declarations = new ArrayList<Object>();
        Collection<Method> methods = this.findDeclarationMethods(instanceClass, declarationType);
        for (Method method : methods) {
            Object[] declarationsArray;
            try {
                declarationsArray = (Object[])method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RulesMappingException("Cannot load declarations", e);
            }
            declarations.addAll(Arrays.asList(declarationsArray));
        }
        return declarations;
    }

    private Collection<Method> findDeclarationMethods(Class<?> instanceClass, final Class<?> declarationType) {
        Method[] methods = instanceClass.getMethods();
        Predicate predicate = new Predicate(){

            public boolean evaluate(Object arg0) {
                Method method = (Method)arg0;
                return method.getReturnType().isArray() && method.getReturnType().getComponentType() == declarationType;
            }
        };
        ArrayList<Method> declarations = new ArrayList<Method>();
        CollectionUtils.select(Arrays.asList(methods), (Predicate)predicate, declarations);
        return declarations;
    }

    private Collection<BeanMap> processMappings(Collection<Mapping> mappings, Map<String, BeanMapConfiguration> mappingConfigurations, Configuration globalConfiguration) {
        Map<String, BeanMap> beanMappings = this.getPreDefinedBeanMappingsByConfiguration(mappingConfigurations);
        for (Mapping originalMapping : mappings) {
            Mapping reverseMapping;
            String reverseMappingId;
            String mappingId;
            Class<?> classB;
            Mapping mapping = MappingDefinitionUtils.normalizeMapping(originalMapping);
            Class<?> classA = mapping.getClassA();
            String beanMapKey = BeanMapKeyFactory.createKey(classA, classB = mapping.getClassB());
            BeanMap beanMapping = beanMappings.get(beanMapKey);
            if (beanMapping == null) {
                beanMapping = this.createBeanMap(classA, classB);
                BeanMapConfiguration beanMappingConfiguration = this.createBeanMapConfiguration(classA, classB, globalConfiguration);
                beanMapping.setConfiguration(beanMappingConfiguration);
                beanMappings.put(beanMapKey, beanMapping);
            }
            if (!beanMapping.hasFieldMap(mappingId = MappingIdFactory.createMappingId(mapping))) {
                beanMapping.addFieldMap(mappingId, this.createFieldMap(mapping, beanMapping));
            }
            if (mapping.getOneWay() != null && mapping.getOneWay().booleanValue()) continue;
            String reverseMappingKey = BeanMapKeyFactory.createKey(classB, classA);
            BeanMap reverseBeanMapping = beanMappings.get(reverseMappingKey);
            if (reverseBeanMapping == null) {
                reverseBeanMapping = this.createBeanMap(classB, classA);
                reverseBeanMapping.setConfiguration(this.reverseBeanMapConfiguration(beanMapping.getConfiguration()));
                beanMappings.put(reverseMappingKey, reverseBeanMapping);
            }
            if (reverseBeanMapping.hasFieldMap(reverseMappingId = MappingIdFactory.createMappingId(reverseMapping = MappingDefinitionUtils.reverseMapping(mapping)))) continue;
            reverseBeanMapping.addFieldMap(reverseMappingId, this.createFieldMap(reverseMapping, reverseBeanMapping));
        }
        return beanMappings.values();
    }

    private BeanMapConfiguration createBeanMapConfiguration(Class<?> classA, Class<?> classB, Configuration globalConfiguration) {
        BeanMapConfiguration config = new BeanMapConfiguration();
        config.setClassA(classA);
        config.setClassB(classB);
        config.setGlobalConfiguration(globalConfiguration);
        return config;
    }

    private BeanMapConfiguration reverseBeanMapConfiguration(BeanMapConfiguration beanMapConfiguration) {
        BeanMapConfiguration reverseConfig = this.createBeanMapConfiguration(beanMapConfiguration.getClassB(), beanMapConfiguration.getClassA(), beanMapConfiguration.getGlobalConfiguration());
        reverseConfig.setClassABeanFactory(beanMapConfiguration.getClassBBeanFactory());
        reverseConfig.setClassBBeanFactory(beanMapConfiguration.getClassABeanFactory());
        reverseConfig.setDateFormat(beanMapConfiguration.getDateFormat());
        reverseConfig.setMapEmptyStrings(beanMapConfiguration.isMapEmptyStrings());
        reverseConfig.setMapNulls(beanMapConfiguration.isMapNulls());
        reverseConfig.setRequiredFields(beanMapConfiguration.isRequiredFields());
        reverseConfig.setTrimStrings(beanMapConfiguration.isTrimStrings());
        reverseConfig.setWildcard(beanMapConfiguration.isWildcard());
        return reverseConfig;
    }

    private Map<String, BeanMap> getPreDefinedBeanMappingsByConfiguration(Map<String, BeanMapConfiguration> mappingConfigurations) {
        HashMap<String, BeanMap> beanMappings = new HashMap<String, BeanMap>();
        for (Map.Entry<String, BeanMapConfiguration> entry : mappingConfigurations.entrySet()) {
            String key = entry.getKey();
            BeanMapConfiguration configuration = entry.getValue();
            BeanMap beanMap = this.createBeanMap(configuration.getClassA(), configuration.getClassB());
            beanMap.setConfiguration(configuration);
            beanMappings.put(key, beanMap);
        }
        return beanMappings;
    }

    private Configuration processConfiguration(List<GlobalConfiguration> globalConfigurations) {
        if (globalConfigurations.size() > 1) {
            throw new RulesMappingException("Found more than 1 global configuration definition");
        }
        Configuration configuration = new Configuration();
        for (GlobalConfiguration globalConfiguration : globalConfigurations) {
            configuration.setDateFormat(globalConfiguration.getDateFormat());
            configuration.setMapEmptyStrings(globalConfiguration.getMapEmptyStrings());
            configuration.setMapNulls(globalConfiguration.getMapNulls());
            configuration.setRequiredFields(globalConfiguration.getRequiredFields());
            configuration.setTrimStrings(globalConfiguration.getTrimStrings());
            configuration.setWildcard(globalConfiguration.getWildcard());
        }
        return configuration;
    }

    private Collection<ConverterDescriptor> processDefaultConverters(List<Converter> defaultConverters) {
        ArrayList<ConverterDescriptor> descriptors = new ArrayList<ConverterDescriptor>();
        for (Converter converter : defaultConverters) {
            String id = ConverterIdFactory.createConverterId(converter);
            ConverterDescriptor customConverter = null;
            customConverter = this.customConvertersMap.containsKey(id) ? this.customConvertersMap.get(id) : this.createConverterDescriptor(id, converter.getConvertMethod(), converter.getClassA(), converter.getClassB());
            descriptors.add(customConverter);
        }
        return descriptors;
    }

    private BeanMap createBeanMap(Class<?> classA, Class<?> classB) {
        BeanMap beanMapping = new BeanMap();
        beanMapping.setSrcClass(classA);
        beanMapping.setDestClass(classB);
        return beanMapping;
    }

    private FieldMap createFieldMap(Mapping mapping, BeanMap beanMap) {
        FieldMap fieldMapping = new FieldMap();
        fieldMapping.setBeanMap(beanMap);
        fieldMapping.setSrc(mapping.getFieldA());
        fieldMapping.setDest(mapping.getFieldB());
        fieldMapping.setMapNulls(mapping.getMapNulls());
        fieldMapping.setMapEmptyStrings(mapping.getMapEmptyStrings());
        fieldMapping.setRequired(mapping.getFieldBRequired());
        fieldMapping.setDefaultValue(mapping.getFieldBDefaultValue());
        fieldMapping.setSrcHint(mapping.getFieldAHint());
        fieldMapping.setDestHint(mapping.getFieldBHint());
        fieldMapping.setSrcType(mapping.getFieldAType());
        fieldMapping.setDestType(mapping.getFieldBType());
        fieldMapping.setTrimStrings(mapping.getTrimStrings());
        fieldMapping.setSrcDateFormat(mapping.getFieldADateFormat());
        fieldMapping.setDestDateFormat(mapping.getFieldBDateFormat());
        fieldMapping.setMapId(mapping.getMapId());
        if (StringUtils.isNotEmpty((String)mapping.getFieldBCreateMethod()) && MappingDefinitionUtils.getTypeName(mapping.getFieldBCreateMethod()) != null) {
            String typeName = MappingDefinitionUtils.getTypeName(mapping.getFieldBCreateMethod());
            Class<?> clazz = this.getType(typeName);
            fieldMapping.setCreateMethod(clazz.getName() + "." + MappingDefinitionUtils.getMethodName(mapping.getFieldBCreateMethod()));
        } else {
            fieldMapping.setCreateMethod(mapping.getFieldBCreateMethod());
        }
        if (!StringUtils.isBlank((String)mapping.getConvertMethodABId())) {
            ConverterDescriptor converterDescriptor = this.createConverterDescriptor(mapping.getConvertMethodABId(), null, null, null);
            fieldMapping.setConverter(converterDescriptor);
        } else if (!StringUtils.isBlank((String)mapping.getConvertMethodAB())) {
            String converterId = MappingIdFactory.createMappingId(mapping);
            ConverterDescriptor converterDescriptor = this.createConverterDescriptor(converterId, mapping.getConvertMethodAB(), mapping.getClassA(), mapping.getClassB());
            fieldMapping.setConverter(converterDescriptor);
        }
        if (!StringUtils.isBlank((String)mapping.getConditionABId())) {
            ConditionDescriptor conditionDescriptor = this.createConditionDescriptor(mapping.getConditionABId(), null);
            fieldMapping.setCondition(conditionDescriptor);
        } else if (!StringUtils.isBlank((String)mapping.getConditionAB())) {
            String conditionId = MappingIdFactory.createMappingId(mapping);
            ConditionDescriptor conditionDescriptor = this.createConditionDescriptor(conditionId, mapping.getConditionAB());
            fieldMapping.setCondition(conditionDescriptor);
        }
        if (!StringUtils.isBlank((String)mapping.getFieldBDiscriminatorId())) {
            CollectionItemDiscriminatorDescriptor discriminatorDescriptor = this.createDiscriminatorDescriptor(mapping.getFieldBDiscriminatorId(), null);
            fieldMapping.setCollectionItemDiscriminator(discriminatorDescriptor);
        } else if (!StringUtils.isBlank((String)mapping.getFieldBDiscriminator())) {
            String discriminatorId = MappingIdFactory.createMappingId(mapping);
            CollectionItemDiscriminatorDescriptor discriminatorDescriptor = this.createDiscriminatorDescriptor(discriminatorId, mapping.getFieldBDiscriminator());
            fieldMapping.setCollectionItemDiscriminator(discriminatorDescriptor);
        }
        return fieldMapping;
    }

    private ConverterDescriptor createConverterDescriptor(String converterId, String convertMethod, Class<?> srcType, Class<?> destType) {
        CustomConverter converter = null;
        if (StringUtils.isNotEmpty((String)convertMethod)) {
            String typeName = MappingDefinitionUtils.getTypeName(convertMethod);
            if (typeName != null) {
                Class<?> convertClass = this.getType(typeName);
                converter = ConverterFactory.createConverter(MappingDefinitionUtils.getMethodName(convertMethod), convertClass, null);
            } else {
                converter = ConverterFactory.createConverter(convertMethod, this.instanceClass, this.instance);
            }
        }
        return new ConverterDescriptor(converterId, converter, srcType, destType);
    }

    private ConditionDescriptor createConditionDescriptor(String conditionId, String conditionMethod) {
        FieldMappingCondition condition = null;
        if (StringUtils.isNotEmpty((String)conditionMethod)) {
            String typeName = MappingDefinitionUtils.getTypeName(conditionMethod);
            if (typeName != null) {
                Class<?> conditionClass = this.getType(typeName);
                condition = ConditionFactory.createCondition(MappingDefinitionUtils.getMethodName(conditionMethod), conditionClass, this.instance);
            } else {
                condition = ConditionFactory.createCondition(conditionMethod, this.instanceClass, this.instance);
            }
        }
        return new ConditionDescriptor(conditionId, condition);
    }

    private CollectionItemDiscriminatorDescriptor createDiscriminatorDescriptor(String discriminatorId, String discriminatorMethod) {
        CollectionItemDiscriminator discriminator = null;
        if (StringUtils.isNotEmpty((String)discriminatorMethod)) {
            String typeName = MappingDefinitionUtils.getTypeName(discriminatorMethod);
            if (typeName != null) {
                Class<?> discriminatorClass = this.getType(typeName);
                discriminator = CollectionItemDiscriminatorFactory.createDiscriminator(MappingDefinitionUtils.getMethodName(discriminatorMethod), discriminatorClass, this.instance);
            } else {
                discriminator = CollectionItemDiscriminatorFactory.createDiscriminator(discriminatorMethod, this.instanceClass, this.instance);
            }
        }
        return new CollectionItemDiscriminatorDescriptor(discriminatorId, discriminator);
    }

    private Class<?> getType(String typeName) {
        Class<?> conditionClass = this.typeResolver.findClass(typeName);
        if (conditionClass == null) {
            throw new RulesMappingException(String.format("Type '%s' not found", typeName));
        }
        return conditionClass;
    }
}

