/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.loader.converter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.openl.rules.mapping.exception.RulesMappingException;
import org.openl.rules.mapping.loader.ProxyMethodHandler;
import org.openl.rules.mapping.loader.converter.DefaultConvertMethodHandler;
import org.openl.rules.mapping.loader.converter.MappingParamsAwareConvertMethodHandler;
import org.openl.rules.mapping.loader.converter.SimpleConvertMethodHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CustomConverterInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CustomConverterInvocationHandler.class);
    private static final ProxyMethodHandler[] handlers = new ProxyMethodHandler[]{new MappingParamsAwareConvertMethodHandler(), new SimpleConvertMethodHandler(), new DefaultConvertMethodHandler()};
    private final Class<?> instanceClass;
    private final Object instance;
    private final String convertMethodName;
    private ProxyMethodHandler convertMethodHandler;
    private Method convertMethod;

    public CustomConverterInvocationHandler(String convertMethodName, Class<?> instanceClass, Object instance) {
        this.instanceClass = instanceClass;
        this.instance = instance;
        this.convertMethodName = convertMethodName;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        for (ProxyMethodHandler handler : handlers) {
            Method matchingMethod;
            if (!handler.canHandle(method) || handler == this.convertMethodHandler || (matchingMethod = handler.findMatchingMethod(this.instanceClass, this.convertMethodName, args)) == null) continue;
            this.convertMethodHandler = handler;
            this.convertMethod = matchingMethod;
            break;
        }
        if (this.convertMethod == null) {
            throw new RulesMappingException(String.format("Cannot find convert method with name '%s'", this.convertMethodName));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Getting ready to invoke custom converter method: %s", this.convertMethod));
        }
        return this.convertMethodHandler.invoke(this.instance, this.convertMethod, args);
    }
}

