/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileExtractor {
    private static final Log LOG = LogFactory.getLog(FileExtractor.class);
    private static final String TEMP_FILE_PREFIX = "mapping";
    private static final String TEMP_FILE_SUFFIX = ".xls";

    private FileExtractor() {
    }

    public static File extractFile(Class mapperClass, String pathInJar) throws IOException {
        InputStream is = mapperClass.getResourceAsStream(pathInJar);
        return FileExtractor.copyFileStream(is);
    }

    public static File extractFile(String pathInJar) throws IOException {
        Class mappingClass = FileExtractor.getCallerClass();
        return FileExtractor.extractFile(mappingClass, pathInJar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFileStream(InputStream is) throws IOException {
        File file;
        FileOutputStream out = null;
        try {
            File tempFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            tempFile.deleteOnExit();
            out = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)is, (OutputStream)out);
            file = tempFile;
        }
        catch (Throwable throwable) {
            FileExtractor.closeQuietly(is);
            FileExtractor.closeQuietly(out);
            throw throwable;
        }
        FileExtractor.closeQuietly(is);
        FileExtractor.closeQuietly(out);
        return file;
    }

    private static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error closing input stream", (Throwable)e);
        }
    }

    private static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error closing output stream", (Throwable)e);
        }
    }

    private static Class getCallerClass() {
        return new Throwable().getStackTrace()[2].getClass();
    }
}

