/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.DozerEventListener;
import org.dozer.FieldMappingCondition;
import org.openl.ICompileContext;
import org.openl.rules.mapping.FileExtractor;
import org.openl.rules.mapping.Mapper;
import org.openl.rules.mapping.OpenLReflectionUtils;
import org.openl.rules.mapping.RulesBeanMapper;
import org.openl.rules.mapping.TypeResolver;
import org.openl.rules.mapping.exception.RulesMappingException;
import org.openl.rules.mapping.validation.MappingBeanValidator;
import org.openl.rules.mapping.validation.OpenLDataBeanValidator;
import org.openl.rules.runtime.ApiBasedRulesEngineFactory;
import org.openl.runtime.AOpenLEngineFactory;
import org.openl.runtime.ASourceCodeEngineFactory;
import org.openl.syntax.exception.CompositeOpenlException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.validation.IOpenLValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RulesBeanMapperFactory {
    private RulesBeanMapperFactory() {
    }

    public static Mapper createMapperInstance(File source) {
        return RulesBeanMapperFactory.createMapperInstance(source, null, null);
    }

    public static Mapper createMapperInstance(File source, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId) {
        return RulesBeanMapperFactory.createMapperInstance(source, customConvertersWithId, conditionsWithId, null, null, true);
    }

    public static Mapper createMapperInstance(File source, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId, Map<String, BeanFactory> factories) {
        return RulesBeanMapperFactory.createMapperInstance(source, customConvertersWithId, conditionsWithId, factories, null, true);
    }

    public static Mapper createMapperInstance(File source, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId, List<DozerEventListener> eventListeners) {
        return RulesBeanMapperFactory.createMapperInstance(source, customConvertersWithId, conditionsWithId, null, eventListeners, true);
    }

    public static Mapper createMapperInstance(File source, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId, Map<String, BeanFactory> factories, boolean executionMode) {
        return RulesBeanMapperFactory.createMapperInstance(source, customConvertersWithId, conditionsWithId, factories, null, executionMode);
    }

    public static Mapper createMapperInstance(File source, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId, Map<String, BeanFactory> factories, List<DozerEventListener> eventListeners) {
        return RulesBeanMapperFactory.createMapperInstance(source, customConvertersWithId, conditionsWithId, factories, eventListeners, true);
    }

    public static Mapper createMapperInstance(File source, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId, Map<String, BeanFactory> factories, List<DozerEventListener> eventListeners, boolean executionMode) {
        try {
            ApiBasedRulesEngineFactory factory = RulesBeanMapperFactory.initEngine(source, executionMode);
            Class instanceClass = factory.getInterfaceClass();
            Object instance = factory.makeInstance();
            if (factory.getCompiledOpenClass().hasErrors()) {
                List messages = factory.getCompiledOpenClass().getMessages();
                throw new CompositeOpenlException("Compilation failed", new SyntaxNodeException[0], messages);
            }
            TypeResolver typeResolver = null;
            typeResolver = executionMode ? RulesBeanMapperFactory.getTypeResolver((ASourceCodeEngineFactory)factory) : OpenLReflectionUtils.getTypeResolver(factory.getCompiledOpenClass().getOpenClass());
            return new RulesBeanMapper(instanceClass, instance, typeResolver, customConvertersWithId, conditionsWithId, factories, eventListeners);
        }
        catch (Exception e) {
            throw new RulesMappingException(String.format("Cannot load mapping definitions from file: %s", source.getAbsolutePath()), e);
        }
    }

    public static Mapper createMapperInstance(InputStream source) {
        return RulesBeanMapperFactory.createMapperInstance(source, null, null);
    }

    public static Mapper createMapperInstance(InputStream source, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId) {
        return RulesBeanMapperFactory.createMapperInstance(source, customConvertersWithId, conditionsWithId, true);
    }

    public static Mapper createMapperInstance(InputStream source, Map<String, CustomConverter> customConvertersWithId, Map<String, FieldMappingCondition> conditionsWithId, boolean executionMode) {
        try {
            File mappingConfiguration = FileExtractor.copyFileStream(source);
            ApiBasedRulesEngineFactory factory = RulesBeanMapperFactory.initEngine(mappingConfiguration, executionMode);
            Class instanceClass = factory.getInterfaceClass();
            Object instance = factory.makeInstance();
            if (factory.getCompiledOpenClass().hasErrors()) {
                List messages = factory.getCompiledOpenClass().getMessages();
                throw new CompositeOpenlException("Compilation failed", new SyntaxNodeException[0], messages);
            }
            TypeResolver typeResolver = null;
            typeResolver = executionMode ? RulesBeanMapperFactory.getTypeResolver((ASourceCodeEngineFactory)factory) : OpenLReflectionUtils.getTypeResolver(factory.getCompiledOpenClass().getOpenClass());
            return new RulesBeanMapper(instanceClass, instance, typeResolver, customConvertersWithId, conditionsWithId);
        }
        catch (Exception e) {
            throw new RulesMappingException("Cannot load mapping definitions from input stream", e);
        }
    }

    public static ApiBasedRulesEngineFactory initEngine(File source, boolean executionMode) {
        boolean validationEnabled;
        ApiBasedRulesEngineFactory factory = new ApiBasedRulesEngineFactory(source);
        factory.setExecutionMode(executionMode);
        ICompileContext compileContext = factory.getOpenL().getCompileContext();
        boolean bl = validationEnabled = compileContext != null && compileContext.isValidationEnabled();
        if (!executionMode && validationEnabled) {
            RulesBeanMapperFactory.registerTypeValidator((AOpenLEngineFactory)factory, new MappingBeanValidator());
        }
        return factory;
    }

    private static synchronized void registerTypeValidator(AOpenLEngineFactory factory, OpenLDataBeanValidator<?> validator) {
        for (IOpenLValidator regValidator : factory.getOpenL().getCompileContext().getValidators()) {
            if (regValidator.getClass() != validator.getClass()) continue;
            return;
        }
        factory.getOpenL().getCompileContext().addValidator(validator);
    }

    private static TypeResolver getTypeResolver(ASourceCodeEngineFactory factory) {
        return OpenLReflectionUtils.getTypeResolver(factory.getSourceCode().getUri(0), factory.getUserContext());
    }
}

