/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.openapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import org.openl.CompiledOpenClass;
import org.openl.classloader.OpenLClassLoader;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.openapi.OpenAPIConfiguration;
import org.openl.rules.project.IRulesDeploySerializer;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RuntimeContextInstantiationStrategyEnhancer;
import org.openl.rules.project.instantiation.variation.VariationInstantiationStrategyEnhancer;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.project.openapi.OpenApiGenerationException;
import org.openl.rules.project.resolving.ProjectResource;
import org.openl.rules.project.resolving.ProjectResourceLoader;
import org.openl.rules.project.xml.XmlRulesDeploySerializer;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactoryHelper;
import org.openl.rules.ruleservice.core.interceptors.DynamicInterfaceAnnotationEnhancerHelper;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSOpenLServiceEnhancerHelper;
import org.openl.rules.serialization.ProjectJacksonObjectMapperFactoryBean;
import org.openl.types.IOpenClass;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiGenerator.class);
    private static final String RULES_DEPLOY_XML = "rules-deploy.xml";
    private final Reader reader = new Reader();
    private final ProjectDescriptor projectDescriptor;
    private final RulesInstantiationStrategy instantiationStrategy;
    private final CompiledOpenClass compiledOpenClass;
    private final IOpenClass openClass;
    private final boolean provideRuntimeContext;
    private final boolean provideVariations;
    private final IRulesDeploySerializer rulesDeploySerializer = new XmlRulesDeploySerializer();
    private RulesDeploy rulesDeploy;
    private ClassLoader classLoader;

    private OpenApiGenerator(ProjectDescriptor projectDescriptor, RulesInstantiationStrategy instantiationStrategy, boolean provideRuntimeContext, boolean provideVariations) throws RulesInstantiationException {
        this.projectDescriptor = projectDescriptor;
        this.instantiationStrategy = instantiationStrategy;
        this.compiledOpenClass = instantiationStrategy.compile();
        this.openClass = this.compiledOpenClass.getOpenClass();
        this.provideRuntimeContext = provideRuntimeContext;
        this.provideVariations = provideVariations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenAPI generate() throws RulesInstantiationException, OpenApiGenerationException {
        ClassLoader serviceClassLoader = this.resolveServiceClassLoader(this.instantiationStrategy);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(serviceClassLoader);
            RulesInstantiationStrategy enhancedInstantiationStrategy = this.enhanceRulesInstantiationStrategy(this.instantiationStrategy, this.isProvidedRuntimeContext(), this.isProvideVariations());
            Class<?> serviceClass = this.resolveInterface(enhancedInstantiationStrategy);
            ObjectMapper objectMapper = this.createObjectMapper(serviceClassLoader);
            Class<?> enhancedServiceClass = this.enhanceWithJAXRS(serviceClass, enhancedInstantiationStrategy.instantiate(), serviceClassLoader);
            Map<Method, Method> methodMap = this.buildMethodMapWithJAXRS(serviceClass, enhancedServiceClass);
            if (methodMap.isEmpty()) {
                throw new OpenApiGenerationException("There are no public methods. Check the provided rules, annotation template class, and included/excluded methods in module settings.");
            }
            OpenAPI openAPI = OpenAPIConfiguration.generateOpenAPI(enhancedServiceClass, (ObjectMapper)objectMapper);
            return openAPI;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private ProjectResource loadProjectResource(ProjectResourceLoader projectResourceLoader, String name) {
        ProjectResource[] projectResources = projectResourceLoader.loadResource(name);
        return Arrays.stream(projectResources).filter(e -> Objects.equals(e.getProjectDescriptor().getName(), this.projectDescriptor.getName())).findFirst().orElse(null);
    }

    private RulesDeploy loadRulesDeploy() {
        ProjectResourceLoader projectResourceLoader = new ProjectResourceLoader(this.compiledOpenClass);
        ProjectResource projectResource = this.loadProjectResource(projectResourceLoader, RULES_DEPLOY_XML);
        if (projectResource != null) {
            try {
                return this.rulesDeploySerializer.deserialize((InputStream)new FileInputStream(projectResource.getFile()));
            }
            catch (FileNotFoundException | JAXBException e) {
                LOG.debug("Ignored error: ", e);
                return null;
            }
        }
        return null;
    }

    private RulesDeploy getRulesDeploy() {
        if (this.rulesDeploy == null) {
            this.rulesDeploy = this.loadRulesDeploy();
        }
        return this.rulesDeploy;
    }

    private ClassLoader resolveServiceClassLoader(RulesInstantiationStrategy instantiationStrategy) throws RulesInstantiationException {
        if (this.classLoader == null) {
            OpenLClassLoader moduleGeneratedClassesClassLoader = ((XlsModuleOpenClass)instantiationStrategy.compile().getOpenClass()).getClassGenerationClassLoader();
            OpenLClassLoader openLClassLoader = new OpenLClassLoader(null);
            openLClassLoader.addClassLoader((ClassLoader)moduleGeneratedClassesClassLoader);
            openLClassLoader.addClassLoader(instantiationStrategy.getClassLoader());
            this.classLoader = openLClassLoader;
        }
        return this.classLoader;
    }

    protected RulesInstantiationStrategy enhanceRulesInstantiationStrategy(RulesInstantiationStrategy rulesInstantiationStrategy, boolean provideRuntimeContext, boolean provideVariations) {
        if (provideVariations) {
            rulesInstantiationStrategy = new VariationInstantiationStrategyEnhancer(rulesInstantiationStrategy);
        }
        if (provideRuntimeContext) {
            rulesInstantiationStrategy = new RuntimeContextInstantiationStrategyEnhancer(rulesInstantiationStrategy);
        }
        return rulesInstantiationStrategy;
    }

    private Class<?> resolveInterface(RulesInstantiationStrategy instantiationStrategy) throws RulesInstantiationException, OpenApiGenerationException {
        RulesDeploy rulesDeployValue = this.getRulesDeploy();
        Optional<String> serviceClassName = Optional.ofNullable(rulesDeployValue).map(RulesDeploy::getServiceClass).map(StringUtils::trimToNull);
        if (serviceClassName.isPresent()) {
            try {
                Class<?> serviceClass = this.compiledOpenClass.getClassLoader().loadClass(serviceClassName.get());
                if (serviceClass.isInterface()) {
                    return serviceClass;
                }
                throw new OpenApiGenerationException(String.format("Interface is expected for service class '%s', but class is found.", serviceClassName));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new OpenApiGenerationException(String.format("An error is occurred during loading a service class '%s'.%s", serviceClassName, StringUtils.isNotBlank((CharSequence)e.getMessage()) ? " " + e.getMessage() : ""));
            }
        }
        String templateClassName = Optional.ofNullable(rulesDeployValue).map(RulesDeploy::getAnnotationTemplateClassName).map(StringUtils::trimToNull).orElseGet(() -> Optional.ofNullable(rulesDeployValue).map(RulesDeploy::getInterceptingTemplateClassName).map(StringUtils::trimToNull).orElse(null));
        Class serviceClass = instantiationStrategy.getInstanceClass();
        ClassLoader resolveServiceClassLoader = this.resolveServiceClassLoader(instantiationStrategy);
        if (!StringUtils.isEmpty((CharSequence)templateClassName)) {
            try {
                Class<?> templateClass = resolveServiceClassLoader.loadClass(templateClassName);
                if (!templateClass.isInterface() && !Modifier.isAbstract(templateClass.getModifiers())) {
                    throw new OpenApiGenerationException(String.format("Interface or abstract class is expected for annotation template class '%s', but class is found.", templateClassName));
                }
                serviceClass = DynamicInterfaceAnnotationEnhancerHelper.decorate((Class)serviceClass, templateClass, (IOpenClass)instantiationStrategy.compile().getOpenClass(), (ClassLoader)resolveServiceClassLoader);
            }
            catch (RulesInstantiationException e) {
                throw e;
            }
            catch (Exception | NoClassDefFoundError e) {
                throw new OpenApiGenerationException(String.format("An error is occurred during loading or applying annotation template class '%s'.%s", templateClassName, StringUtils.isNotBlank((CharSequence)e.getMessage()) ? " " + e.getMessage() : ""));
            }
        }
        return RuleServiceInstantiationFactoryHelper.buildInterfaceForService((IOpenClass)instantiationStrategy.compile().getOpenClass(), (Class)serviceClass, (ClassLoader)resolveServiceClassLoader, (Object)instantiationStrategy.instantiate(true), (boolean)this.isProvidedRuntimeContext(), (boolean)this.isProvideVariations());
    }

    private boolean isProvidedRuntimeContext() {
        return Optional.ofNullable(this.getRulesDeploy()).map(RulesDeploy::isProvideRuntimeContext).orElse(this.provideRuntimeContext);
    }

    private boolean isProvideVariations() {
        return Optional.ofNullable(this.getRulesDeploy()).map(RulesDeploy::isProvideVariations).orElse(this.provideVariations);
    }

    private ObjectMapper createObjectMapper(ClassLoader serviceClassLoader) {
        ClassLoader classLoader = this.compiledOpenClass.getClassLoader();
        ProjectJacksonObjectMapperFactoryBean objectMapperFactoryBean = new ProjectJacksonObjectMapperFactoryBean();
        objectMapperFactoryBean.setClassLoader(classLoader);
        objectMapperFactoryBean.setRulesDeploy(this.getRulesDeploy());
        objectMapperFactoryBean.setXlsModuleOpenClass((XlsModuleOpenClass)this.openClass);
        objectMapperFactoryBean.setClassLoader(serviceClassLoader);
        try {
            return objectMapperFactoryBean.createJacksonObjectMapper();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to create an object mapper", e);
        }
    }

    private Class<?> enhanceWithJAXRS(Class<?> originalClass, Object targetService, ClassLoader classLoader) throws OpenApiGenerationException {
        try {
            return JAXRSOpenLServiceEnhancerHelper.enhanceInterface(originalClass, (Object)targetService, (ClassLoader)classLoader, (boolean)this.isProvidedRuntimeContext(), (boolean)this.isProvideVariations());
        }
        catch (Exception e) {
            throw new OpenApiGenerationException("Failed to build an interface for the project.", e);
        }
    }

    private Map<Method, Method> buildMethodMapWithJAXRS(Class<?> serviceClass, Class<?> enhancedServiceClass) throws OpenApiGenerationException {
        try {
            return JAXRSOpenLServiceEnhancerHelper.buildMethodMap(serviceClass, enhancedServiceClass);
        }
        catch (Exception e) {
            throw new OpenApiGenerationException("Failed to build an interface for the project.", e);
        }
    }

    public static Builder builder(ProjectDescriptor projectDescriptor, RulesInstantiationStrategy instantiationStrategy) {
        return new Builder(projectDescriptor, instantiationStrategy);
    }

    public static class Builder {
        private final ProjectDescriptor projectDescriptor;
        private final RulesInstantiationStrategy instantiationStrategy;
        private boolean provideRuntimeContext = true;
        private boolean provideVariations;

        private Builder(ProjectDescriptor projectDescriptor, RulesInstantiationStrategy instantiationStrategy) {
            this.projectDescriptor = projectDescriptor;
            this.instantiationStrategy = instantiationStrategy;
        }

        public Builder withDefaultProvideRuntimeContext(boolean provideRuntimeContext) {
            this.provideRuntimeContext = provideRuntimeContext;
            return this;
        }

        public Builder withDefaultProvideVariations(boolean provideVariations) {
            this.provideVariations = provideVariations;
            return this;
        }

        public OpenApiGenerator generator() throws RulesInstantiationException {
            return new OpenApiGenerator(this.projectDescriptor, this.instantiationStrategy, this.provideRuntimeContext, this.provideVariations);
        }
    }
}

