/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.validation;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openl.CompiledOpenClass;
import org.openl.classloader.OpenLClassLoader;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.project.IRulesDeploySerializer;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RuntimeContextInstantiationStrategyEnhancer;
import org.openl.rules.project.instantiation.variation.VariationInstantiationStrategyEnhancer;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.project.resolving.ProjectResource;
import org.openl.rules.project.resolving.ProjectResourceLoader;
import org.openl.rules.project.validation.ProjectValidator;
import org.openl.rules.project.xml.XmlRulesDeploySerializer;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactoryHelper;
import org.openl.rules.ruleservice.core.interceptors.DynamicInterfaceAnnotationEnhancerHelper;
import org.openl.types.IOpenClass;
import org.openl.validation.ValidatedCompiledOpenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceInterfaceProjectValidator
implements ProjectValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServiceInterfaceProjectValidator.class);
    private static final String RULES_DEPLOY_XML = "rules-deploy.xml";
    private boolean provideRuntimeContext = true;
    private boolean provideVariations;
    private final IRulesDeploySerializer rulesDeploySerializer = new XmlRulesDeploySerializer();
    private RulesDeploy rulesDeploy;
    private ClassLoader classLoader;

    protected ProjectResource loadProjectResource(ProjectResourceLoader projectResourceLoader, ProjectDescriptor projectDescriptor, String name) {
        ProjectResource[] projectResources = projectResourceLoader.loadResource(name);
        return Arrays.stream(projectResources).filter(e -> Objects.equals(e.getProjectDescriptor().getName(), projectDescriptor.getName())).findFirst().orElse(null);
    }

    protected RulesDeploy loadRulesDeploy(ProjectDescriptor projectDescriptor, CompiledOpenClass compiledOpenClass) {
        ProjectResourceLoader projectResourceLoader = new ProjectResourceLoader(compiledOpenClass);
        ProjectResource projectResource = this.loadProjectResource(projectResourceLoader, projectDescriptor, RULES_DEPLOY_XML);
        if (projectResource != null) {
            try {
                return this.rulesDeploySerializer.deserialize((InputStream)new FileInputStream(projectResource.getFile()));
            }
            catch (FileNotFoundException e) {
                LOG.debug("Ignored error: ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected RulesDeploy getRulesDeploy(ProjectDescriptor projectDescriptor, CompiledOpenClass compiledOpenClass) {
        if (this.rulesDeploy == null) {
            this.rulesDeploy = this.loadRulesDeploy(projectDescriptor, compiledOpenClass);
        }
        return this.rulesDeploy;
    }

    protected ClassLoader resolveServiceClassLoader(RulesInstantiationStrategy instantiationStrategy) throws RulesInstantiationException {
        if (this.classLoader == null) {
            OpenLClassLoader moduleGeneratedClassesClassLoader = ((XlsModuleOpenClass)instantiationStrategy.compile().getOpenClassWithErrors()).getClassGenerationClassLoader();
            OpenLClassLoader openLClassLoader = new OpenLClassLoader(null);
            openLClassLoader.addClassLoader((ClassLoader)moduleGeneratedClassesClassLoader);
            openLClassLoader.addClassLoader(instantiationStrategy.getClassLoader());
            this.classLoader = openLClassLoader;
        }
        return this.classLoader;
    }

    protected Class<?> resolveInterface(ProjectDescriptor projectDescriptor, RulesInstantiationStrategy rulesInstantiationStrategy, ValidatedCompiledOpenClass validatedCompiledOpenClass) throws RulesInstantiationException {
        boolean hasVariations;
        String serviceClassName;
        RulesDeploy rulesDeployValue = this.getRulesDeploy(projectDescriptor, (CompiledOpenClass)validatedCompiledOpenClass);
        if (rulesDeployValue != null && rulesDeployValue.getServiceClass() != null && !StringUtils.isEmpty((CharSequence)(serviceClassName = rulesDeployValue.getServiceClass().trim()))) {
            try {
                Class<?> serviceClass = validatedCompiledOpenClass.getClassLoader().loadClass(serviceClassName);
                if (serviceClass.isInterface()) {
                    return serviceClass;
                }
                throw new RulesInstantiationException(String.format("Interface is expected for service class '%s', but class is found.", serviceClassName));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new RulesInstantiationException(String.format("An error is occurred during loading a service class '%s'.%s", serviceClassName, StringUtils.isNotBlank((CharSequence)e.getMessage()) ? " " + e.getMessage() : ""));
            }
        }
        boolean hasContext = rulesDeployValue == null && this.isProvideRuntimeContext() || rulesDeployValue != null && Boolean.TRUE.equals(rulesDeployValue.isProvideRuntimeContext());
        boolean bl = hasVariations = rulesDeployValue == null && this.isProvideVariations() || rulesDeployValue != null && Boolean.TRUE.equals(rulesDeployValue.isProvideVariations());
        if (hasVariations) {
            rulesInstantiationStrategy = new VariationInstantiationStrategyEnhancer(rulesInstantiationStrategy);
        }
        if (hasContext) {
            rulesInstantiationStrategy = new RuntimeContextInstantiationStrategyEnhancer(rulesInstantiationStrategy);
        }
        String annotationTemplateClassName = null;
        if (rulesDeployValue != null) {
            String string = annotationTemplateClassName = rulesDeployValue.getAnnotationTemplateClassName() != null ? rulesDeployValue.getAnnotationTemplateClassName() : rulesDeployValue.getInterceptingTemplateClassName();
            if (annotationTemplateClassName != null) {
                annotationTemplateClassName = annotationTemplateClassName.trim();
            }
        }
        Class serviceClass = rulesInstantiationStrategy.getInstanceClass();
        ClassLoader resolveServiceClassLoader = this.resolveServiceClassLoader(rulesInstantiationStrategy);
        if (!StringUtils.isEmpty((CharSequence)annotationTemplateClassName)) {
            try {
                Class<?> annotationTemplateClass = resolveServiceClassLoader.loadClass(annotationTemplateClassName);
                if (!annotationTemplateClass.isInterface() && !Modifier.isAbstract(annotationTemplateClass.getModifiers())) {
                    throw new RulesInstantiationException(String.format("Interface or abstract class is expected for annotation template class '%s', but class is found.", annotationTemplateClassName));
                }
                serviceClass = DynamicInterfaceAnnotationEnhancerHelper.decorate((Class)serviceClass, annotationTemplateClass, (IOpenClass)rulesInstantiationStrategy.compile().getOpenClassWithErrors(), (ClassLoader)resolveServiceClassLoader);
            }
            catch (RulesInstantiationException e) {
                throw e;
            }
            catch (Exception | NoClassDefFoundError e) {
                throw new RulesInstantiationException(String.format("An error is occurred during loading or applying annotation template class '%s'.%s", annotationTemplateClassName, StringUtils.isNotBlank((CharSequence)e.getMessage()) ? " " + e.getMessage() : ""));
            }
        }
        return RuleServiceInstantiationFactoryHelper.buildInterfaceForService((IOpenClass)rulesInstantiationStrategy.compile().getOpenClassWithErrors(), (Class)serviceClass, (ClassLoader)resolveServiceClassLoader, (boolean)hasContext, (boolean)hasVariations);
    }

    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public void setProvideRuntimeContext(boolean provideRuntimeContext) {
        this.provideRuntimeContext = provideRuntimeContext;
    }

    public boolean isProvideVariations() {
        return this.provideVariations;
    }

    public void setProvideVariations(boolean provideVariations) {
        this.provideVariations = provideVariations;
    }
}

