/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.git;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.api.BranchRepository;
import org.openl.rules.repository.api.Features;
import org.openl.rules.repository.api.FileChange;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.FileItem;
import org.openl.rules.repository.api.FolderRepository;
import org.openl.rules.repository.api.Listener;
import org.openl.rules.repository.common.ChangesMonitor;
import org.openl.rules.repository.common.RevisionGetter;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.git.CommitType;
import org.openl.rules.repository.git.LazyFileData;
import org.openl.util.FileUtils;
import org.openl.util.IOUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepository
implements FolderRepository,
BranchRepository,
Closeable,
RRepositoryFactory {
    static final String DELETED_MARKER_FILE = ".archived";
    private final Logger log = LoggerFactory.getLogger(GitRepository.class);
    private String uri;
    private String login;
    private String password;
    private String userDisplayName;
    private String userEmail;
    private String localRepositoryPath;
    private String branch;
    private String baseBranch = this.branch = "master";
    private String tagPrefix = "";
    private int listenerTimerPeriod = 10;
    private String commentPattern;
    private String gitSettingsPath;
    private ChangesMonitor monitor;
    private Git git;
    private ReadWriteLock repositoryLock = new ReentrantReadWriteLock();
    private Map<String, List<String>> branches = new HashMap<String, List<String>>();
    private Map<String, GitRepository> branchRepos = new HashMap<String, GitRepository>();

    public List<FileData> list(String path) throws IOException {
        return this.iterate(path, new ListCommand(this.resolveBranchId()));
    }

    public FileData check(String name) throws IOException {
        return this.iterate(name, new CheckCommand());
    }

    public FileItem read(String name) throws IOException {
        return this.iterate(name, new ReadCommand());
    }

    public FileData save(FileData data, InputStream stream) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            writeLock.lock();
            this.git.checkout().setName(this.branch).call();
            String fileInRepository = data.getName();
            File file = new File(this.localRepositoryPath, fileInRepository);
            this.createParent(file);
            IOUtils.copyAndClose((InputStream)stream, (OutputStream)new FileOutputStream(file));
            this.git.add().addFilepattern(fileInRepository).call();
            RevCommit commit = this.git.commit().setMessage(StringUtils.trimToEmpty((String)data.getComment())).setCommitter(this.userDisplayName != null ? this.userDisplayName : data.getAuthor(), this.userEmail != null ? this.userEmail : "").setOnly(fileInRepository).call();
            this.addTagToCommit(commit);
            this.push();
        }
        catch (Exception e) {
            this.reset();
            throw new IOException(e);
        }
        finally {
            writeLock.unlock();
        }
        return this.check(data.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(FileData data) {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            writeLock.lock();
            this.git.checkout().setName(this.branch).call();
            String name = data.getName();
            File file = new File(this.localRepositoryPath, name);
            if (!file.exists()) {
                boolean bl = false;
                return bl;
            }
            if (file.isDirectory()) {
                String comment = StringUtils.trimToEmpty((String)data.getComment());
                String commitMessage = MessageFormat.format(this.commentPattern, new Object[]{CommitType.ARCHIVE, comment});
                try (DataOutputStream os = new DataOutputStream(new FileOutputStream(new File(file, DELETED_MARKER_FILE)));){
                    os.writeLong(System.currentTimeMillis());
                }
                String markerFile = name + "/" + DELETED_MARKER_FILE;
                this.git.add().addFilepattern(markerFile).call();
                RevCommit commit = this.git.commit().setMessage(commitMessage).setCommitter(this.userDisplayName != null ? this.userDisplayName : data.getAuthor(), this.userEmail != null ? this.userEmail : "").setOnly(markerFile).call();
                this.addTagToCommit(commit);
            } else {
                this.git.rm().addFilepattern(name).call();
                RevCommit commit = this.git.commit().setMessage(StringUtils.trimToEmpty((String)data.getComment())).setCommitter(this.userDisplayName != null ? this.userDisplayName : data.getAuthor(), this.userEmail != null ? this.userEmail : "").call();
                this.addTagToCommit(commit);
            }
            this.push();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.reset();
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    private FileData copy(String srcName, FileData destData) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            writeLock.lock();
            this.git.checkout().setName(this.branch).call();
            File src = new File(this.localRepositoryPath, srcName);
            File dest = new File(this.localRepositoryPath, destData.getName());
            IOUtils.copyAndClose((InputStream)new FileInputStream(src), (OutputStream)new FileOutputStream(dest));
            this.git.add().addFilepattern(destData.getName()).call();
            RevCommit commit = this.git.commit().setMessage(StringUtils.trimToEmpty((String)destData.getComment())).setCommitter(this.userDisplayName != null ? this.userDisplayName : destData.getAuthor(), this.userEmail != null ? this.userEmail : "").call();
            this.addTagToCommit(commit);
            this.push();
        }
        catch (Exception e) {
            this.reset();
            throw new IOException(e);
        }
        finally {
            writeLock.unlock();
        }
        return this.check(destData.getName());
    }

    public void setListener(Listener callback) {
        if (this.monitor != null) {
            this.monitor.setListener(callback);
        }
    }

    public List<FileData> listHistory(String name) throws IOException {
        return this.iterateHistory(name, new ListHistoryVisitor());
    }

    public List<FileData> listFiles(String path, String version) throws IOException {
        return this.iterateHistory(path, new ListFilesHistoryVisitor(version));
    }

    public FileData checkHistory(String name, String version) throws IOException {
        return this.iterateHistory(name, new CheckHistoryVisitor(version));
    }

    public FileItem readHistory(String name, String version) throws IOException {
        return this.iterateHistory(name, new ReadHistoryVisitor(version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteHistory(FileData data) {
        String name = data.getName();
        String version = data.getVersion();
        String author = StringUtils.trimToEmpty((String)data.getAuthor());
        String comment = StringUtils.trimToEmpty((String)data.getComment());
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            writeLock.lock();
            this.git.checkout().setName(this.branch).call();
            if (version == null) {
                this.git.rm().addFilepattern(name).call();
                String commitMessage = MessageFormat.format(this.commentPattern, new Object[]{CommitType.ERASE, comment});
                RevCommit commit = this.git.commit().setCommitter(this.userDisplayName != null ? this.userDisplayName : author, this.userEmail != null ? this.userEmail : "").setMessage(commitMessage).setOnly(name).call();
                this.addTagToCommit(commit);
            } else {
                FileData fileData = this.checkHistory(name, version);
                if (fileData == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!fileData.isDeleted()) {
                    boolean bl = false;
                    return bl;
                }
                String markerFile = name + "/" + DELETED_MARKER_FILE;
                this.git.rm().addFilepattern(markerFile).call();
                String commitMessage = MessageFormat.format(this.commentPattern, new Object[]{CommitType.RESTORE, comment});
                RevCommit commit = this.git.commit().setCommitter(this.userDisplayName != null ? this.userDisplayName : author, this.userEmail != null ? this.userEmail : "").setMessage(commitMessage).setOnly(markerFile).call();
                this.addTagToCommit(commit);
            }
            this.push();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileData copyHistory(String srcName, FileData destData, String version) throws IOException {
        FileData fileData;
        ArrayList<FileChange> files;
        if (version == null) {
            return this.copy(srcName, destData);
        }
        Lock writeLock = this.repositoryLock.writeLock();
        writeLock.lock();
        this.git.checkout().setName(this.branch).call();
        File src = new File(this.localRepositoryPath, srcName);
        if (src.isDirectory()) {
            files = new ArrayList<FileChange>();
            List<FileData> fileData2 = this.listFiles(srcName + "/", version);
            for (FileData data : fileData2) {
                String fileFrom = data.getName();
                FileItem fileItem = this.readHistory(fileFrom, data.getVersion());
                String fileTo = destData.getName() + fileFrom.substring(srcName.length());
                files.add(new FileChange(fileTo, fileItem.getStream()));
            }
            FileData fileData3 = this.save(destData, files);
            return fileData3;
        }
        FileItem fileItem = null;
        try {
            fileItem = this.readHistory(srcName, version);
            destData.setSize(fileItem.getData().getSize());
            fileData = this.save(destData, fileItem.getStream());
            if (fileItem == null) return fileData;
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (fileItem == null) throw throwable;
                    IOUtils.closeQuietly((Closeable)fileItem.getStream());
                    throw throwable;
                }
                catch (Exception e) {
                    this.reset();
                    throw new IOException(e);
                }
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                for (FileChange file : files) {
                    IOUtils.closeQuietly((Closeable)file.getStream());
                }
            }
        }
        finally {
            writeLock.unlock();
        }
        IOUtils.closeQuietly((Closeable)fileItem.getStream());
        return fileData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize() throws RRepositoryException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            boolean shouldClone;
            writeLock.lock();
            File local = new File(this.localRepositoryPath);
            if (!local.exists()) {
                shouldClone = true;
            } else {
                File[] files = local.listFiles();
                if (files == null) {
                    throw new IOException("Folder '" + local + "' is not directory");
                }
                if (files.length > 0) {
                    if (RepositoryCache.FileKey.resolve((File)local, (FS)FS.DETECTED) == null) throw new IOException("Folder '" + local + "' already exists and is not empty. Delete it or choose another local path.");
                    this.log.debug("Reuse existing local repository {}", (Object)local);
                    try (Repository repository = Git.open((File)local).getRepository();){
                        URI savedUri;
                        URI proposedUri;
                        String remoteUrl = repository.getConfig().getString("remote", "origin", "url");
                        if (!this.uri.equals(remoteUrl) && !(proposedUri = this.getUri(this.uri)).equals(savedUri = this.getUri(remoteUrl))) {
                            throw new IOException("Folder '" + local + "' already contains local git repository but is configured for different URI (" + remoteUrl + ").\nDelete it or choose another local path or set correct URL for repository.");
                        }
                    }
                    shouldClone = false;
                } else {
                    shouldClone = true;
                }
            }
            if (shouldClone) {
                try {
                    CloneCommand cloneCommand = Git.cloneRepository().setURI(this.uri).setDirectory(local).setBranch(this.branch).setBranchesToClone(Collections.singletonList("refs/heads/" + this.branch));
                    if (StringUtils.isNotBlank((CharSequence)this.login)) {
                        cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.login, this.password));
                    }
                    Git cloned = cloneCommand.call();
                    cloned.close();
                }
                catch (Exception e) {
                    FileUtils.deleteQuietly((File)local);
                    throw e;
                }
            }
            this.git = Git.open((File)local);
            if (!shouldClone) {
                boolean branchAbsents;
                FetchCommand fetchCommand = this.git.fetch();
                if (StringUtils.isNotBlank((CharSequence)this.login)) {
                    fetchCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.login, this.password));
                }
                fetchCommand.call();
                boolean bl = branchAbsents = this.git.getRepository().findRef(this.branch) == null;
                if (branchAbsents) {
                    this.git.branchCreate().setName(this.branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + this.branch).call();
                }
            }
            this.readBranches();
            this.monitor = new ChangesMonitor((RevisionGetter)new GitRevisionGetter(), this.listenerTimerPeriod);
            return;
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof UnknownHostException) {
                String error = "Invalid URL " + this.uri;
                throw new RRepositoryException(error, (Throwable)new IllegalArgumentException(error));
            }
            String message = cause.getMessage();
            if (message == null || !message.endsWith("301 Moved Permanently")) throw new RRepositoryException(e.getMessage(), (Throwable)e);
            String error = "Invalid URL " + this.uri;
            throw new RRepositoryException(error, (Throwable)new IllegalArgumentException(error));
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void close() {
        if (this.monitor != null) {
            this.monitor.release();
            this.monitor = null;
        }
        if (this.git != null) {
            this.git.close();
        }
        for (GitRepository repository : this.branchRepos.values()) {
            repository.close();
        }
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public void setLocalRepositoryPath(String localRepositoryPath) {
        this.localRepositoryPath = localRepositoryPath;
    }

    public void setBranch(String branch) {
        this.baseBranch = this.branch = StringUtils.isBlank((CharSequence)branch) ? "master" : branch;
    }

    public void setTagPrefix(String tagPrefix) {
        this.tagPrefix = StringUtils.trimToEmpty((String)tagPrefix);
    }

    public void setListenerTimerPeriod(int listenerTimerPeriod) {
        this.listenerTimerPeriod = listenerTimerPeriod;
    }

    public void setCommentPattern(String commentPattern) {
        this.commentPattern = commentPattern;
    }

    public void setGitSettingsPath(String gitSettingsPath) {
        this.gitSettingsPath = gitSettingsPath;
    }

    private static TreeWalk buildTreeWalk(Repository repository, String path, RevTree tree) throws IOException {
        TreeWalk treeWalk;
        if (StringUtils.isEmpty((CharSequence)path)) {
            treeWalk = new TreeWalk(repository);
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(true);
            treeWalk.setPostOrderTraversal(false);
        } else {
            treeWalk = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)tree);
        }
        if (treeWalk == null) {
            throw new FileNotFoundException("Did not find expected path '" + path + "' in tree '" + tree.getName() + "'");
        }
        return treeWalk;
    }

    private FileData createFileData(TreeWalk dirWalk, String baseFolder, ObjectId start) {
        String fullPath = baseFolder + dirWalk.getPathString();
        return new LazyFileData(this.branch, fullPath, new File(this.localRepositoryPath), start, this.getFileId(dirWalk), this.commentPattern);
    }

    private ObjectId resolveBranchId() throws IOException {
        ObjectId branchId = this.git.getRepository().resolve(this.branch);
        if (branchId == null) {
            throw new IOException("Can't find branch '" + this.branch + "'");
        }
        return branchId;
    }

    private FileData createFileData(TreeWalk dirWalk, RevCommit fileCommit) {
        String fullPath = dirWalk.getPathString();
        return new LazyFileData(this.branch, fullPath, new File(this.localRepositoryPath), fileCommit, this.getFileId(dirWalk), this.commentPattern);
    }

    private ObjectId getFileId(TreeWalk dirWalk) {
        int fileModeBits = dirWalk.getFileMode().getBits();
        ObjectId fileId = null;
        if ((fileModeBits & 0x8000) != 0) {
            fileId = dirWalk.getObjectId(0);
        }
        return fileId;
    }

    private ObjectId getLastRevision() throws GitAPIException, IOException {
        this.pull();
        Lock readLock = this.repositoryLock.readLock();
        try {
            readLock.lock();
            ObjectId objectId = this.git.getRepository().resolve("HEAD^{tree}");
            return objectId;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pull() throws GitAPIException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            PullResult pullResult;
            writeLock.lock();
            PullCommand pullCommand = this.git.pull().setStrategy((MergeStrategy)MergeStrategy.RECURSIVE);
            if (StringUtils.isNotBlank((CharSequence)this.login)) {
                pullCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.login, this.password));
            }
            if (!(pullResult = pullCommand.call()).isSuccessful()) {
                throw new IllegalStateException("Can't pull: " + pullResult.toString());
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private void push() throws GitAPIException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            writeLock.lock();
            PushCommand push = this.git.push().setPushTags().add(this.branch);
            if (StringUtils.isNotBlank((CharSequence)this.login)) {
                push.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.login, this.password));
            }
            push.call();
            this.monitor.fireOnChange();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    private <T> T iterate(String path, WalkCommand<T> command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> T iterateHistory(String name, HistoryVisitor<T> historyVisitor) throws IOException {
        Lock readLock = this.repositoryLock.readLock();
        try {
            RevCommit commit;
            boolean stop;
            readLock.lock();
            Iterator iterator = this.git.log().add((AnyObjectId)this.resolveBranchId()).addPath(name).call().iterator();
            List tags = this.git.tagList().call();
            while (iterator.hasNext() && !(stop = historyVisitor.visit(name, commit = (RevCommit)iterator.next(), GitRepository.getVersionName(this.git.getRepository(), tags, (ObjectId)commit)))) {
            }
            T t = historyVisitor.getResult();
            return t;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            readLock.unlock();
        }
    }

    private void reset() {
        try {
            this.git.reset().setMode(ResetCommand.ResetType.HARD).call();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getNextTagId() throws GitAPIException {
        List call = this.git.tagList().call();
        long maxId = 0L;
        for (Ref tagRef : call) {
            int num;
            String name = GitRepository.getLocalTagName(tagRef);
            if (!name.startsWith(this.tagPrefix)) continue;
            try {
                num = Integer.parseInt(name.substring(this.tagPrefix.length()));
            }
            catch (NumberFormatException e) {
                this.log.debug("Tag {} is skipped because it doesn't contain version number", (Object)name);
                continue;
            }
            if ((long)num <= maxId) continue;
            maxId = num;
        }
        return String.valueOf(maxId + 1L);
    }

    static String getVersionName(Repository repository, List<Ref> tags, ObjectId commitId) {
        Ref tagRef = GitRepository.getTagRefForCommit(repository, tags, commitId);
        return tagRef != null ? GitRepository.getLocalTagName(tagRef) : commitId.getName();
    }

    private static Ref getTagRefForCommit(Repository repository, List<Ref> tags, ObjectId commitId) {
        Ref tagRefForCommit = null;
        for (Ref tagRef : tags) {
            ObjectId objectId = repository.peel(tagRef).getPeeledObjectId();
            if (objectId == null) {
                objectId = tagRef.getObjectId();
            }
            if (!objectId.equals((AnyObjectId)commitId)) continue;
            tagRefForCommit = tagRef;
            break;
        }
        return tagRefForCommit;
    }

    private static String getLocalTagName(Ref tagRef) {
        String name = tagRef.getName();
        return name.startsWith("refs/tags/") ? name.substring("refs/tags/".length()) : name;
    }

    private void addTagToCommit(RevCommit commit) throws GitAPIException {
        this.pull();
        if (!this.tagPrefix.isEmpty()) {
            String tagName = this.tagPrefix + this.getNextTagId();
            this.git.tag().setObjectId((RevObject)commit).setName(tagName).call();
        }
    }

    public List<FileData> listFolders(String path) throws IOException {
        return this.iterate(path, new ListFoldersCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileData save(FileData folderData, Iterable<FileChange> files) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            writeLock.lock();
            this.git.checkout().setName(this.branch).call();
            String relativeFolder = folderData.getName();
            ArrayList<File> savedFiles = new ArrayList<File>();
            for (FileChange change : files) {
                File file = new File(this.localRepositoryPath, change.getName());
                savedFiles.add(file);
                this.createParent(file);
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream(file);
                    IOUtils.copy((InputStream)change.getStream(), (OutputStream)output);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)output);
                this.git.add().addFilepattern(change.getName()).call();
            }
            String basePath = new File(this.localRepositoryPath).getAbsolutePath();
            File folder = new File(this.localRepositoryPath, relativeFolder);
            this.removeAbsentFiles(basePath, folder, savedFiles);
            CommitCommand commitCommand = this.git.commit().setMessage(StringUtils.trimToEmpty((String)folderData.getComment())).setCommitter(this.userDisplayName != null ? this.userDisplayName : folderData.getAuthor(), this.userEmail != null ? this.userEmail : "");
            RevCommit commit = this.git.status().call().getUncommittedChanges().isEmpty() ? commitCommand.setAllowEmpty(true).call() : commitCommand.setOnly(relativeFolder).call();
            this.addTagToCommit(commit);
            this.push();
        }
        catch (Exception e) {
            this.reset();
            throw new IOException(e);
        }
        finally {
            writeLock.unlock();
        }
        return this.check(folderData.getName());
    }

    public Features supports() {
        return new Features((org.openl.rules.repository.api.Repository)this);
    }

    public String getBranch() {
        return this.branch;
    }

    public void createBranch(String projectName, String newBranch) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            writeLock.lock();
            this.git.checkout().setName(this.branch).call();
            this.git.branchCreate().setName(newBranch).call();
            List<String> projectBranches = this.branches.get(projectName);
            if (projectBranches == null) {
                projectBranches = new ArrayList<String>();
                projectBranches.add(this.branch);
                this.branches.put(projectName, projectBranches);
            }
            if (!projectBranches.contains(newBranch)) {
                projectBranches.add(newBranch);
            }
            this.pushBranch(new RefSpec().setSource(newBranch).setDestination("refs/heads/" + newBranch));
            this.saveBranches();
        }
        catch (Exception e) {
            this.reset();
            try {
                this.git.branchDelete().setBranchNames(new String[]{newBranch}).call();
            }
            catch (GitAPIException gitAPIException) {
                // empty catch block
            }
            throw new IOException(e);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void deleteBranch(String projectName, String branch) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            writeLock.lock();
            this.git.checkout().setName(this.baseBranch).call();
            this.git.branchDelete().setBranchNames(new String[]{branch}).setForce(true).call();
            Collection projectBranches = this.branches.get(projectName);
            if (projectBranches != null) {
                projectBranches.remove(branch);
                this.branchRepos.remove(branch);
                this.pushBranch(new RefSpec().setSource(null).setDestination("refs/heads/" + branch));
                this.saveBranches();
            }
        }
        catch (Exception e) {
            this.reset();
            throw new IOException(e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getBranches(String projectName) {
        Lock readLock = this.repositoryLock.readLock();
        try {
            readLock.lock();
            List<String> projectBranches = this.branches.get(projectName);
            List<String> list = projectBranches == null ? Collections.singletonList(this.branch) : projectBranches;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public GitRepository forBranch(String branch) throws IOException {
        GitRepository repository = this.branchRepos.get(branch);
        if (repository == null) {
            Lock writeLock = this.repositoryLock.writeLock();
            try {
                writeLock.lock();
                repository = this.branchRepos.get(branch);
                if (repository == null) {
                    boolean branchAbsents;
                    boolean bl = branchAbsents = this.git.getRepository().findRef(branch) == null;
                    if (branchAbsents) {
                        FetchCommand fetchCommand = this.git.fetch();
                        if (StringUtils.isNotBlank((CharSequence)this.login)) {
                            fetchCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.login, this.password));
                        }
                        fetchCommand.setRefSpecs(new RefSpec[]{new RefSpec().setSource("refs/heads/" + branch).setDestination("refs/heads/" + branch)});
                        fetchCommand.call();
                    }
                    repository = new GitRepository();
                    repository.setUri(this.uri);
                    repository.setLogin(this.login);
                    repository.setPassword(this.password);
                    repository.setUserDisplayName(this.userDisplayName);
                    repository.setUserEmail(this.userEmail);
                    repository.setLocalRepositoryPath(this.localRepositoryPath);
                    repository.setBranch(branch);
                    repository.baseBranch = this.baseBranch;
                    repository.setTagPrefix(this.tagPrefix);
                    repository.setListenerTimerPeriod(this.listenerTimerPeriod);
                    repository.setCommentPattern(this.commentPattern);
                    repository.setGitSettingsPath(this.gitSettingsPath);
                    repository.git = Git.open((File)new File(this.localRepositoryPath));
                    repository.repositoryLock = this.repositoryLock;
                    repository.branches = this.branches;
                    repository.monitor = this.monitor;
                    this.branchRepos.put(branch, repository);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                writeLock.unlock();
            }
        }
        return repository;
    }

    private void pushBranch(RefSpec refSpec) throws GitAPIException {
        PushCommand push = this.git.push().setRefSpecs(new RefSpec[]{refSpec});
        if (StringUtils.isNotBlank((CharSequence)this.login)) {
            push.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.login, this.password));
        }
        push.call();
    }

    private void readBranches() throws IOException {
        this.branches.clear();
        if (StringUtils.isBlank((CharSequence)this.gitSettingsPath)) {
            return;
        }
        File settings = new File(new File(this.gitSettingsPath), "branches.properties");
        if (settings.isFile()) {
            try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(settings), StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(in);
                String numStr = properties.getProperty("projects.number");
                if (numStr == null) {
                    return;
                }
                int num = Integer.parseInt(numStr);
                for (int i = 1; i <= num; ++i) {
                    String name = properties.getProperty("project." + i + ".name");
                    String branchesStr = properties.getProperty("project." + i + ".branches");
                    if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)branchesStr)) continue;
                    this.branches.put(name, new ArrayList<String>(Arrays.asList(branchesStr.split(","))));
                }
            }
        }
    }

    private void saveBranches() throws IOException {
        File parent = new File(this.gitSettingsPath);
        if (!parent.mkdirs() && !parent.exists()) {
            throw new FileNotFoundException("Can't create folder " + this.gitSettingsPath);
        }
        File settings = new File(parent, "branches.properties");
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(settings), StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.setProperty("projects.number", String.valueOf(this.branches.size()));
            int i = 1;
            for (Map.Entry<String, List<String>> entry : this.branches.entrySet()) {
                properties.setProperty("project." + i + ".name", entry.getKey());
                properties.setProperty("project." + i + ".branches", StringUtils.join((Iterable)entry.getValue(), (String)","));
                ++i;
            }
            properties.store(out, null);
        }
    }

    private void removeAbsentFiles(String baseAbsolutePath, File directory, Collection<File> toSave) throws GitAPIException {
        File[] found = directory.listFiles();
        if (found != null) {
            for (File file : found) {
                if (file.isDirectory()) {
                    this.removeAbsentFiles(baseAbsolutePath, file, toSave);
                    continue;
                }
                if (toSave.contains(file)) continue;
                String relativePath = file.getAbsolutePath().substring(baseAbsolutePath.length()).replace('\\', '/');
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                this.git.rm().addFilepattern(relativePath).call();
            }
        }
    }

    private void createParent(File file) throws FileNotFoundException {
        File parentFile = file.getParentFile();
        if (!parentFile.mkdirs() && !parentFile.exists()) {
            throw new FileNotFoundException("Can't create the folder " + parentFile.getAbsolutePath());
        }
    }

    private URI getUri(String uriOrPath) {
        try {
            return new URI(uriOrPath);
        }
        catch (URISyntaxException e) {
            return new File(uriOrPath).toURI();
        }
    }

    private class ReadHistoryVisitor
    implements HistoryVisitor<FileItem> {
        private final String version;
        private final Repository repository;
        private FileItem result;

        private ReadHistoryVisitor(String version) {
            this.version = version;
            this.repository = GitRepository.this.git.getRepository();
        }

        @Override
        public boolean visit(String fullPath, RevCommit commit, String commitVersion) throws IOException {
            if (commitVersion.equals(this.version)) {
                RevTree tree = commit.getTree();
                try (TreeWalk rootWalk = GitRepository.buildTreeWalk(this.repository, fullPath, tree);){
                    FileData fileData = GitRepository.this.createFileData(rootWalk, commit);
                    ObjectLoader loader = this.repository.open((AnyObjectId)rootWalk.getObjectId(0));
                    this.result = new FileItem(fileData, (InputStream)loader.openStream());
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        @Override
        public FileItem getResult() {
            return this.result;
        }
    }

    private class CheckHistoryVisitor
    implements HistoryVisitor<FileData> {
        private final String version;
        private final Repository repository;
        private FileData result;

        private CheckHistoryVisitor(String version) {
            this.version = version;
            this.repository = GitRepository.this.git.getRepository();
        }

        @Override
        public boolean visit(String fullPath, RevCommit commit, String commitVersion) throws IOException {
            if (commitVersion.equals(this.version)) {
                RevTree tree = commit.getTree();
                try (TreeWalk rootWalk = GitRepository.buildTreeWalk(this.repository, fullPath, tree);){
                    this.result = GitRepository.this.createFileData(rootWalk, commit);
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        @Override
        public FileData getResult() {
            return this.result;
        }
    }

    private class ListFilesHistoryVisitor
    implements HistoryVisitor<List<FileData>> {
        private final String version;
        private final Repository repository;
        private final List<FileData> history = new ArrayList<FileData>();

        private ListFilesHistoryVisitor(String version) {
            this.version = version;
            this.repository = GitRepository.this.git.getRepository();
        }

        @Override
        public boolean visit(String fullPath, RevCommit commit, String commitVersion) throws IOException {
            if (commitVersion.equals(this.version)) {
                RevTree tree = commit.getTree();
                try (TreeWalk rootWalk = GitRepository.buildTreeWalk(this.repository, fullPath, tree);){
                    this.history.addAll((Collection<FileData>)new ListCommand(commit.getId()).apply(this.repository, rootWalk, fullPath));
                }
                return true;
            }
            return false;
        }

        @Override
        public List<FileData> getResult() {
            Collections.reverse(this.history);
            return this.history;
        }
    }

    private class ListHistoryVisitor
    implements HistoryVisitor<List<FileData>> {
        private final Repository repository;
        private final List<FileData> history = new ArrayList<FileData>();

        private ListHistoryVisitor() {
            this.repository = GitRepository.this.git.getRepository();
        }

        @Override
        public boolean visit(String fullPath, RevCommit commit, String commitVersion) throws IOException {
            RevTree tree = commit.getTree();
            try (TreeWalk rootWalk = GitRepository.buildTreeWalk(this.repository, fullPath, tree);){
                this.history.add(GitRepository.this.createFileData(rootWalk, commit));
            }
            catch (FileNotFoundException e) {
                GitRepository.this.log.debug("File '{}' is absent in the commit {}", new Object[]{fullPath, commitVersion, e});
            }
            return false;
        }

        @Override
        public List<FileData> getResult() {
            Collections.reverse(this.history);
            return this.history;
        }
    }

    private class ReadCommand
    implements WalkCommand<FileItem> {
        private ReadCommand() {
        }

        @Override
        public FileItem apply(Repository repository, TreeWalk rootWalk, String baseFolder) throws IOException {
            if (rootWalk != null) {
                FileData fileData = GitRepository.this.createFileData(rootWalk, "", GitRepository.this.resolveBranchId());
                ObjectLoader loader = repository.open((AnyObjectId)rootWalk.getObjectId(0));
                return new FileItem(fileData, (InputStream)loader.openStream());
            }
            return null;
        }
    }

    private class CheckCommand
    implements WalkCommand<FileData> {
        private CheckCommand() {
        }

        @Override
        public FileData apply(Repository repository, TreeWalk rootWalk, String baseFolder) throws IOException {
            if (rootWalk != null) {
                return GitRepository.this.createFileData(rootWalk, "", GitRepository.this.resolveBranchId());
            }
            return null;
        }
    }

    private class ListFoldersCommand
    implements WalkCommand<List<FileData>> {
        private ListFoldersCommand() {
        }

        @Override
        public List<FileData> apply(Repository repository, TreeWalk rootWalk, String baseFolder) throws IOException {
            if (rootWalk != null) {
                if (rootWalk.getFilter() == TreeFilter.ALL) {
                    return this.collectFolderData(rootWalk, baseFolder);
                }
                if (rootWalk.getTreeCount() > 0) {
                    try (TreeWalk dirWalk = new TreeWalk(repository);){
                        dirWalk.addTree((AnyObjectId)rootWalk.getObjectId(0));
                        List<FileData> list = this.collectFolderData(dirWalk, baseFolder);
                        return list;
                    }
                }
            }
            return Collections.emptyList();
        }

        private List<FileData> collectFolderData(TreeWalk rootWalk, String baseFolder) throws IOException {
            ArrayList<FileData> files = new ArrayList<FileData>();
            rootWalk.setRecursive(false);
            ObjectId start = GitRepository.this.resolveBranchId();
            while (rootWalk.next()) {
                if ((rootWalk.getFileMode().getBits() & 0x4000) == 0) continue;
                files.add(GitRepository.this.createFileData(rootWalk, baseFolder, start));
            }
            return files;
        }
    }

    private class ListCommand
    implements WalkCommand<List<FileData>> {
        private final ObjectId start;

        public ListCommand(ObjectId start) {
            this.start = start;
        }

        @Override
        public List<FileData> apply(Repository repository, TreeWalk rootWalk, String baseFolder) throws IOException {
            if (rootWalk != null) {
                ArrayList<FileData> files = new ArrayList<FileData>();
                if (rootWalk.getFilter() == TreeFilter.ALL) {
                    while (rootWalk.next()) {
                        files.add(GitRepository.this.createFileData(rootWalk, baseFolder, this.start));
                    }
                } else if (rootWalk.getTreeCount() > 0) {
                    try (TreeWalk dirWalk = new TreeWalk(repository);){
                        dirWalk.addTree((AnyObjectId)rootWalk.getObjectId(0));
                        dirWalk.setRecursive(true);
                        while (dirWalk.next()) {
                            files.add(GitRepository.this.createFileData(dirWalk, baseFolder, this.start));
                        }
                    }
                }
                return files;
            }
            return Collections.emptyList();
        }
    }

    public static interface HistoryVisitor<T> {
        public boolean visit(String var1, RevCommit var2, String var3) throws IOException, GitAPIException;

        public T getResult();
    }

    public static interface WalkCommand<T> {
        public T apply(Repository var1, TreeWalk var2, String var3) throws IOException, GitAPIException;
    }

    private class GitRevisionGetter
    implements RevisionGetter {
        private GitRevisionGetter() {
        }

        public Object getRevision() {
            try {
                return GitRepository.this.getLastRevision();
            }
            catch (Exception e) {
                GitRepository.this.log.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }
}

