/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.git;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.git.CommitType;
import org.openl.rules.repository.git.GitRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LazyFileData
extends FileData {
    private final Logger log = LoggerFactory.getLogger(GitRepository.class);
    private final String fullPath;
    private final File repoFolder;
    private ObjectId fromCommit;
    private RevCommit fileCommit;
    private ObjectId fileId;
    private final String commentPattern;
    private boolean loaded = false;

    LazyFileData(String branch, String fullPath, File repoFolder, ObjectId fromCommit, ObjectId fileId, String commentPattern) {
        this.setBranch(branch);
        this.setName(fullPath);
        this.fullPath = fullPath;
        this.repoFolder = repoFolder;
        this.commentPattern = commentPattern;
        this.fromCommit = fromCommit;
        this.fileId = fileId;
    }

    LazyFileData(String branch, String fullPath, File repoFolder, RevCommit fileCommit, ObjectId fileId, String commentPattern) {
        this.setBranch(branch);
        this.setName(fullPath);
        this.fullPath = fullPath;
        this.repoFolder = repoFolder;
        this.commentPattern = commentPattern;
        this.fileCommit = fileCommit;
        this.fileId = fileId;
    }

    public long getSize() {
        if (this.fileId != null) {
            try (Git git = Git.open((File)this.repoFolder);){
                ObjectLoader loader = git.getRepository().open((AnyObjectId)this.fileId);
                super.setSize(loader.getSize());
                this.fileId = null;
            }
            catch (IOException e) {
                this.log.warn(e.getMessage(), (Throwable)e);
                throw new IllegalStateException("Can't get file size: " + e.getMessage(), e);
            }
        }
        return super.getSize();
    }

    public void setSize(long size) {
        this.fileId = null;
        super.setSize(size);
    }

    public String getAuthor() {
        this.verifyLoaded();
        return super.getAuthor();
    }

    public void setAuthor(String author) {
        this.verifyLoaded();
        super.setAuthor(author);
    }

    public String getComment() {
        this.verifyLoaded();
        return super.getComment();
    }

    public void setComment(String comment) {
        this.verifyLoaded();
        super.setComment(comment);
    }

    public Date getModifiedAt() {
        this.verifyLoaded();
        return super.getModifiedAt();
    }

    public void setModifiedAt(Date modifiedAt) {
        this.verifyLoaded();
        super.setModifiedAt(modifiedAt);
    }

    public String getVersion() {
        this.verifyLoaded();
        return super.getVersion();
    }

    public void setVersion(String version) {
        this.verifyLoaded();
        super.setVersion(version);
    }

    public boolean isDeleted() {
        this.verifyLoaded();
        return super.isDeleted();
    }

    public void setDeleted(boolean deleted) {
        this.verifyLoaded();
        super.setDeleted(deleted);
    }

    private void verifyLoaded() {
        if (this.loaded) {
            return;
        }
        try (Git git = Git.open((File)this.repoFolder);){
            String version;
            if (this.fileCommit == null) {
                Iterator iterator = null;
                try {
                    iterator = git.log().add((AnyObjectId)this.fromCommit).addPath(this.fullPath).call().iterator();
                }
                catch (GitAPIException | IncorrectObjectTypeException | MissingObjectException e) {
                    this.log.error(e.getMessage(), e);
                }
                if (iterator == null || !iterator.hasNext()) {
                    throw new IllegalStateException("Can't find revision for the file " + this.fullPath);
                }
                this.fileCommit = (RevCommit)iterator.next();
                this.fromCommit = null;
            }
            PersonIdent committerIdent = this.fileCommit.getCommitterIdent();
            super.setAuthor(committerIdent.getName());
            super.setModifiedAt(committerIdent.getWhen());
            String message = this.fileCommit.getFullMessage();
            try {
                Object[] parse = new MessageFormat(this.commentPattern).parse(message);
                if (parse.length == 2) {
                    CommitType commitType = CommitType.valueOf(String.valueOf(parse[0]));
                    if (commitType == CommitType.ARCHIVE) {
                        super.setDeleted(true);
                    }
                    message = String.valueOf(parse[1]);
                }
            }
            catch (IllegalArgumentException | ParseException parse) {
                // empty catch block
            }
            super.setComment(message);
            try {
                version = GitRepository.getVersionName(git.getRepository(), git.tagList().call(), this.fileCommit.getId());
            }
            catch (GitAPIException e) {
                throw new IllegalStateException("Can't get tags list: " + e.getMessage(), e);
            }
            super.setVersion(version);
            this.loaded = true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }
}

