/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.git;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openl.rules.repository.git.CommitType;

class CommitMessageParser {
    private static final String COMMIT_TYPE_TOKEN = "{commit-type}";
    private static final String USER_MESSAGE_TOKEN = "{user-message}";
    private static final String USERNAME_TOKEN = "{username}";
    private static final String[] TOKENS = new String[]{"{commit-type}", "{user-message}", "{username}"};
    private static final String COMMIT_TYPES = Stream.of(CommitType.values()).map(Enum::name).collect(Collectors.joining("|"));
    private final Pattern pattern;

    CommitMessageParser(String commentTemplate) {
        if (commentTemplate != null && !commentTemplate.trim().isEmpty()) {
            String patternStr = this.buildPattern(commentTemplate);
            this.pattern = Pattern.compile(patternStr, 32);
        } else {
            this.pattern = null;
        }
    }

    private String buildPattern(String template) {
        StringBuilder builder = new StringBuilder();
        int len = template.length();
        int[] tokenCounter = new int[TOKENS.length];
        int start = 0;
        int pos = 0;
        block10: while (pos < len) {
            int end = pos;
            for (int tokenIdx = 0; tokenIdx < TOKENS.length; ++tokenIdx) {
                String token = TOKENS[tokenIdx];
                int tokenLen = token.length();
                int tokenPos = 0;
                boolean matched = true;
                while (tokenPos < tokenLen && pos < len) {
                    if (token.charAt(tokenPos++) == template.charAt(pos++)) continue;
                    matched = false;
                    break;
                }
                if (matched) {
                    if (start < end) {
                        builder.append("\\Q").append(template, start, end).append("\\E");
                    }
                    start = pos;
                    boolean firstTokenOccurrence = tokenCounter[tokenIdx] == 0;
                    int n = tokenIdx;
                    tokenCounter[n] = tokenCounter[n] + 1;
                    builder.append("(?");
                    if (!firstTokenOccurrence) {
                        builder.append(':');
                    }
                    switch (token) {
                        case "{commit-type}": {
                            if (firstTokenOccurrence) {
                                builder.append("<commitType>");
                            }
                            builder.append(COMMIT_TYPES);
                            break;
                        }
                        case "{user-message}": {
                            if (firstTokenOccurrence) {
                                builder.append("<message>");
                            }
                            builder.append(".*");
                            break;
                        }
                        case "{username}": {
                            if (firstTokenOccurrence) {
                                builder.append("<author>");
                            }
                            builder.append(".+");
                        }
                    }
                    builder.append(')');
                    continue block10;
                }
                if (tokenIdx >= TOKENS.length - 1) continue;
                pos = end;
            }
        }
        if (start < len) {
            builder.append("\\Q").append(template, start, len).append("\\E");
        }
        return builder.toString();
    }

    CommitMessage parse(String message) {
        if (this.pattern == null || message == null) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(message);
        if (!matcher.matches()) {
            return null;
        }
        return new CommitMessage(matcher);
    }

    static class CommitMessage {
        private final Matcher matcher;

        private CommitMessage(Matcher matcher) {
            this.matcher = Objects.requireNonNull(matcher);
        }

        CommitType getCommitType() {
            String value = this.getValue("commitType");
            return value == null ? null : CommitType.valueOf(value);
        }

        String getAuthor() {
            return this.getValue("author");
        }

        String getMessage() {
            return this.getValue("message");
        }

        private String getValue(String groupName) {
            try {
                return this.matcher.group(groupName);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                return null;
            }
        }
    }
}

