/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.git;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotAdvertisedException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.api.BranchRepository;
import org.openl.rules.repository.api.ChangesetType;
import org.openl.rules.repository.api.ConflictResolveData;
import org.openl.rules.repository.api.Features;
import org.openl.rules.repository.api.FeaturesBuilder;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.FileItem;
import org.openl.rules.repository.api.FolderItem;
import org.openl.rules.repository.api.FolderRepository;
import org.openl.rules.repository.api.Listener;
import org.openl.rules.repository.api.MergeConflictException;
import org.openl.rules.repository.common.ChangesMonitor;
import org.openl.rules.repository.common.RevisionGetter;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.git.CommitMessageParser;
import org.openl.rules.repository.git.CommitType;
import org.openl.rules.repository.git.LazyFileData;
import org.openl.rules.repository.git.NotResettableCredentialsProvider;
import org.openl.util.FileUtils;
import org.openl.util.IOUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepository
implements FolderRepository,
BranchRepository,
Closeable,
RRepositoryFactory {
    static final String DELETED_MARKER_FILE = ".archived";
    private final Logger log = LoggerFactory.getLogger(GitRepository.class);
    private String uri;
    private String login;
    private String password;
    private String userDisplayName;
    private String userEmail;
    private String localRepositoryPath;
    private String branch;
    private String baseBranch = this.branch = "master";
    private String tagPrefix = "";
    private int listenerTimerPeriod = 10;
    private int connectionTimeout = 60;
    private String commentTemplate;
    private String escapedCommentTemplate;
    private CommitMessageParser commitMessageParser;
    private String gitSettingsPath;
    private boolean noVerify;
    private Boolean gcAutoDetach;
    private ChangesMonitor monitor;
    private Git git;
    private NotResettableCredentialsProvider credentialsProvider;
    private ReadWriteLock repositoryLock = new ReentrantReadWriteLock();
    private ReentrantLock remoteRepoLock = new ReentrantLock();
    private Map<String, List<String>> branches = new HashMap<String, List<String>>();
    private boolean closed;

    public List<FileData> list(String path) throws IOException {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return this.iterate(path, new ListCommand(this.resolveBranchId()));
    }

    public FileData check(String name) throws IOException {
        return this.iterate(name, new CheckCommand());
    }

    public FileItem read(String name) throws IOException {
        return this.iterate(name, new ReadCommand());
    }

    public FileData save(FileData data, InputStream stream) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            this.log.debug("save(data, stream): lock");
            writeLock.lock();
            this.saveSingleFile(data, stream);
        }
        catch (IOException e) {
            this.reset();
            throw e;
        }
        catch (Exception e) {
            this.reset();
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("save(data, stream): unlock");
        }
        this.monitor.fireOnChange();
        return this.check(data.getName());
    }

    public List<FileData> save(List<FileItem> fileItems) throws IOException {
        ArrayList<FileData> result = new ArrayList<FileData>();
        Lock writeLock = this.repositoryLock.writeLock();
        String firstCommitId = null;
        try {
            this.log.debug("save(multipleFiles): lock");
            writeLock.lock();
            this.checkoutForcedOrReset(this.branch);
            for (FileItem fileItem : fileItems) {
                RevCommit commit = this.createCommit(fileItem.getData(), fileItem.getStream());
                if (firstCommitId == null) {
                    firstCommitId = commit.getId().getName();
                }
                this.resolveAndMerge(fileItem.getData(), false, commit);
                this.addTagToCommit(commit, firstCommitId, fileItem.getData().getAuthor());
            }
            this.push();
        }
        catch (IOException e) {
            this.reset(firstCommitId);
            throw e;
        }
        catch (Exception e) {
            this.reset(firstCommitId);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("save(multipleFiles): unlock");
        }
        this.monitor.fireOnChange();
        for (FileItem fileItem : fileItems) {
            result.add(this.check(fileItem.getData().getName()));
        }
        return result;
    }

    private void saveSingleFile(FileData data, InputStream stream) throws IOException {
        String commitId = null;
        try {
            String parentVersion = data.getVersion();
            boolean checkoutOldVersion = this.isCheckoutOldVersion(data.getName(), parentVersion);
            this.checkoutForcedOrReset(checkoutOldVersion ? parentVersion : this.branch);
            RevCommit commit = this.createCommit(data, stream);
            commitId = commit.getId().getName();
            this.resolveAndMerge(data, checkoutOldVersion, commit);
            this.addTagToCommit(commit, data.getAuthor());
            this.push();
        }
        catch (IOException e) {
            this.reset(commitId);
            throw e;
        }
        catch (Exception e) {
            this.reset(commitId);
            throw new IOException(e.getMessage(), e);
        }
    }

    private RevCommit createCommit(FileData data, InputStream stream) throws GitAPIException, IOException {
        String fileInRepository = data.getName();
        File file = new File(this.localRepositoryPath, fileInRepository);
        this.createParent(file);
        IOUtils.copyAndClose((InputStream)stream, (OutputStream)new FileOutputStream(file));
        this.git.add().addFilepattern(fileInRepository).call();
        return this.git.commit().setMessage(this.formatComment(CommitType.SAVE, data)).setCommitter(this.userDisplayName != null ? this.userDisplayName : data.getAuthor(), this.userEmail != null ? this.userEmail : "").setOnly(fileInRepository).setNoVerify(this.noVerify).call();
    }

    public boolean delete(FileData data) throws IOException {
        String commitId = null;
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            this.log.debug("delete(): lock");
            writeLock.lock();
            this.checkoutForcedOrReset(this.branch);
            String name = data.getName();
            File file = new File(this.localRepositoryPath, name);
            if (!file.exists()) {
                boolean bl = false;
                return bl;
            }
            if (file.isDirectory()) {
                String commitMessage = this.formatComment(CommitType.ARCHIVE, data);
                try (DataOutputStream os = new DataOutputStream(new FileOutputStream(new File(file, DELETED_MARKER_FILE)));){
                    os.writeLong(System.currentTimeMillis());
                }
                String markerFile = name + "/" + DELETED_MARKER_FILE;
                this.git.add().addFilepattern(markerFile).call();
                RevCommit commit = this.git.commit().setMessage(commitMessage).setCommitter(this.userDisplayName != null ? this.userDisplayName : data.getAuthor(), this.userEmail != null ? this.userEmail : "").setOnly(markerFile).setNoVerify(this.noVerify).call();
                commitId = commit.getId().getName();
                this.addTagToCommit(commit, data.getAuthor());
            } else {
                this.git.rm().addFilepattern(name).call();
                RevCommit commit = this.git.commit().setMessage(this.formatComment(CommitType.ERASE, data)).setCommitter(this.userDisplayName != null ? this.userDisplayName : data.getAuthor(), this.userEmail != null ? this.userEmail : "").setNoVerify(this.noVerify).call();
                commitId = commit.getId().getName();
                this.addTagToCommit(commit, data.getAuthor());
            }
            this.push();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.reset(commitId);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.reset(commitId);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("delete(): unlock");
        }
        this.monitor.fireOnChange();
        return true;
    }

    private FileData copy(String srcName, FileData destData) throws IOException {
        String commitId = null;
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            this.log.debug("copy(): lock");
            writeLock.lock();
            this.checkoutForcedOrReset(this.branch);
            File src = new File(this.localRepositoryPath, srcName);
            File dest = new File(this.localRepositoryPath, destData.getName());
            IOUtils.copyAndClose((InputStream)new FileInputStream(src), (OutputStream)new FileOutputStream(dest));
            this.git.add().addFilepattern(destData.getName()).call();
            RevCommit commit = this.git.commit().setMessage(this.formatComment(CommitType.SAVE, destData)).setCommitter(this.userDisplayName != null ? this.userDisplayName : destData.getAuthor(), this.userEmail != null ? this.userEmail : "").setNoVerify(this.noVerify).call();
            commitId = commit.getId().getName();
            this.addTagToCommit(commit, destData.getAuthor());
            this.push();
        }
        catch (IOException e) {
            this.reset(commitId);
            throw e;
        }
        catch (Exception e) {
            this.reset(commitId);
            throw new IOException(e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("copy(): unlock");
        }
        this.monitor.fireOnChange();
        return this.check(destData.getName());
    }

    public void setListener(Listener callback) {
        if (this.monitor != null) {
            this.monitor.setListener(callback);
        }
    }

    public List<FileData> listHistory(String name) throws IOException {
        return this.iterateHistory(name, new ListHistoryVisitor());
    }

    public List<FileData> listFiles(String path, String version) throws IOException {
        return this.parseHistory(path, version, new ListFilesHistoryVisitor(version));
    }

    public FileData checkHistory(String name, String version) throws IOException {
        return this.parseHistory(name, version, new CheckHistoryVisitor(version));
    }

    public FileItem readHistory(String name, String version) throws IOException {
        return this.parseHistory(name, version, new ReadHistoryVisitor(version));
    }

    public boolean deleteHistory(FileData data) throws IOException {
        String name = data.getName();
        String version = data.getVersion();
        String author = StringUtils.trimToEmpty((String)data.getAuthor());
        String commitId = null;
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            RevCommit commit;
            this.log.debug("deleteHistory(): lock");
            writeLock.lock();
            this.checkoutForcedOrReset(this.branch);
            if (version == null) {
                this.git.rm().addFilepattern(name).call();
                String commitMessage = this.formatComment(CommitType.ERASE, data);
                commit = this.git.commit().setCommitter(this.userDisplayName != null ? this.userDisplayName : author, this.userEmail != null ? this.userEmail : "").setMessage(commitMessage).setOnly(name).setNoVerify(this.noVerify).call();
            } else {
                FileData fileData = this.checkHistory(name, version);
                if (fileData == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!fileData.isDeleted()) {
                    boolean bl = false;
                    return bl;
                }
                String markerFile = name + "/" + DELETED_MARKER_FILE;
                this.git.rm().addFilepattern(markerFile).call();
                String commitMessage = this.formatComment(CommitType.RESTORE, data);
                commit = this.git.commit().setCommitter(this.userDisplayName != null ? this.userDisplayName : author, this.userEmail != null ? this.userEmail : "").setMessage(commitMessage).setOnly(markerFile).setNoVerify(this.noVerify).call();
            }
            commitId = commit.getId().getName();
            this.addTagToCommit(commit, author);
            this.push();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.reset(commitId);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.reset(commitId);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("deleteHistory(): unlock");
        }
        this.monitor.fireOnChange();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileData copyHistory(String srcName, FileData destData, String version) throws IOException {
        block17: {
            if (version == null) {
                return this.copy(srcName, destData);
            }
            Lock writeLock = this.repositoryLock.writeLock();
            try {
                this.log.debug("copyHistory(): lock");
                writeLock.lock();
                this.checkoutForcedOrReset(this.branch);
                File src = new File(this.localRepositoryPath, srcName);
                if (src.isDirectory()) {
                    ArrayList<FileItem> files = new ArrayList<FileItem>();
                    try {
                        List<FileData> fileData = this.listFiles(srcName + "/", version);
                        for (FileData data : fileData) {
                            String fileFrom = data.getName();
                            FileItem fileItem = this.readHistory(fileFrom, data.getVersion());
                            String fileTo = destData.getName() + fileFrom.substring(srcName.length());
                            files.add(new FileItem(fileTo, fileItem.getStream()));
                        }
                        this.saveMultipleFiles(destData, files, ChangesetType.FULL);
                    }
                    finally {
                        for (FileItem file : files) {
                            IOUtils.closeQuietly((Closeable)file.getStream());
                        }
                        break block17;
                    }
                }
                FileItem fileItem = null;
                try {
                    fileItem = this.readHistory(srcName, version);
                    destData.setSize(fileItem.getData().getSize());
                    this.saveSingleFile(destData, fileItem.getStream());
                }
                finally {
                    if (fileItem != null) {
                        IOUtils.closeQuietly((Closeable)fileItem.getStream());
                    }
                }
            }
            catch (IOException e) {
                this.reset();
                throw e;
            }
            catch (Exception e) {
                this.reset();
                throw new IOException(e);
            }
            finally {
                writeLock.unlock();
                this.log.debug("copyHistory(): unlock");
            }
        }
        this.monitor.fireOnChange();
        return this.check(destData.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize() throws RRepositoryException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            boolean shouldCloneOrInit;
            File local;
            this.log.debug("initialize(): lock");
            writeLock.lock();
            if (StringUtils.isNotBlank((CharSequence)this.login) && StringUtils.isNotBlank((CharSequence)this.password)) {
                this.credentialsProvider = new NotResettableCredentialsProvider(this.login, this.password);
            }
            if (!(local = new File(this.localRepositoryPath)).exists()) {
                shouldCloneOrInit = true;
            } else {
                File[] files = local.listFiles();
                if (files == null) {
                    throw new IOException(String.format("Folder '%s' is not directory", local));
                }
                if (files.length > 0) {
                    if (RepositoryCache.FileKey.resolve((File)local, (FS)FS.DETECTED) == null) throw new IOException(String.format("Folder '%s' already exists and is not empty. Delete it or choose another local path.", local));
                    this.log.debug("Reuse existing local repository {}", (Object)local);
                    try (Repository repository = Git.open((File)local).getRepository();){
                        URI savedUri;
                        Object proposedUri;
                        String remoteUrl;
                        if (this.uri != null && !this.uri.equals(remoteUrl = repository.getConfig().getString("remote", "origin", "url")) && !((URI)(proposedUri = this.getUri(this.uri))).equals(savedUri = this.getUri(remoteUrl))) {
                            throw new IOException(String.format("Folder '%s' already contains local git repository but is configured for different URI (%s).\nDelete it or choose another local path or set correct URL for repository.", local, remoteUrl));
                        }
                    }
                    shouldCloneOrInit = false;
                } else {
                    shouldCloneOrInit = true;
                }
            }
            if (shouldCloneOrInit) {
                try {
                    if (this.uri != null) {
                        CloneCommand cloneCommand = Git.cloneRepository().setURI(this.uri).setDirectory(local).setBranch(this.branch).setCloneAllBranches(true);
                        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
                        if (credentialsProvider != null) {
                            cloneCommand.setCredentialsProvider(credentialsProvider);
                        }
                        Git cloned = cloneCommand.call();
                        cloned.close();
                    } else {
                        Git repo = Git.init().setDirectory(local).call();
                        repo.close();
                    }
                }
                catch (Exception e) {
                    FileUtils.deleteQuietly((File)local);
                    throw e;
                }
            }
            this.git = Git.open((File)local);
            StoredConfig config = this.git.getRepository().getConfig();
            if (StringUtils.isNotBlank((CharSequence)this.userDisplayName)) {
                config.setString("user", null, "name", this.userDisplayName);
            } else {
                config.unset("user", null, "name");
            }
            if (StringUtils.isNotBlank((CharSequence)this.userEmail)) {
                config.setString("user", null, "email", this.userEmail);
            } else {
                config.unset("user", null, "email");
            }
            if (this.gcAutoDetach != null) {
                config.setBoolean("gc", null, "autoDetach", this.gcAutoDetach.booleanValue());
            }
            config.save();
            List remoteBranches = this.git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
            TreeSet<String> localBranches = this.getAvailableBranches();
            String remotePrefix = "refs/remotes/origin/";
            for (Ref remoteBranch : remoteBranches) {
                if (remoteBranch.isSymbolic()) {
                    this.log.debug("Skip the symbolic branch '{}'.", (Object)remoteBranch.getName());
                    continue;
                }
                if (!remoteBranch.getName().startsWith(remotePrefix)) {
                    this.log.warn("The branch {} will not be tracked", (Object)remoteBranch.getName());
                    continue;
                }
                String branchName = remoteBranch.getName().substring(remotePrefix.length());
                try {
                    if (localBranches.contains(branchName)) continue;
                    this.createRemoteTrackingBranch(branchName);
                }
                catch (RefAlreadyExistsException e) {
                    this.log.warn("The branch {} will not be tracked because a branch with the same name already exists. Branches with the same name, but different capitalization do not work on non-case sensitive OS.", (Object)remoteBranch.getName());
                }
            }
            this.noVerify = false;
            File hookDir = new File(this.git.getRepository().getDirectory(), "hooks");
            File preCommitHook = new File(hookDir, "pre-commit");
            File commitMsgHook = new File(hookDir, "commit-msg");
            if (!preCommitHook.isFile() && !commitMsgHook.isFile()) {
                this.log.debug("Hooks are absent");
                this.noVerify = true;
            } else {
                try {
                    if (!Files.isExecutable(preCommitHook.toPath()) || !Files.isExecutable(commitMsgHook.toPath())) {
                        this.log.debug("Hook exists but not executable");
                        this.noVerify = true;
                    }
                }
                catch (SecurityException e) {
                    this.log.warn("Hook exists but there is no access to invoke the file.", (Throwable)e);
                    this.noVerify = true;
                }
            }
            if (!shouldCloneOrInit && this.uri != null) {
                boolean branchAbsents;
                block53: {
                    try {
                        FetchResult fetchResult = this.fetchAll();
                        this.doFastForward(fetchResult);
                        this.fastForwardNotMergedCommits(fetchResult);
                    }
                    catch (Exception e) {
                        this.log.warn(e.getMessage(), (Throwable)e);
                        if (this.credentialsProvider != null) {
                            if (this.credentialsProvider.isHasAuthorizationFailure()) {
                                throw new IOException("Incorrect login or password for git repository.");
                            }
                        }
                        String message = e.getMessage();
                        if (message == null || !message.contains(JGitText.get().noCredentialsProvider)) break block53;
                        throw new IOException("Authentication is required but login and password has not been specified.");
                    }
                }
                boolean bl = branchAbsents = this.git.getRepository().findRef(this.branch) == null;
                if (branchAbsents) {
                    this.createRemoteTrackingBranch(this.branch);
                }
            }
            this.readBranches();
            this.monitor = new ChangesMonitor((RevisionGetter)new GitRevisionGetter(), this.listenerTimerPeriod);
            return;
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
            if (cause == null) {
                cause = e;
            }
            if (!(cause instanceof UnknownHostException)) throw new RRepositoryException(e.getMessage(), (Throwable)e);
            String error = "Invalid URL " + this.uri;
            throw new RRepositoryException(error, (Throwable)new IllegalArgumentException(error));
        }
        finally {
            writeLock.unlock();
            this.log.debug("initialize(): unlock");
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.monitor != null) {
            this.monitor.release();
            this.monitor = null;
        }
        if (this.git != null) {
            this.git.close();
            this.git = null;
        }
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public void setLocalRepositoryPath(String localRepositoryPath) {
        this.localRepositoryPath = localRepositoryPath;
    }

    public void setBranch(String branch) {
        this.baseBranch = this.branch = StringUtils.isBlank((CharSequence)branch) ? "master" : branch;
    }

    public void setTagPrefix(String tagPrefix) {
        this.tagPrefix = StringUtils.trimToEmpty((String)tagPrefix);
    }

    public void setListenerTimerPeriod(int listenerTimerPeriod) {
        this.listenerTimerPeriod = listenerTimerPeriod;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setCommentTemplate(String commentTemplate) {
        this.commentTemplate = commentTemplate;
        String ct = commentTemplate.replaceAll("\\{commit-type}", "{0}").replaceAll("\\{user-message}", "{1}").replaceAll("\\{username}", "{2}");
        this.escapedCommentTemplate = this.escapeCurlyBrackets(ct);
        this.commitMessageParser = new CommitMessageParser(commentTemplate);
    }

    public void setGitSettingsPath(String gitSettingsPath) {
        this.gitSettingsPath = gitSettingsPath;
    }

    public void setGcAutoDetach(Boolean gcAutoDetach) {
        this.gcAutoDetach = gcAutoDetach;
    }

    private static TreeWalk buildTreeWalk(Repository repository, String path, RevTree tree) throws IOException {
        TreeWalk treeWalk;
        if (StringUtils.isEmpty((CharSequence)path)) {
            treeWalk = new TreeWalk(repository);
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(true);
            treeWalk.setPostOrderTraversal(false);
        } else {
            treeWalk = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)tree);
        }
        if (treeWalk == null) {
            throw new FileNotFoundException(String.format("Did not find expected path '%s' in tree '%s'", path, tree.getName()));
        }
        return treeWalk;
    }

    private FileData createFileData(TreeWalk dirWalk, String baseFolder, ObjectId start) {
        String fullPath = baseFolder + dirWalk.getPathString();
        return new LazyFileData(this.branch, fullPath, this, start, this.getFileId(dirWalk), this.commitMessageParser);
    }

    private boolean isEmpty() throws IOException {
        Ref headRef = this.git.getRepository().exactRef("HEAD");
        return headRef == null || headRef.getObjectId() == null;
    }

    private ObjectId resolveBranchId() throws IOException {
        ObjectId branchId = this.git.getRepository().resolve(this.branch);
        if (branchId == null) {
            throw new IOException(String.format("Cannot find branch '%s'", this.branch));
        }
        return branchId;
    }

    private FileData createFileData(TreeWalk dirWalk, RevCommit fileCommit) {
        String fullPath = dirWalk.getPathString();
        return new LazyFileData(this.branch, fullPath, this, fileCommit, this.getFileId(dirWalk), this.commitMessageParser);
    }

    private ObjectId getFileId(TreeWalk dirWalk) {
        int fileModeBits = dirWalk.getFileMode().getBits();
        ObjectId fileId = null;
        if ((fileModeBits & 0x8000) != 0) {
            fileId = dirWalk.getObjectId(0);
        }
        return fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectId getLastRevision() throws GitAPIException, IOException {
        FetchResult fetchResult = null;
        Lock readLock = this.repositoryLock.readLock();
        if (this.uri != null) {
            try {
                readLock.lock();
                boolean remoteLocked = this.remoteRepoLock.tryLock();
                if (!remoteLocked) {
                    ObjectId objectId = null;
                    return objectId;
                }
                try {
                    fetchResult = this.fetchAll();
                }
                finally {
                    this.remoteRepoLock.unlock();
                }
            }
            finally {
                readLock.unlock();
            }
        }
        boolean branchesChanged = false;
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            this.log.debug("getLastRevision(): lock write");
            writeLock.lock();
            if (fetchResult != null) {
                branchesChanged = this.doFastForward(fetchResult);
                this.fastForwardNotMergedCommits(fetchResult);
            }
            TreeSet<String> availableBranches = this.getAvailableBranches();
            for (List<String> projectBranches : this.branches.values()) {
                projectBranches.removeIf(branch -> !availableBranches.contains(branch));
            }
            this.saveBranches();
        }
        finally {
            writeLock.unlock();
            this.log.debug("getLastRevision(): unlock write");
        }
        if (branchesChanged) {
            this.monitor.fireOnChange();
        }
        try {
            this.log.debug("getLastRevision(): lock");
            readLock.lock();
            ObjectId objectId = this.git.getRepository().resolve("HEAD^{tree}");
            return objectId;
        }
        finally {
            readLock.unlock();
            this.log.debug("getLastRevision(): unlock");
        }
    }

    private boolean doFastForward(FetchResult fetchResult) throws GitAPIException, IOException {
        boolean branchesChanged = false;
        block7: for (TrackingRefUpdate refUpdate : fetchResult.getTrackingRefUpdates()) {
            RefUpdate.Result result = refUpdate.getResult();
            switch (result) {
                case FAST_FORWARD: {
                    if (!this.isEmpty()) {
                        this.checkoutForced(refUpdate.getRemoteName());
                    }
                    this.git.merge().include((AnyObjectId)refUpdate.getNewObjectId()).setFastForward(MergeCommand.FastForwardMode.FF_ONLY).call();
                    break;
                }
                case REJECTED_CURRENT_BRANCH: {
                    this.checkoutForced(this.baseBranch);
                    break;
                }
                case FORCED: {
                    String currentBranch;
                    String remoteName;
                    if (!ObjectId.zeroId().equals((AnyObjectId)refUpdate.getNewObjectId()) || !(remoteName = refUpdate.getRemoteName()).startsWith("refs/heads/")) continue block7;
                    String branchToDelete = Repository.shortenRefName((String)remoteName);
                    if (branchToDelete.equals(currentBranch = Repository.shortenRefName((String)this.git.getRepository().getFullBranch()))) {
                        String branchToCheckout = this.baseBranch;
                        if (branchToCheckout.equals(branchToDelete)) {
                            branchToCheckout = "master";
                        }
                        if (this.getAvailableBranches().contains(branchToCheckout)) {
                            this.checkoutForced(branchToCheckout);
                        } else {
                            this.git.checkout().setName(branchToCheckout).setCreateBranch(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + branchToCheckout).call();
                        }
                    }
                    this.git.branchDelete().setBranchNames(new String[]{branchToDelete}).setForce(true).call();
                    branchesChanged = true;
                    break;
                }
                case NEW: {
                    String remoteName;
                    if (!ObjectId.zeroId().equals((AnyObjectId)refUpdate.getOldObjectId()) || !(remoteName = refUpdate.getRemoteName()).startsWith("refs/heads/")) continue block7;
                    this.createRemoteTrackingBranch(Repository.shortenRefName((String)remoteName));
                    branchesChanged = true;
                    break;
                }
                case NO_CHANGE: {
                    break;
                }
                default: {
                    this.log.warn("Unsupported type of fetch result type: {}", (Object)result);
                }
            }
        }
        return branchesChanged;
    }

    private void fastForwardNotMergedCommits(FetchResult fetchResult) throws IOException, GitAPIException {
        Ref advertisedRef = fetchResult.getAdvertisedRef("refs/heads/" + this.branch);
        Ref localRef = this.git.getRepository().findRef(this.branch);
        if (localRef != null && advertisedRef != null && !localRef.getObjectId().equals((AnyObjectId)advertisedRef.getObjectId())) {
            if (this.isMergedInto(advertisedRef.getObjectId(), localRef.getObjectId())) {
                this.log.warn("Advertised commit is already merged into current head in branch '{}'. Current HEAD: {}, advertised ref: {}", new Object[]{this.branch, localRef.getObjectId().name(), advertisedRef.getObjectId().name()});
            } else {
                this.log.warn("Found commits that are not fast forwarded in branch '{}'. Current HEAD: {}, advertised ref: {}", new Object[]{this.branch, localRef.getObjectId().name(), advertisedRef.getObjectId().name()});
                this.checkoutForced(this.branch);
                this.git.merge().include(advertisedRef).setFastForward(MergeCommand.FastForwardMode.FF_ONLY).call();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pull(String commitToRevert, String mergeAuthor) throws GitAPIException, IOException {
        FetchResult fetchResult;
        if (this.uri == null) {
            return;
        }
        try {
            this.remoteRepoLock.lock();
            fetchResult = this.fetchAll();
        }
        finally {
            this.remoteRepoLock.unlock();
        }
        try {
            Ref r = fetchResult.getAdvertisedRef(this.branch);
            if (r == null) {
                r = fetchResult.getAdvertisedRef("refs/heads/" + this.branch);
            }
            if (r == null) {
                throw new RefNotAdvertisedException(MessageFormat.format(JGitText.get().couldNotGetAdvertisedRef, "origin", this.branch));
            }
            String mergeMessage = this.getMergeMessage(mergeAuthor, r);
            MergeResult mergeResult = this.git.merge().include((AnyObjectId)r.getObjectId()).setStrategy((MergeStrategy)MergeStrategy.RECURSIVE).setMessage(mergeMessage).call();
            if (!mergeResult.getMergeStatus().isSuccessful()) {
                this.validateMergeConflict(mergeResult, true);
                throw new IOException("Cannot merge: " + mergeResult.toString());
            }
        }
        catch (IOException | GitAPIException e) {
            this.reset(commitToRevert);
            throw e;
        }
        finally {
            try {
                this.doFastForward(fetchResult);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void validateMergeConflict(MergeResult mergeResult, boolean theirToOur) throws GitAPIException, IOException {
        if (mergeResult != null && mergeResult.getMergeStatus() == MergeResult.MergeStatus.CONFLICTING) {
            String commit;
            ObjectId[] mergedCommits = mergeResult.getMergedCommits();
            Repository repository = this.git.getRepository();
            List tags = this.git.tagList().call();
            String baseCommit = GitRepository.getVersionName(repository, tags, mergeResult.getBase());
            String ourCommit = null;
            String theirCommit = null;
            ObjectId ourId = null;
            ObjectId theirId = null;
            if (mergedCommits.length > 0) {
                commit = GitRepository.getVersionName(repository, tags, mergedCommits[0]);
                if (theirToOur) {
                    ourId = mergedCommits[0];
                    ourCommit = commit;
                } else {
                    theirId = mergedCommits[0];
                    theirCommit = commit;
                }
            }
            if (mergedCommits.length > 1) {
                commit = GitRepository.getVersionName(repository, tags, mergedCommits[1]);
                if (theirToOur) {
                    theirId = mergedCommits[1];
                    theirCommit = commit;
                } else {
                    ourId = mergedCommits[1];
                    ourCommit = commit;
                }
            }
            Set conflictedFiles = mergeResult.getConflicts().keySet();
            HashMap<String, String> diffs = new HashMap<String, String>();
            if (ourId != null && theirId != null) {
                AbstractTreeIterator ourTreeParser = GitRepository.prepareTreeParser(repository, ourId);
                AbstractTreeIterator theirTreeParser = GitRepository.prepareTreeParser(repository, theirId);
                List diff = this.git.diff().setOldTree(theirTreeParser).setNewTree(ourTreeParser).setPathFilter(PathFilterGroup.createFromStrings(conflictedFiles)).call();
                for (DiffEntry entry : diff) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DiffFormatter formatter = new DiffFormatter((OutputStream)outputStream);
                    Throwable throwable = null;
                    try {
                        formatter.setRepository(repository);
                        formatter.format(entry);
                        String path = entry.getChangeType() == DiffEntry.ChangeType.DELETE ? entry.getOldPath() : entry.getNewPath();
                        String comparison = outputStream.toString(StandardCharsets.UTF_8.name());
                        diffs.put(path, comparison);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (formatter == null) continue;
                        if (throwable != null) {
                            try {
                                formatter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        formatter.close();
                    }
                }
            }
            throw new MergeConflictException(diffs, baseCommit, ourCommit, theirCommit);
        }
    }

    private static AbstractTreeIterator prepareTreeParser(Repository repository, ObjectId objectId) throws IOException {
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit commit = walk.parseCommit((AnyObjectId)objectId);
            RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            try (ObjectReader reader = repository.newObjectReader();){
                treeParser.reset(reader, (AnyObjectId)tree.getId());
            }
            walk.dispose();
            CanonicalTreeParser canonicalTreeParser = treeParser;
            return canonicalTreeParser;
        }
    }

    private FetchResult fetchAll() throws GitAPIException, IOException {
        FetchCommand fetchCommand = this.git.fetch();
        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
        if (credentialsProvider != null) {
            fetchCommand.setCredentialsProvider(credentialsProvider);
        }
        fetchCommand.setRefSpecs(new RefSpec[]{new RefSpec().setSourceDestination("refs/heads/*", "refs/remotes/origin/*")});
        fetchCommand.setRemoveDeletedRefs(true);
        fetchCommand.setTimeout(this.connectionTimeout);
        return fetchCommand.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push() throws GitAPIException, IOException {
        if (this.uri == null) {
            return;
        }
        try {
            this.remoteRepoLock.lock();
            PushCommand push = (PushCommand)this.git.push().setPushTags().add(this.branch).setTimeout(this.connectionTimeout);
            CredentialsProvider credentialsProvider = this.getCredentialsProvider();
            if (credentialsProvider != null) {
                push.setCredentialsProvider(credentialsProvider);
            }
            Iterable results = push.call();
            this.validatePushResults(results);
        }
        finally {
            this.remoteRepoLock.unlock();
        }
    }

    private void validatePushResults(Iterable<PushResult> results) throws IOException {
        for (PushResult result : results) {
            Collection remoteUpdates = result.getRemoteUpdates();
            block9: for (RemoteRefUpdate remoteUpdate : remoteUpdates) {
                RemoteRefUpdate.Status status = remoteUpdate.getStatus();
                switch (status) {
                    case OK: 
                    case UP_TO_DATE: 
                    case NON_EXISTING: {
                        continue block9;
                    }
                    case REJECTED_NONFASTFORWARD: {
                        throw new IOException("Remote ref update was rejected, as it would cause non fast-forward update.");
                    }
                    case REJECTED_NODELETE: {
                        throw new IOException("Remote ref update was rejected, because remote side does not support/allow deleting refs.");
                    }
                    case REJECTED_REMOTE_CHANGED: {
                        throw new IOException("Remote ref update was rejected, because old object id on remote repository wasn't the same as defined expected old object.");
                    }
                    case REJECTED_OTHER_REASON: {
                        throw new IOException(remoteUpdate.getMessage());
                    }
                    case AWAITING_REPORT: {
                        throw new IOException("Push process is awaiting update report from remote repository. This is a temporary state or state after critical error in push process.");
                    }
                }
                throw new IOException("Push process returned with status " + status + " and message " + remoteUpdate.getMessage());
            }
        }
    }

    /*
     * Exception decompiling
     */
    private <T> T iterate(String path, WalkCommand<T> command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> T iterateHistory(String name, HistoryVisitor<T> historyVisitor) throws IOException {
        Lock readLock = this.repositoryLock.readLock();
        try {
            this.log.debug("iterateHistory(): lock");
            readLock.lock();
            if (this.isEmpty()) {
                T t = historyVisitor.getResult();
                return t;
            }
            Iterator iterator = this.git.log().add((AnyObjectId)this.resolveBranchId()).call().iterator();
            List tags = this.git.tagList().call();
            Repository repository = this.git.getRepository();
            try (ObjectReader or = repository.newObjectReader();){
                TreeWalk tw = GitRepository.createTreeWalk(or, name);
                while (iterator.hasNext()) {
                    boolean stop;
                    RevCommit commit = (RevCommit)iterator.next();
                    if (!GitRepository.hasChangesInPath(tw, commit) || !(stop = historyVisitor.visit(name, commit, GitRepository.getVersionName(repository, tags, (ObjectId)commit)))) continue;
                    break;
                }
            }
            T t = historyVisitor.getResult();
            return t;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            readLock.unlock();
            this.log.debug("iterateHistory(): unlock");
        }
    }

    /*
     * Loose catch block
     */
    private <T> T parseHistory(String name, String version, HistoryVisitor<T> historyVisitor) throws IOException {
        Lock readLock = this.repositoryLock.readLock();
        try {
            T t;
            Throwable throwable;
            RevWalk walk;
            block27: {
                block28: {
                    List tags;
                    block24: {
                        T t2;
                        block25: {
                            block26: {
                                this.log.debug("parseHistory(): lock");
                                readLock.lock();
                                tags = this.git.tagList().call();
                                walk = new RevWalk(this.git.getRepository());
                                throwable = null;
                                if (!this.isEmpty()) break block24;
                                t2 = historyVisitor.getResult();
                                if (walk == null) break block25;
                                if (throwable == null) break block26;
                                try {
                                    walk.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block25;
                            }
                            walk.close();
                        }
                        return t2;
                    }
                    RevCommit commit = walk.parseCommit((AnyObjectId)this.getCommitByVersion(version));
                    historyVisitor.visit(name, commit, GitRepository.getVersionName(this.git.getRepository(), tags, (ObjectId)commit));
                    t = historyVisitor.getResult();
                    if (walk == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        walk.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block27;
                }
                walk.close();
            }
            return t;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (walk != null) {
                            if (throwable != null) {
                                try {
                                    walk.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                walk.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (MissingObjectException e) {
                    this.log.error(e.getMessage());
                    T t3 = null;
                    return t3;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        finally {
            readLock.unlock();
            this.log.debug("parseHistory(): unlock");
        }
    }

    private void reset() {
        this.reset(null);
    }

    private void reset(String commitToDiscard) {
        block9: {
            try {
                String fullBranch = this.git.getRepository().getFullBranch();
                if (ObjectId.isId((String)fullBranch)) {
                    this.log.debug("Found detached HEAD: {}.", (Object)fullBranch);
                    this.git.checkout().setName(this.branch).setForced(true).call();
                    break block9;
                }
                ResetCommand resetCommand = this.git.reset().setMode(ResetCommand.ResetType.HARD);
                if (commitToDiscard != null && this.isCommitMerged(commitToDiscard)) {
                    this.log.debug("Discard commit: {}.", (Object)commitToDiscard);
                    resetCommand.setRef(commitToDiscard + "^");
                }
                try {
                    resetCommand.call();
                }
                catch (JGitInternalException e) {
                    File indexFile = this.git.getRepository().getIndexFile();
                    try {
                        DirCache dc = new DirCache(indexFile, this.git.getRepository().getFS());
                        dc.read();
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (CorruptObjectException ex) {
                        this.log.error("git index file is corrupted and will be deleted", (Throwable)e);
                        if (!indexFile.delete() && indexFile.exists()) {
                            this.log.warn("Can't delete corrupted index file {}.", (Object)indexFile);
                        }
                        resetCommand.call();
                    }
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void resetToCommit(String refToResetTo) {
        try {
            if (refToResetTo != null) {
                this.git.reset().setMode(ResetCommand.ResetType.HARD).setRef(refToResetTo).call();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void checkoutForcedOrReset(String branch) throws IOException, GitAPIException {
        if (this.isEmpty()) {
            this.reset();
        } else {
            this.checkoutForced(branch);
        }
    }

    private void checkoutForced(String branch) throws GitAPIException, IOException {
        this.git.checkout().setName(branch).setForced(true).call();
    }

    private boolean isCommitMerged(String commitId) throws IOException {
        Repository repository = this.git.getRepository();
        try (RevWalk revWalk = new RevWalk(repository);){
            RevCommit branchHead = revWalk.parseCommit((AnyObjectId)repository.resolve("refs/heads/" + this.branch));
            RevCommit otherHead = revWalk.parseCommit((AnyObjectId)repository.resolve(commitId));
            boolean bl = revWalk.isMergedInto(otherHead, branchHead);
            return bl;
        }
    }

    private String getNextTagId() throws GitAPIException {
        List call = this.git.tagList().call();
        long maxId = 0L;
        for (Ref tagRef : call) {
            int num;
            String name = GitRepository.getLocalTagName(tagRef);
            if (!name.startsWith(this.tagPrefix)) continue;
            try {
                num = Integer.parseInt(name.substring(this.tagPrefix.length()));
            }
            catch (NumberFormatException e) {
                this.log.debug("Tag {} is skipped because it does not contain version number", (Object)name);
                continue;
            }
            if ((long)num <= maxId) continue;
            maxId = num;
        }
        return String.valueOf(maxId + 1L);
    }

    static String getVersionName(Repository repository, List<Ref> tags, ObjectId commitId) throws IOException {
        Ref tagRef = GitRepository.getTagRefForCommit(repository, tags, commitId);
        return tagRef != null ? GitRepository.getLocalTagName(tagRef) : commitId.getName();
    }

    static RevCommit findFirstCommit(Git git, ObjectId startCommit, String path) throws IOException, GitAPIException {
        Repository repository = git.getRepository();
        try (ObjectReader or = repository.newObjectReader();){
            TreeWalk tw = GitRepository.createTreeWalk(or, path);
            for (RevCommit commit : git.log().add((AnyObjectId)startCommit).call()) {
                if (!GitRepository.hasChangesInPath(tw, commit)) continue;
                RevCommit revCommit = commit;
                return revCommit;
            }
        }
        return null;
    }

    private static boolean hasChangesInPath(TreeWalk tw, RevCommit commit) throws IOException {
        RevCommit[] parents = commit.getParents();
        int parentsNum = parents.length;
        ObjectId[] trees = new ObjectId[parentsNum + 1];
        for (int i = 0; i < parentsNum; ++i) {
            trees[i] = parents[i].getTree();
        }
        trees[parentsNum] = commit.getTree();
        tw.reset((AnyObjectId[])trees);
        while (tw.next()) {
            if (parentsNum == 0) {
                return true;
            }
            int currentMode = tw.getRawMode(parentsNum);
            for (int i = 0; i < parentsNum; ++i) {
                int parentMode = tw.getRawMode(i);
                if (currentMode == parentMode && tw.idEqual(i, parentsNum)) continue;
                return true;
            }
        }
        return false;
    }

    private static TreeWalk createTreeWalk(ObjectReader or, String path) {
        TreeFilter t = AndTreeFilter.create((TreeFilter)PathFilterGroup.create(Collections.singleton(PathFilter.create((String)path))), (TreeFilter)TreeFilter.ANY_DIFF);
        TreeWalk tw = new TreeWalk(or);
        tw.setFilter(t);
        tw.setRecursive(t.shouldBeRecursive());
        return tw;
    }

    private static Ref getTagRefForCommit(Repository repository, List<Ref> tags, ObjectId commitId) throws IOException {
        Ref tagRefForCommit = null;
        for (Ref tagRef : tags) {
            ObjectId objectId = repository.getRefDatabase().peel(tagRef).getPeeledObjectId();
            if (objectId == null) {
                objectId = tagRef.getObjectId();
            }
            if (!objectId.equals((AnyObjectId)commitId)) continue;
            tagRefForCommit = tagRef;
            break;
        }
        return tagRefForCommit;
    }

    private static String getLocalTagName(Ref tagRef) {
        String name = tagRef.getName();
        return name.startsWith("refs/tags/") ? name.substring("refs/tags/".length()) : name;
    }

    private void addTagToCommit(RevCommit commit, String mergeAuthor) throws GitAPIException, IOException {
        this.addTagToCommit(commit, commit.getId().getName(), mergeAuthor);
    }

    private void addTagToCommit(RevCommit commit, String commitToRevert, String mergeAuthor) throws GitAPIException, IOException {
        this.pull(commitToRevert, mergeAuthor);
        if (!this.tagPrefix.isEmpty()) {
            String tagName = this.tagPrefix + this.getNextTagId();
            this.git.tag().setObjectId((RevObject)commit).setName(tagName).call();
        }
    }

    public List<FileData> listFolders(String path) throws IOException {
        return this.iterate(path, new ListFoldersCommand());
    }

    public FileData save(FileData folderData, Iterable<FileItem> files, ChangesetType changesetType) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            this.log.debug("save(folderData, files, changesetType): lock");
            writeLock.lock();
            this.saveMultipleFiles(folderData, files, changesetType);
        }
        catch (IOException e) {
            this.reset();
            throw e;
        }
        catch (Exception e) {
            this.reset();
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("save(folderData, files, changesetType): unlock");
        }
        this.monitor.fireOnChange();
        return this.check(folderData.getName());
    }

    public List<FileData> save(List<FolderItem> folderItems, ChangesetType changesetType) throws IOException {
        ArrayList<FileData> result = new ArrayList<FileData>();
        Lock writeLock = this.repositoryLock.writeLock();
        String firstCommitId = null;
        try {
            this.log.debug("save(folderItems, changesetType): lock");
            writeLock.lock();
            this.checkoutForcedOrReset(this.branch);
            for (FolderItem folderItem : folderItems) {
                RevCommit commit = this.createCommit(folderItem.getData(), folderItem.getFiles(), changesetType);
                if (firstCommitId == null) {
                    firstCommitId = commit.getId().getName();
                }
                this.resolveAndMerge(folderItem.getData(), false, commit);
                this.addTagToCommit(commit, firstCommitId, folderItem.getData().getAuthor());
            }
            this.push();
        }
        catch (IOException e) {
            this.reset(firstCommitId);
            throw e;
        }
        catch (Exception e) {
            this.reset(firstCommitId);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("save(folderItems, changesetType): unlock");
        }
        this.monitor.fireOnChange();
        for (FolderItem folderItem : folderItems) {
            result.add(this.check(folderItem.getData().getName()));
        }
        return result;
    }

    public void pull(String author) throws IOException {
        if (this.uri == null) {
            return;
        }
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            this.log.debug("pull(author): lock");
            writeLock.lock();
            this.checkoutForcedOrReset(this.branch);
            this.pull(null, author);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("pull(author): unlock");
        }
    }

    public void merge(String branchFrom, String author, ConflictResolveData conflictResolveData) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        String refToResetTo = null;
        try {
            this.log.debug("merge(): lock");
            writeLock.lock();
            this.checkoutForcedOrReset(this.branch);
            if (conflictResolveData == null) {
                this.pull(null, author);
            }
            refToResetTo = this.git.getRepository().findRef(this.branch).getObjectId().getName();
            Ref branchRef = this.git.getRepository().findRef(branchFrom);
            String mergeMessage = this.getMergeMessage(author, branchRef);
            MergeResult mergeResult = this.git.merge().include(branchRef).setMessage(mergeMessage).call();
            if (conflictResolveData != null) {
                this.resolveConflict(mergeResult, conflictResolveData, author);
            } else {
                this.validateMergeConflict(mergeResult, true);
            }
            this.pull(null, author);
            this.push();
        }
        catch (IOException e) {
            this.resetToCommit(refToResetTo);
            throw e;
        }
        catch (Exception e) {
            this.resetToCommit(refToResetTo);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("merge(): unlock");
        }
        this.monitor.fireOnChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMergedInto(String from, String to) throws IOException {
        Lock readLock = this.repositoryLock.readLock();
        try {
            this.log.debug("isMergedInto(): lock");
            readLock.lock();
            Repository repository = this.git.getRepository();
            boolean bl = this.isMergedInto(repository.resolve(from), repository.resolve(to));
            return bl;
        }
        finally {
            readLock.unlock();
            this.log.debug("isMergedInto(): unlock");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMergedInto(ObjectId fromId, ObjectId toId) throws IOException {
        Repository repository = this.git.getRepository();
        try (RevWalk revWalk = new RevWalk(repository);){
            if (fromId == null || toId == null) {
                boolean bl = false;
                return bl;
            }
            RevCommit fromCommit = revWalk.parseCommit((AnyObjectId)fromId);
            RevCommit toCommit = revWalk.parseCommit((AnyObjectId)toId);
            boolean bl = revWalk.isMergedInto(fromCommit, toCommit);
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void saveMultipleFiles(FileData folderData, Iterable<FileItem> files, ChangesetType changesetType) throws IOException {
        String commitId = null;
        try {
            String parentVersion = folderData.getVersion();
            boolean checkoutOldVersion = this.isCheckoutOldVersion(folderData.getName(), parentVersion);
            this.checkoutForcedOrReset(checkoutOldVersion ? parentVersion : this.branch);
            RevCommit commit = this.createCommit(folderData, files, changesetType);
            commitId = commit.getId().getName();
            this.resolveAndMerge(folderData, checkoutOldVersion, commit);
            this.addTagToCommit(commit, folderData.getAuthor());
            this.push();
        }
        catch (IOException e) {
            this.reset(commitId);
            throw e;
        }
        catch (Exception e) {
            this.reset(commitId);
            throw new IOException(e.getMessage(), e);
        }
    }

    private RevCommit createCommit(FileData folderData, Iterable<FileItem> files, ChangesetType changesetType) throws IOException, GitAPIException {
        String relativeFolder = folderData.getName();
        ArrayList<String> changedFiles = new ArrayList<String>();
        ArrayList<File> savedFiles = new ArrayList<File>();
        for (FileItem change : files) {
            File file = new File(this.localRepositoryPath, change.getData().getName());
            savedFiles.add(file);
            this.applyChangeInWorkspace(change, changedFiles);
        }
        if (changesetType == ChangesetType.FULL) {
            String basePath = new File(this.localRepositoryPath).getAbsolutePath();
            File folder = new File(this.localRepositoryPath, relativeFolder);
            this.removeAbsentFiles(basePath, folder, savedFiles, changedFiles);
        }
        CommitCommand commitCommand = this.git.commit().setNoVerify(this.noVerify).setMessage(this.formatComment(CommitType.SAVE, folderData)).setCommitter(this.userDisplayName != null ? this.userDisplayName : folderData.getAuthor(), this.userEmail != null ? this.userEmail : "");
        return this.commitChangedFiles(commitCommand, changedFiles);
    }

    private void applyChangeInWorkspace(FileItem change, Collection<String> changedFiles) throws IOException, GitAPIException {
        File file = new File(this.localRepositoryPath, change.getData().getName());
        this.createParent(file);
        InputStream stream = change.getStream();
        if (stream != null) {
            try (FileOutputStream output = new FileOutputStream(file);){
                IOUtils.copy((InputStream)stream, (OutputStream)output);
            }
            this.git.add().addFilepattern(change.getData().getName()).call();
            changedFiles.add(change.getData().getName());
        } else if (file.exists()) {
            this.git.rm().addFilepattern(change.getData().getName()).call();
            changedFiles.add(change.getData().getName());
        }
    }

    private RevCommit commitChangedFiles(CommitCommand commitCommand, Collection<String> changedFiles) throws GitAPIException {
        RevCommit commit;
        if (this.git.status().call().getUncommittedChanges().isEmpty()) {
            commit = commitCommand.setAllowEmpty(true).call();
        } else {
            for (String fileName : changedFiles) {
                commitCommand.setOnly(fileName);
            }
            commit = commitCommand.call();
        }
        return commit;
    }

    private void resolveAndMerge(FileData folderData, boolean checkoutOldVersion, RevCommit commit) throws GitAPIException, IOException {
        ConflictResolveData conflictResolveData = (ConflictResolveData)folderData.getAdditionalData(ConflictResolveData.class);
        RevCommit lastCommit = commit;
        if (conflictResolveData != null) {
            lastCommit = this.resolveConflict(folderData.getAuthor(), conflictResolveData);
        }
        if (checkoutOldVersion || conflictResolveData != null) {
            this.checkoutForced(this.branch);
            ObjectId commitId = lastCommit.getId();
            ObjectIdRef.Unpeeled ref = new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, commitId.name(), commitId.copy());
            String mergeMessage = this.getMergeMessage(folderData.getAuthor(), (Ref)ref);
            MergeResult mergeDetached = this.git.merge().include((AnyObjectId)commitId).setMessage(mergeMessage).call();
            this.validateMergeConflict(mergeDetached, false);
        }
    }

    private RevCommit resolveConflict(String author, ConflictResolveData conflictResolveData) throws GitAPIException, IOException {
        MergeResult mergeResult = this.git.merge().include((AnyObjectId)this.getCommitByVersion(conflictResolveData.getCommitToMerge())).call();
        return this.resolveConflict(mergeResult, conflictResolveData, author);
    }

    private RevCommit resolveConflict(MergeResult mergeResult, ConflictResolveData conflictResolveData, String author) throws IOException, GitAPIException {
        if (mergeResult.getMergeStatus() != MergeResult.MergeStatus.CONFLICTING) {
            this.log.debug("Merge status: {}", (Object)mergeResult.getMergeStatus());
            throw new IOException("There is no merge conflict, nothing to resolve.");
        }
        String mergeMessage = conflictResolveData.getMergeMessage();
        if (mergeMessage == null) {
            mergeMessage = "Merge";
        }
        CommitCommand conflictResolveCommit = this.git.commit().setNoVerify(this.noVerify).setMessage(mergeMessage).setCommitter(this.userDisplayName != null ? this.userDisplayName : author, this.userEmail != null ? this.userEmail : "");
        Status status = this.git.status().call();
        HashSet<String> changedFiles = new HashSet<String>();
        for (FileItem change : conflictResolveData.getResolvedFiles()) {
            this.applyChangeInWorkspace(change, changedFiles);
        }
        for (String changed : status.getChanged()) {
            if (changedFiles.contains(changed)) continue;
            this.git.add().addFilepattern(changed).call();
            changedFiles.add(changed);
        }
        for (String added : status.getAdded()) {
            if (changedFiles.contains(added)) continue;
            this.git.add().addFilepattern(added).call();
            changedFiles.add(added);
        }
        for (String removed : status.getRemoved()) {
            if (changedFiles.contains(removed)) continue;
            this.git.rm().addFilepattern(removed).call();
            changedFiles.add(removed);
        }
        return this.commitChangedFiles(conflictResolveCommit, changedFiles);
    }

    private ObjectId getCommitByVersion(String version) throws IOException {
        Ref ref = this.git.getRepository().findRef(version);
        if (ref == null) {
            return this.git.getRepository().resolve(version);
        }
        ObjectId objectId = this.git.getRepository().getRefDatabase().peel(ref).getPeeledObjectId();
        return objectId == null ? ref.getObjectId() : objectId;
    }

    public Features supports() {
        return new FeaturesBuilder((org.openl.rules.repository.api.Repository)this).setSupportsUniqueFileId(true).build();
    }

    public String getBranch() {
        return this.branch;
    }

    public void createBranch(String projectName, String newBranch) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            List<String> projectBranches;
            boolean branchAbsents;
            this.log.debug("createBranch(): lock");
            writeLock.lock();
            this.reset();
            boolean bl = branchAbsents = this.git.getRepository().findRef(newBranch) == null;
            if (branchAbsents) {
                if (this.isEmpty()) {
                    throw new IOException("Can't create a branch on the empty repository.");
                }
                this.checkoutForced(this.branch);
                this.git.branchCreate().setName(newBranch).call();
                this.pushBranch(new RefSpec().setSource(newBranch).setDestination("refs/heads/" + newBranch));
            }
            if ((projectBranches = this.branches.get(projectName)) == null) {
                projectBranches = new ArrayList<String>();
                projectBranches.add(this.branch);
                this.branches.put(projectName, projectBranches);
            }
            if (!projectBranches.contains(newBranch)) {
                projectBranches.add(newBranch);
            }
            this.saveBranches();
        }
        catch (IOException e) {
            this.reset();
            try {
                this.git.branchDelete().setBranchNames(new String[]{newBranch}).call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        catch (Exception e) {
            this.reset();
            try {
                this.git.branchDelete().setBranchNames(new String[]{newBranch}).call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("createBranch(): unlock");
        }
    }

    public void deleteBranch(String projectName, String branch) throws IOException {
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            this.log.debug("deleteBranch(): lock");
            writeLock.lock();
            this.reset();
            if (projectName == null) {
                for (List<String> projectBranches : this.branches.values()) {
                    projectBranches.remove(branch);
                }
                this.saveBranches();
                this.checkoutForced(this.baseBranch);
                this.git.branchDelete().setBranchNames(new String[]{branch}).setForce(true).call();
                this.pushBranch(new RefSpec().setSource(null).setDestination("refs/heads/" + branch));
            } else {
                List<String> projectBranches = this.branches.get(projectName);
                if (projectBranches != null) {
                    projectBranches.remove(branch);
                    this.saveBranches();
                }
            }
        }
        catch (IOException e) {
            this.reset();
            throw e;
        }
        catch (Exception e) {
            this.reset();
            throw new IOException(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("deleteBranch(): unlock");
        }
    }

    public List<String> getBranches(String projectName) throws IOException {
        Lock readLock = this.repositoryLock.readLock();
        try {
            ArrayList<String> result;
            this.log.debug("getBranches(): lock");
            readLock.lock();
            if (projectName == null) {
                TreeSet<String> branchNames = this.getAvailableBranches();
                for (List<String> projectBranches : this.branches.values()) {
                    branchNames.addAll(projectBranches);
                }
                ArrayList<String> arrayList = new ArrayList<String>(branchNames);
                return arrayList;
            }
            List<String> projectBranches = this.branches.get(projectName);
            if (projectBranches == null) {
                result = new ArrayList<String>(Collections.singletonList(this.branch));
            } else {
                result = new ArrayList<String>(projectBranches);
                result.sort(String.CASE_INSENSITIVE_ORDER);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
        finally {
            readLock.unlock();
            this.log.debug("getBranches(): unlock");
        }
    }

    public GitRepository forBranch(String branch) throws IOException {
        Lock readLock = this.repositoryLock.readLock();
        try {
            this.log.debug("forBranch(): read: lock");
            readLock.lock();
            if (this.git.getRepository().findRef(branch) == null) {
                List refs = this.git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                boolean branchExist = false;
                String remoteBranchName = "refs/remotes/origin/" + branch;
                for (Ref ref : refs) {
                    String name = ref.getName();
                    if (!remoteBranchName.equals(name)) continue;
                    branchExist = true;
                    break;
                }
                if (!branchExist) {
                    throw new IOException(String.format("Cannot find branch '%s'", branch));
                }
            }
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
        finally {
            readLock.unlock();
            this.log.debug("forBranch(): read: unlock");
        }
        Lock writeLock = this.repositoryLock.writeLock();
        try {
            this.log.debug("forBranch(): write: lock");
            writeLock.lock();
            GitRepository branchExist = this.createRepository(branch);
            return branchExist;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            writeLock.unlock();
            this.log.debug("forBranch(): write: unlock");
        }
    }

    private GitRepository createRepository(String branch) throws IOException, GitAPIException {
        if (this.git.getRepository().findRef(branch) == null) {
            this.createRemoteTrackingBranch(branch);
        }
        GitRepository repo = new GitRepository();
        repo.setUri(this.uri);
        repo.setLogin(this.login);
        repo.setPassword(this.password);
        repo.credentialsProvider = this.credentialsProvider;
        repo.setUserDisplayName(this.userDisplayName);
        repo.setUserEmail(this.userEmail);
        repo.setLocalRepositoryPath(this.localRepositoryPath);
        repo.setBranch(branch);
        repo.baseBranch = this.baseBranch;
        repo.setTagPrefix(this.tagPrefix);
        repo.setListenerTimerPeriod(this.listenerTimerPeriod);
        repo.setConnectionTimeout(this.connectionTimeout);
        repo.setCommentTemplate(this.commentTemplate);
        repo.setGitSettingsPath(this.gitSettingsPath);
        repo.git = this.git;
        repo.repositoryLock = this.repositoryLock;
        repo.remoteRepoLock = this.remoteRepoLock;
        repo.branches = this.branches;
        repo.monitor = this.monitor;
        return repo;
    }

    private void createRemoteTrackingBranch(String branch) throws GitAPIException {
        this.git.branchCreate().setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + branch).call();
    }

    TreeSet<String> getAvailableBranches() throws GitAPIException {
        TreeSet<String> branchNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        List refs = this.git.branchList().call();
        for (Ref ref : refs) {
            String name = ref.getName();
            if (!name.startsWith("refs/heads/")) continue;
            name = name.substring("refs/heads/".length());
            branchNames.add(name);
        }
        return branchNames;
    }

    private void pushBranch(RefSpec refSpec) throws GitAPIException, IOException {
        if (this.uri == null) {
            return;
        }
        PushCommand push = (PushCommand)this.git.push().setRefSpecs(new RefSpec[]{refSpec}).setTimeout(this.connectionTimeout);
        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
        if (credentialsProvider != null) {
            push.setCredentialsProvider(credentialsProvider);
        }
        Iterable results = push.call();
        this.validatePushResults(results);
    }

    private void readBranches() throws IOException {
        this.branches.clear();
        if (StringUtils.isBlank((CharSequence)this.gitSettingsPath)) {
            return;
        }
        File settings = new File(new File(this.gitSettingsPath), "branches.properties");
        if (settings.isFile()) {
            try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(settings), StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(in);
                String numStr = properties.getProperty("projects.number");
                if (numStr == null) {
                    return;
                }
                int num = Integer.parseInt(numStr);
                for (int i = 1; i <= num; ++i) {
                    String name = properties.getProperty("project." + i + ".name");
                    String branchesStr = properties.getProperty("project." + i + ".branches");
                    if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)branchesStr)) continue;
                    this.branches.put(name, new ArrayList<String>(Arrays.asList(branchesStr.split(","))));
                }
            }
        }
    }

    private void saveBranches() throws IOException {
        if (StringUtils.isBlank((CharSequence)this.gitSettingsPath)) {
            return;
        }
        File parent = new File(this.gitSettingsPath);
        if (!parent.mkdirs() && !parent.exists()) {
            throw new FileNotFoundException("Cannot create folder " + this.gitSettingsPath);
        }
        File settings = new File(parent, "branches.properties");
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(settings), StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.setProperty("projects.number", String.valueOf(this.branches.size()));
            int i = 1;
            for (Map.Entry<String, List<String>> entry : this.branches.entrySet()) {
                properties.setProperty("project." + i + ".name", entry.getKey());
                properties.setProperty("project." + i + ".branches", String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
                ++i;
            }
            properties.store(out, null);
        }
    }

    private void removeAbsentFiles(String baseAbsolutePath, File directory, Collection<File> toSave, List<String> changedFiles) throws GitAPIException {
        File[] found = directory.listFiles();
        if (found != null) {
            for (File file : found) {
                if (file.isDirectory()) {
                    this.removeAbsentFiles(baseAbsolutePath, file, toSave, changedFiles);
                    continue;
                }
                if (toSave.contains(file)) continue;
                String relativePath = file.getAbsolutePath().substring(baseAbsolutePath.length()).replace('\\', '/');
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                this.git.rm().addFilepattern(relativePath).call();
                changedFiles.add(relativePath);
            }
        }
    }

    private void createParent(File file) throws FileNotFoundException {
        File parentFile = file.getParentFile();
        if (!parentFile.mkdirs() && !parentFile.exists()) {
            throw new FileNotFoundException("Cannot create the folder " + parentFile.getAbsolutePath());
        }
    }

    private URI getUri(String uriOrPath) {
        if (uriOrPath == null) {
            return null;
        }
        try {
            return new URL(uriOrPath).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return new File(uriOrPath).toURI();
        }
    }

    private String escapeCurlyBrackets(String value) {
        String ret = value.replaceAll("\\{(?![012]})", "'{'");
        return ret.replaceAll("(?<!\\{[012])}", "'}'");
    }

    private String formatComment(CommitType commitType, FileData data) {
        String comment = StringUtils.trimToEmpty((String)data.getComment());
        return MessageFormat.format(this.escapedCommentTemplate, new Object[]{commitType, comment, data.getAuthor()});
    }

    private String getMergeMessage(String mergeAuthor, Ref r) throws IOException {
        String userMessage = new MergeMessageFormatter().format(Collections.singletonList(r), this.git.getRepository().exactRef("HEAD"));
        return MessageFormat.format(this.escapedCommentTemplate, new Object[]{CommitType.MERGE, userMessage, mergeAuthor});
    }

    boolean isCheckoutOldVersion(String path, String baseVersion) throws GitAPIException, IOException {
        if (baseVersion != null) {
            List tags = this.git.tagList().call();
            RevCommit commit = GitRepository.findFirstCommit(this.git, this.resolveBranchId(), path);
            if (commit != null) {
                String lastVersion = GitRepository.getVersionName(this.git.getRepository(), tags, (ObjectId)commit);
                return !baseVersion.equals(lastVersion);
            }
            throw new FileNotFoundException(String.format("Cannot find commit for path '%s' and version '%s'", path, baseVersion));
        }
        return false;
    }

    public boolean isValidBranchName(String s) {
        return s != null && Repository.isValidRefName((String)("refs/heads/" + s));
    }

    public boolean branchExists(String branch) throws IOException {
        for (String existedBranch : this.getBranches(null)) {
            if (!existedBranch.equalsIgnoreCase(branch)) continue;
            return true;
        }
        return false;
    }

    Git getClosableGit() throws IOException {
        if (this.closed) {
            return Git.open((File)new File(this.localRepositoryPath));
        }
        return new Git(this.git.getRepository());
    }

    private CredentialsProvider getCredentialsProvider() throws IOException {
        if (this.credentialsProvider != null && this.credentialsProvider.isHasAuthorizationFailure()) {
            throw new IOException("Incorrect login or password for git repository.");
        }
        return this.credentialsProvider;
    }

    private class ReadHistoryVisitor
    implements HistoryVisitor<FileItem> {
        private final String version;
        private final Repository repository;
        private FileItem result;

        private ReadHistoryVisitor(String version) {
            this.version = version;
            this.repository = GitRepository.this.git.getRepository();
        }

        @Override
        public boolean visit(String fullPath, RevCommit commit, String commitVersion) throws IOException {
            if (commitVersion.equals(this.version)) {
                RevTree tree = commit.getTree();
                try (TreeWalk rootWalk = GitRepository.buildTreeWalk(this.repository, fullPath, tree);){
                    FileData fileData = GitRepository.this.createFileData(rootWalk, commit);
                    ObjectLoader loader = this.repository.open((AnyObjectId)rootWalk.getObjectId(0));
                    this.result = new FileItem(fileData, (InputStream)loader.openStream());
                }
                catch (FileNotFoundException e) {
                    this.result = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public FileItem getResult() {
            return this.result;
        }
    }

    private class CheckHistoryVisitor
    implements HistoryVisitor<FileData> {
        private final String version;
        private final Repository repository;
        private FileData result;

        private CheckHistoryVisitor(String version) {
            this.version = version;
            this.repository = GitRepository.this.git.getRepository();
        }

        @Override
        public boolean visit(String fullPath, RevCommit commit, String commitVersion) throws IOException {
            if (commitVersion.equals(this.version)) {
                RevTree tree = commit.getTree();
                try (TreeWalk rootWalk = GitRepository.buildTreeWalk(this.repository, fullPath, tree);){
                    this.result = GitRepository.this.createFileData(rootWalk, commit);
                }
                catch (FileNotFoundException e) {
                    this.result = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public FileData getResult() {
            return this.result;
        }
    }

    private class ListFilesHistoryVisitor
    implements HistoryVisitor<List<FileData>> {
        private final String version;
        private final Repository repository;
        private final List<FileData> history = new ArrayList<FileData>();

        private ListFilesHistoryVisitor(String version) {
            this.version = version;
            this.repository = GitRepository.this.git.getRepository();
        }

        @Override
        public boolean visit(String fullPath, RevCommit commit, String commitVersion) throws IOException {
            if (commitVersion.equals(this.version)) {
                RevTree tree = commit.getTree();
                try (TreeWalk rootWalk = GitRepository.buildTreeWalk(this.repository, fullPath, tree);){
                    this.history.addAll((Collection<FileData>)new ListCommand(commit).apply(this.repository, rootWalk, fullPath));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public List<FileData> getResult() {
            Collections.reverse(this.history);
            return this.history;
        }
    }

    private class ListHistoryVisitor
    implements HistoryVisitor<List<FileData>> {
        private final Repository repository;
        private final List<FileData> history = new ArrayList<FileData>();

        private ListHistoryVisitor() {
            this.repository = GitRepository.this.git.getRepository();
        }

        @Override
        public boolean visit(String fullPath, RevCommit commit, String commitVersion) throws IOException {
            RevTree tree = commit.getTree();
            try (TreeWalk rootWalk = GitRepository.buildTreeWalk(this.repository, fullPath, tree);){
                this.history.add(GitRepository.this.createFileData(rootWalk, commit));
            }
            catch (FileNotFoundException e) {
                GitRepository.this.log.debug("File '{}' is absent in the commit {}", new Object[]{fullPath, commitVersion, e});
                LazyFileData data = new LazyFileData(GitRepository.this.branch, fullPath, GitRepository.this, commit, null, GitRepository.this.commitMessageParser);
                data.setDeleted(true);
                this.history.add(data);
            }
            return false;
        }

        @Override
        public List<FileData> getResult() {
            Collections.reverse(this.history);
            return this.history;
        }
    }

    private class ReadCommand
    implements WalkCommand<FileItem> {
        private ReadCommand() {
        }

        @Override
        public FileItem apply(Repository repository, TreeWalk rootWalk, String baseFolder) throws IOException {
            if (rootWalk != null && StringUtils.isNotEmpty((CharSequence)baseFolder)) {
                FileData fileData = GitRepository.this.createFileData(rootWalk, "", GitRepository.this.resolveBranchId());
                ObjectLoader loader = repository.open((AnyObjectId)rootWalk.getObjectId(0));
                return new FileItem(fileData, (InputStream)loader.openStream());
            }
            return null;
        }
    }

    private class CheckCommand
    implements WalkCommand<FileData> {
        private CheckCommand() {
        }

        @Override
        public FileData apply(Repository repository, TreeWalk rootWalk, String baseFolder) throws IOException {
            if (rootWalk != null && StringUtils.isNotEmpty((CharSequence)baseFolder)) {
                return GitRepository.this.createFileData(rootWalk, "", GitRepository.this.resolveBranchId());
            }
            return null;
        }
    }

    private class ListFoldersCommand
    implements WalkCommand<List<FileData>> {
        private ListFoldersCommand() {
        }

        @Override
        public List<FileData> apply(Repository repository, TreeWalk rootWalk, String baseFolder) throws IOException {
            if (rootWalk != null) {
                if (rootWalk.getFilter() == TreeFilter.ALL) {
                    return this.collectFolderData(rootWalk, baseFolder);
                }
                if (rootWalk.getTreeCount() > 0) {
                    try (TreeWalk dirWalk = new TreeWalk(repository);){
                        dirWalk.addTree((AnyObjectId)rootWalk.getObjectId(0));
                        List<FileData> list = this.collectFolderData(dirWalk, baseFolder);
                        return list;
                    }
                }
            }
            return Collections.emptyList();
        }

        private List<FileData> collectFolderData(TreeWalk rootWalk, String baseFolder) throws IOException {
            ArrayList<FileData> files = new ArrayList<FileData>();
            rootWalk.setRecursive(false);
            ObjectId start = GitRepository.this.resolveBranchId();
            while (rootWalk.next()) {
                if ((rootWalk.getFileMode().getBits() & 0x4000) == 0) continue;
                files.add(GitRepository.this.createFileData(rootWalk, baseFolder, start));
            }
            return files;
        }
    }

    private class ListCommand
    implements WalkCommand<List<FileData>> {
        private final ObjectId start;
        private final RevCommit revCommit;

        private ListCommand(ObjectId start) {
            this.start = start;
            this.revCommit = null;
        }

        private ListCommand(RevCommit revCommit) {
            this.start = revCommit.getId();
            this.revCommit = revCommit;
        }

        @Override
        public List<FileData> apply(Repository repository, TreeWalk rootWalk, String baseFolder) throws IOException {
            if (rootWalk != null) {
                ArrayList<FileData> files = new ArrayList<FileData>();
                if (rootWalk.getFilter() == TreeFilter.ALL) {
                    while (rootWalk.next()) {
                        files.add(GitRepository.this.createFileData(rootWalk, baseFolder, this.start));
                    }
                } else if (rootWalk.getTreeCount() > 0) {
                    try (TreeWalk dirWalk = new TreeWalk(repository);){
                        dirWalk.addTree((AnyObjectId)rootWalk.getObjectId(0));
                        dirWalk.setRecursive(true);
                        while (dirWalk.next()) {
                            if (this.revCommit != null) {
                                files.add(new LazyFileData(GitRepository.this.branch, baseFolder + dirWalk.getPathString(), GitRepository.this, this.revCommit, GitRepository.this.getFileId(dirWalk), GitRepository.this.commitMessageParser));
                                continue;
                            }
                            files.add(GitRepository.this.createFileData(dirWalk, baseFolder, this.start));
                        }
                    }
                }
                return files;
            }
            return Collections.emptyList();
        }
    }

    public static interface HistoryVisitor<T> {
        public boolean visit(String var1, RevCommit var2, String var3) throws IOException, GitAPIException;

        public T getResult();
    }

    public static interface WalkCommand<T> {
        public T apply(Repository var1, TreeWalk var2, String var3) throws IOException, GitAPIException;
    }

    private class GitRevisionGetter
    implements RevisionGetter {
        private GitRevisionGetter() {
        }

        public Object getRevision() {
            try {
                return GitRepository.this.getLastRevision();
            }
            catch (Exception e) {
                GitRepository.this.log.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }
}

