/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.git;

import java.io.IOException;
import java.util.Date;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.git.CommitMessageParser;
import org.openl.rules.repository.git.CommitType;
import org.openl.rules.repository.git.GitRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LazyFileData
extends FileData {
    private final Logger log = LoggerFactory.getLogger(GitRepository.class);
    private final String fullPath;
    private final GitRepository gitRepo;
    private ObjectId fromCommit;
    private RevCommit fileCommit;
    private ObjectId fileId;
    private final CommitMessageParser commitMessageParser;
    private boolean loaded = false;

    LazyFileData(String branch, String fullPath, GitRepository gitRepo, ObjectId fromCommit, ObjectId fileId, CommitMessageParser commitMessageParser) {
        this.setBranch(branch);
        this.setName(fullPath);
        if (fileId != null) {
            this.setUniqueId(fileId.getName());
        }
        this.fullPath = fullPath;
        this.gitRepo = gitRepo;
        this.commitMessageParser = commitMessageParser;
        this.fromCommit = fromCommit;
        this.fileId = fileId;
    }

    LazyFileData(String branch, String fullPath, GitRepository gitRepo, RevCommit fileCommit, ObjectId fileId, CommitMessageParser commitMessageParser) {
        this.setBranch(branch);
        this.setName(fullPath);
        if (fileId != null) {
            this.setUniqueId(fileId.getName());
        }
        this.fullPath = fullPath;
        this.gitRepo = gitRepo;
        this.commitMessageParser = commitMessageParser;
        this.fileCommit = fileCommit;
        this.fileId = fileId;
    }

    public long getSize() {
        if (this.fileId != null) {
            try (Git git = this.gitRepo.getClosableGit();){
                ObjectLoader loader = git.getRepository().open((AnyObjectId)this.fileId);
                super.setSize(loader.getSize());
                this.fileId = null;
            }
            catch (IOException e) {
                this.log.warn(e.getMessage(), (Throwable)e);
                throw new IllegalStateException("Cannot get file size: " + e.getMessage(), e);
            }
        }
        return super.getSize();
    }

    public void setSize(long size) {
        this.fileId = null;
        super.setSize(size);
    }

    public String getAuthor() {
        this.verifyLoaded();
        return super.getAuthor();
    }

    public void setAuthor(String author) {
        this.verifyLoaded();
        super.setAuthor(author);
    }

    public String getComment() {
        this.verifyLoaded();
        return super.getComment();
    }

    public void setComment(String comment) {
        this.verifyLoaded();
        super.setComment(comment);
    }

    public Date getModifiedAt() {
        this.verifyLoaded();
        return super.getModifiedAt();
    }

    public void setModifiedAt(Date modifiedAt) {
        this.verifyLoaded();
        super.setModifiedAt(modifiedAt);
    }

    public String getVersion() {
        this.verifyLoaded();
        return super.getVersion();
    }

    public void setVersion(String version) {
        this.verifyLoaded();
        super.setVersion(version);
    }

    public boolean isDeleted() {
        this.verifyLoaded();
        return super.isDeleted();
    }

    public void setDeleted(boolean deleted) {
        this.verifyLoaded();
        super.setDeleted(deleted);
    }

    private void verifyLoaded() {
        if (this.loaded) {
            return;
        }
        try (Git git = this.gitRepo.getClosableGit();){
            String version;
            if (this.fileCommit == null) {
                try {
                    this.fileCommit = GitRepository.findFirstCommit(git, this.fromCommit, this.fullPath);
                }
                catch (GitAPIException | IncorrectObjectTypeException | MissingObjectException e) {
                    this.log.error(e.getMessage(), e);
                }
                if (this.fileCommit == null) {
                    throw new IllegalStateException("Cannot find revision for the file " + this.fullPath);
                }
                this.fromCommit = null;
            }
            PersonIdent committerIdent = this.fileCommit.getCommitterIdent();
            super.setAuthor(committerIdent.getName());
            super.setModifiedAt(committerIdent.getWhen());
            String message = this.fileCommit.getFullMessage();
            CommitMessageParser.CommitMessage commitMessage = this.commitMessageParser.parse(message);
            if (commitMessage != null) {
                CommitType commitType = commitMessage.getCommitType();
                if (commitType == CommitType.ARCHIVE || commitType == CommitType.ERASE) {
                    super.setDeleted(true);
                }
                if (commitMessage.getMessage() != null) {
                    message = commitMessage.getMessage();
                }
                if (commitMessage.getAuthor() != null) {
                    super.setAuthor(commitMessage.getAuthor());
                }
            }
            super.setComment(message);
            try {
                version = GitRepository.getVersionName(git.getRepository(), git.tagList().call(), this.fileCommit.getId());
            }
            catch (GitAPIException e) {
                throw new IllegalStateException("Cannot get tags list: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get version name: " + e.getMessage(), e);
            }
            super.setVersion(version);
            this.loaded = true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }
}

