/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.common;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.InputStream;
import java.util.List;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.impl.CommonVersionImpl;
import org.openl.rules.common.impl.ProjectDependencyImpl;

public interface ProjectDependency {
    public CommonVersion getLowerLimit();

    public String getProjectName();

    public CommonVersion getUpperLimit();

    public boolean hasUpperLimit();

    public static class ProjectDependencyHelper {
        private static final XStream XSTREAM = new XStream((HierarchicalStreamDriver)new DomDriver());

        public static String serialize(List<ProjectDependency> dependencies) {
            return XSTREAM.toXML(dependencies);
        }

        public static List<ProjectDependency> deserialize(InputStream source) {
            return (List)XSTREAM.fromXML(source);
        }

        static {
            XSTREAM.alias("dependencies", List.class);
            XSTREAM.aliasType("dependency", ProjectDependency.class);
            XSTREAM.aliasType("version", CommonVersion.class);
            XSTREAM.registerConverter((SingleValueConverter)new CommonVersion.CommonVersionConverter());
            XSTREAM.registerConverter((Converter)new ProjectDependencyConverter());
        }
    }

    public static class ProjectDependencyConverter
    implements Converter {
        public boolean canConvert(Class cls) {
            return ProjectDependency.class.isAssignableFrom(cls);
        }

        public void marshal(Object arg0, HierarchicalStreamWriter arg1, MarshallingContext arg2) {
            ProjectDependency dep = (ProjectDependency)arg0;
            arg1.startNode("projectName");
            arg1.setValue(dep.getProjectName());
            arg1.endNode();
            arg1.startNode("lowerLimit");
            arg2.convertAnother((Object)dep.getLowerLimit());
            arg1.endNode();
            if (dep.hasUpperLimit()) {
                arg1.startNode("upperLimit");
                arg2.convertAnother((Object)dep.getUpperLimit());
                arg1.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader arg0, UnmarshallingContext arg1) {
            arg0.moveDown();
            String projectName = arg0.getValue();
            arg0.moveUp();
            arg0.moveDown();
            CommonVersionImpl lowerLimit = (CommonVersionImpl)arg1.convertAnother(null, CommonVersion.class);
            arg0.moveUp();
            if (arg0.hasMoreChildren()) {
                arg0.moveDown();
                CommonVersionImpl upperLimit = (CommonVersionImpl)arg1.convertAnother(null, CommonVersion.class);
                arg0.moveUp();
                return new ProjectDependencyImpl(projectName, lowerLimit, upperLimit);
            }
            return new ProjectDependencyImpl(projectName, lowerLimit);
        }
    }
}

