/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.common.impl;

import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.ProjectDependency;

public class ProjectDependencyImpl
implements ProjectDependency {
    private static final long serialVersionUID = -1745471023092596849L;
    private String projectName;
    private CommonVersion lowerLimit;
    private CommonVersion upperLimit;

    public ProjectDependencyImpl(String projectName, CommonVersion lowerLimit) {
        this(projectName, lowerLimit, null);
    }

    public ProjectDependencyImpl(String projectName, CommonVersion lowerLimit, CommonVersion upperLimit) {
        if (projectName == null) {
            throw new NullPointerException("projectName is null");
        }
        if (lowerLimit == null) {
            throw new NullPointerException("lowerLimit is null");
        }
        if (upperLimit != null && lowerLimit.compareTo(upperLimit) > 0) {
            throw new IllegalArgumentException("upperLimit is less than lowerLimit");
        }
        this.projectName = projectName;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectDependencyImpl)) {
            return false;
        }
        ProjectDependencyImpl that = (ProjectDependencyImpl)o;
        return this.projectName.equals(that.projectName) && this.lowerLimit.compareTo(that.lowerLimit) == 0 && (this.upperLimit == null ? that.upperLimit == null : this.upperLimit.compareTo(that.upperLimit) == 0);
    }

    @Override
    public CommonVersion getLowerLimit() {
        return this.lowerLimit;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public CommonVersion getUpperLimit() {
        return this.upperLimit;
    }

    public int hashCode() {
        int result = this.projectName.hashCode();
        result = 31 * result + this.lowerLimit.hashCode();
        result = 31 * result + (this.upperLimit != null ? this.upperLimit.hashCode() : 0);
        return result;
    }

    @Override
    public boolean hasUpperLimit() {
        return this.upperLimit != null;
    }
}

