/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.config.ConfigProperty;
import org.openl.config.ConfigPropertyString;
import org.openl.config.ConfigSet;
import org.openl.config.SysConfigManager;
import org.openl.rules.repository.RRepository;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.exceptions.RRepositoryException;

public class RulesRepositoryFactory {
    public static final String DEFAULT_PROP_FILE = "system.properties";
    public static final String MSG_FAILED = "Failed to initialize RulesRepositoryFactory!";
    private static final ConfigPropertyString confRepositoryFactoryClass = new ConfigPropertyString("design-repository.factory", null);
    private static RRepositoryFactory repFactory;
    private static boolean isFailed;
    private static ConfigSet config;

    public static synchronized RRepository getRepositoryInstance() throws RRepositoryException {
        if (repFactory == null) {
            RulesRepositoryFactory.initFactory();
        }
        return repFactory.getRepositoryInstance();
    }

    public static RRepositoryFactory getRepFactory() {
        return repFactory;
    }

    private static void initFactory() throws RRepositoryException {
        Log log = LogFactory.getLog(RulesRepositoryFactory.class);
        if (config == null) {
            config = SysConfigManager.getConfigManager().locate(DEFAULT_PROP_FILE);
        }
        if (config == null) {
            throw new RRepositoryException(MSG_FAILED, new NullPointerException());
        }
        config.updateProperty((ConfigProperty)confRepositoryFactoryClass);
        String className = (String)confRepositoryFactoryClass.getValue();
        try {
            Class<?> c = Class.forName(className);
            Object obj = c.newInstance();
            repFactory = (RRepositoryFactory)obj;
            repFactory.initialize(config);
        }
        catch (Exception e) {
            isFailed = true;
            log.error((Object)MSG_FAILED, (Throwable)e);
            throw new RRepositoryException(MSG_FAILED, e);
        }
        isFailed = false;
    }

    public static boolean isFailed() {
        if (!isFailed && repFactory == null) {
            try {
                RulesRepositoryFactory.initFactory();
            }
            catch (RRepositoryException rRepositoryException) {
                // empty catch block
            }
        }
        return isFailed;
    }

    public static synchronized void release() throws RRepositoryException {
        if (repFactory != null) {
            repFactory.release();
            repFactory = null;
        }
    }

    public static ConfigSet getConfig() {
        return config;
    }

    public static void setConfig(ConfigSet config) {
        RulesRepositoryFactory.config = config;
    }
}

