/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.common.impl;

import org.openl.rules.common.CommonVersion;

public class CommonVersionImpl
implements CommonVersion {
    private int major = Short.MAX_VALUE;
    private int minor = Short.MAX_VALUE;
    private int revision;
    private transient String versionName;

    public CommonVersionImpl(CommonVersion version) {
        this.major = version.getMajor();
        this.minor = version.getMinor();
        this.revision = version.getRevision();
    }

    public CommonVersionImpl(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public CommonVersionImpl(int revision) {
        this.revision = revision;
    }

    public CommonVersionImpl(String s) {
        String[] version = s.split("\\.");
        if (version.length == 1) {
            this.revision = Integer.parseInt(version[0], 10);
        } else {
            if (version.length > 0) {
                this.major = Integer.parseInt(version[0], 10);
            }
            if (version.length > 1) {
                this.minor = Integer.parseInt(version[1], 10);
            }
            if (version.length > 2) {
                this.revision = Integer.parseInt(version[2], 10);
            }
        }
    }

    @Override
    public int compareTo(CommonVersion o) {
        if (this.revision == o.getRevision()) {
            return 0;
        }
        if (this.revision == 0) {
            return -1;
        }
        if (this.major != o.getMajor()) {
            return this.major < o.getMajor() ? -1 : 1;
        }
        if (this.minor != o.getMinor()) {
            return this.minor < o.getMinor() ? -1 : 1;
        }
        if (this.revision != o.getRevision()) {
            return this.revision < o.getRevision() ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommonVersion)) {
            return false;
        }
        return this.compareTo((CommonVersion)o) == 0;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public String getVersionName() {
        if (this.versionName == null) {
            this.versionName = this.major != Short.MAX_VALUE && this.minor != Short.MAX_VALUE && this.major != -1 && this.minor != -1 ? this.major + "." + this.minor + "." + this.revision : "" + this.revision;
        }
        return this.versionName;
    }

    public int hashCode() {
        return this.major << 22 ^ this.minor << 11 ^ this.revision;
    }

    public String toString() {
        return "versionName = " + this.getVersionName();
    }
}

