/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.config.ConfigProperty;
import org.openl.config.ConfigPropertyString;
import org.openl.config.ConfigSet;
import org.openl.config.ConfigurationManager;
import org.openl.config.ConfigurationManagerFactory;
import org.openl.rules.repository.RProductionRepository;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.RulesRepositoryFactory;
import org.openl.rules.repository.RulesRepositoryFactoryAware;
import org.openl.rules.repository.exceptions.RRepositoryException;

public class ProductionRepositoryFactoryProxy
implements RulesRepositoryFactoryAware {
    private final Log log = LogFactory.getLog(ProductionRepositoryFactoryProxy.class);
    public static final String DEFAULT_REPOSITORY_PROPERTIES_FILE = "rules-production.properties";
    public static final ConfigurationManagerFactory DEFAULT_CONFIGURATION_MANAGER_FACTORY = new ConfigurationManagerFactory(false, null, "");
    private ConfigurationManagerFactory configManagerFactory = DEFAULT_CONFIGURATION_MANAGER_FACTORY;
    private final ConfigPropertyString confRepositoryFactoryClass = new ConfigPropertyString("production-repository.factory", null);
    private Map<String, RRepositoryFactory> factories = new HashMap<String, RRepositoryFactory>();
    private RulesRepositoryFactory rulesRepositoryFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RProductionRepository getRepositoryInstance(String propertiesFileName) throws RRepositoryException {
        if (!this.factories.containsKey(propertiesFileName)) {
            ProductionRepositoryFactoryProxy productionRepositoryFactoryProxy = this;
            synchronized (productionRepositoryFactoryProxy) {
                if (!this.factories.containsKey(propertiesFileName)) {
                    this.factories.put(propertiesFileName, this.createFactory(propertiesFileName));
                }
            }
        }
        return (RProductionRepository)this.factories.get(propertiesFileName).getRepositoryInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRepository(String propertiesFileName) throws RRepositoryException {
        ProductionRepositoryFactoryProxy productionRepositoryFactoryProxy = this;
        synchronized (productionRepositoryFactoryProxy) {
            RRepositoryFactory factory = this.factories.get(propertiesFileName);
            if (factory != null) {
                factory.release();
                this.factories.remove(propertiesFileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws RRepositoryException {
        ProductionRepositoryFactoryProxy productionRepositoryFactoryProxy = this;
        synchronized (productionRepositoryFactoryProxy) {
            for (RRepositoryFactory repFactory : this.factories.values()) {
                repFactory.release();
            }
            this.factories.clear();
        }
    }

    public void setConfigManagerFactory(ConfigurationManagerFactory configManagerFactory) {
        this.configManagerFactory = configManagerFactory;
    }

    @Override
    public void setRulesRepositoryFactory(RulesRepositoryFactory rulesRepositoryFactory) {
        this.rulesRepositoryFactory = rulesRepositoryFactory;
    }

    private RRepositoryFactory initRepositoryFactory(ConfigSet config) throws RRepositoryException {
        String className = (String)this.confRepositoryFactoryClass.getValue();
        try {
            Class<?> c = Class.forName(className);
            Object obj = c.newInstance();
            RRepositoryFactory repFactory = (RRepositoryFactory)obj;
            repFactory.initialize(config);
            if (this.rulesRepositoryFactory != null && repFactory instanceof RulesRepositoryFactoryAware) {
                ((RulesRepositoryFactoryAware)((Object)repFactory)).setRulesRepositoryFactory(this.rulesRepositoryFactory);
            }
            return repFactory;
        }
        catch (Exception e) {
            String msg = "Failed to initialize ProductionRepositoryFactory!";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)msg, (Throwable)e);
            }
            throw new RRepositoryException(msg, e);
        }
    }

    private RRepositoryFactory createFactory(String propertiesFileName) throws RRepositoryException {
        ConfigSet config = new ConfigSet();
        ConfigurationManager configurationManager = this.configManagerFactory.getConfigurationManager(propertiesFileName);
        config.addProperties(configurationManager.getProperties());
        config.updateProperty((ConfigProperty)this.confRepositoryFactoryClass);
        return this.initRepositoryFactory(config);
    }

    public RRepositoryFactory getFactory(Map<String, Object> props) throws RRepositoryException {
        ConfigSet config = new ConfigSet();
        config.addProperties(props);
        config.updateProperty((ConfigProperty)this.confRepositoryFactoryClass);
        return this.initRepositoryFactory(config);
    }
}

