/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.config.ConfigProperty;
import org.openl.config.ConfigPropertyString;
import org.openl.config.ConfigSet;
import org.openl.config.SysConfigManager;
import org.openl.rules.repository.RRepository;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.RulesRepositoryFactoryAware;
import org.openl.rules.repository.exceptions.RRepositoryException;

public class RulesRepositoryFactory {
    private final Log log = LogFactory.getLog(RulesRepositoryFactory.class);
    public static final String DEFAULT_PROP_FILE = "system.properties";
    public static final String MSG_FAILED = "Failed to initialize RulesRepositoryFactory!";
    private static final ConfigPropertyString confRepositoryFactoryClass = new ConfigPropertyString("design-repository.factory", null);
    private RRepositoryFactory repFactory;
    private boolean isFailed;
    private ConfigSet config;
    private static RulesRepositoryFactory instance = null;

    public synchronized RRepository getRulesRepositoryInstance() throws RRepositoryException {
        if (this.repFactory == null) {
            this.initRepositoryFactory();
        }
        return this.repFactory.getRepositoryInstance();
    }

    public RRepositoryFactory getRepositoryFactory() {
        return this.repFactory;
    }

    private void initRepositoryFactory() throws RRepositoryException {
        if (this.config == null) {
            this.config = SysConfigManager.getConfigManager().locate(DEFAULT_PROP_FILE);
        }
        if (this.config == null) {
            throw new RRepositoryException(MSG_FAILED, new NullPointerException());
        }
        this.config.updateProperty((ConfigProperty)confRepositoryFactoryClass);
        String className = (String)confRepositoryFactoryClass.getValue();
        try {
            Class<?> c = Class.forName(className);
            Object obj = c.newInstance();
            this.repFactory = (RRepositoryFactory)obj;
            this.repFactory.initialize(this.config);
            if (this.repFactory instanceof RulesRepositoryFactoryAware) {
                ((RulesRepositoryFactoryAware)((Object)this.repFactory)).setRulesRepositoryFactory(this);
            }
        }
        catch (Exception e) {
            this.isFailed = true;
            this.log.error((Object)MSG_FAILED, (Throwable)e);
            throw new RRepositoryException(MSG_FAILED, e);
        }
        this.isFailed = false;
    }

    public boolean isBroken() {
        if (!this.isFailed && this.repFactory == null) {
            try {
                this.initRepositoryFactory();
            }
            catch (RRepositoryException rRepositoryException) {
                // empty catch block
            }
        }
        return this.isFailed;
    }

    public synchronized void destroy() throws RRepositoryException {
        if (this.repFactory != null) {
            this.repFactory.release();
            this.repFactory = null;
        }
    }

    public void setConfigSet(ConfigSet config) {
        this.config = config;
    }

    public void setConfig(Map<String, Object> config) {
        ConfigSet rulesConfig = new ConfigSet();
        rulesConfig.addProperties(config);
        this.setConfigSet(rulesConfig);
    }

    @Deprecated
    public static synchronized RRepository getRepositoryInstance() throws RRepositoryException {
        return RulesRepositoryFactory.getInstance().getRulesRepositoryInstance();
    }

    @Deprecated
    public static RRepositoryFactory getRepFactory() {
        return RulesRepositoryFactory.getInstance().getRepositoryFactory();
    }

    @Deprecated
    public static boolean isFailed() {
        return RulesRepositoryFactory.getInstance().isBroken();
    }

    @Deprecated
    public static synchronized void release() throws RRepositoryException {
        RulesRepositoryFactory.getInstance().destroy();
    }

    @Deprecated
    public static ConfigSet getConfig() {
        return RulesRepositoryFactory.getInstance().config;
    }

    private static RulesRepositoryFactory getInstance() {
        if (instance == null) {
            instance = new RulesRepositoryFactory();
        }
        return instance;
    }
}

