/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.common;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.InputStream;
import java.util.List;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.CommonVersionConverter;
import org.openl.rules.common.ProjectDescriptor;
import org.openl.rules.common.ProjectDescriptorConverter;
import org.openl.rules.common.impl.ProjectDescriptorImpl;
import org.openl.util.IOUtils;

public class ProjectDescriptorHelper {
    private static final XStream XSTREAM = new XStream((HierarchicalStreamDriver)new DomDriver());

    public static InputStream serialize(List<ProjectDescriptor> descriptors) {
        String xml = XSTREAM.toXML(descriptors);
        return IOUtils.toInputStream((CharSequence)xml);
    }

    public static List<ProjectDescriptor> deserialize(InputStream source) {
        return (List)XSTREAM.fromXML(source);
    }

    static {
        XSTREAM.alias("descriptors", List.class);
        XSTREAM.alias("descriptor", ProjectDescriptor.class, ProjectDescriptorImpl.class);
        XSTREAM.aliasType("version", CommonVersion.class);
        XSTREAM.registerConverter((SingleValueConverter)new CommonVersionConverter());
        XSTREAM.registerConverter((Converter)new ProjectDescriptorConverter());
    }
}

