/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository;

import java.lang.reflect.Method;
import java.util.Map;
import org.openl.rules.repository.api.Repository;
import org.openl.util.StringUtils;

public class RepositoryInstatiator {
    public static Repository newRepository(String factory, Map<String, String> params) {
        Repository repository = RepositoryInstatiator.newInstance(factory);
        if (params != null) {
            RepositoryInstatiator.setParams(repository, params);
        }
        RepositoryInstatiator.initialize(repository);
        return repository;
    }

    private static Repository newInstance(String factory) {
        Object instance;
        try {
            Class<?> clazz = Class.forName(factory);
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate a repository: " + factory, e);
        }
        catch (UnsupportedClassVersionError e) {
            throw new IllegalStateException("Library was compiled using newer version of JDK", e);
        }
        try {
            return (Repository)instance;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(instance.getClass() + " must implement " + Repository.class, e);
        }
    }

    private static void setParams(Object instance, Map<String, String> params) {
        Class<?> clazz = instance.getClass();
        for (Map.Entry<String, String> param : params.entrySet()) {
            String value = param.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            String name = param.getKey();
            String setter = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            try {
                Method setMethod = clazz.getMethod(setter, String.class);
                setMethod.invoke(instance, value);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke " + setter + "(String) method in: " + clazz, e);
            }
        }
    }

    private static void initialize(Object instance) {
        Method initMethod;
        Class<?> clazz = instance.getClass();
        try {
            initMethod = clazz.getMethod("initialize", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            initMethod = null;
        }
        try {
            initMethod.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to call initialize() in: " + clazz, e);
        }
    }
}

