/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.db;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.openl.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Settings {
    private final Logger log = LoggerFactory.getLogger(Settings.class);
    int timerPeriod;
    String tableName;
    Collection<String> initStatements;
    String selectAllMetainfo;
    String selectAllHistoryMetainfo;
    String insertFile;
    String readActualFile;
    String readActualFileMetainfo;
    String readHistoricFile;
    String readHistoricFileMetainfo;
    String deleteAllHistory;
    String deleteVersion;
    String selectLastChange;
    String copyFile;
    String copyHistory;

    Settings(String databaseCode) throws IOException {
        TreeMap<String, String> queries = new TreeMap<String, String>();
        this.fillQueries(queries, "/openl-db-repository.properties");
        this.fillQueries(queries, "/openl-db-repository-" + databaseCode + ".properties");
        this.fillQueries(queries, "/openl-db-repository-ext.properties");
        this.resolve(queries);
        this.timerPeriod = this.getIntValue(queries, "setting.timerPeriod", 10000);
        this.tableName = this.getRequired(queries, "setting.tablename");
        this.insertFile = this.getRequired(queries, "query.insert-new-file");
        this.copyFile = this.getRequired(queries, "query.copy-last-file");
        this.copyHistory = this.getRequired(queries, "query.copy-exact-file");
        this.deleteVersion = this.getRequired(queries, "query.delete-exact-file");
        this.deleteAllHistory = this.getRequired(queries, "query.delete-all-history");
        this.readActualFile = this.getRequired(queries, "query.read-last-file");
        this.readHistoricFile = this.getRequired(queries, "query.read-exact-file");
        this.readActualFileMetainfo = this.getRequired(queries, "query.read-last-metainfo");
        this.readHistoricFileMetainfo = this.getRequired(queries, "query.read-exact-metainfo");
        this.selectAllMetainfo = this.getRequired(queries, "query.list-last-metainfo");
        this.selectAllHistoryMetainfo = this.getRequired(queries, "query.list-all-metainfo");
        this.selectLastChange = this.getRequired(queries, "query.select-last-change");
        this.initStatements = queries.subMap("init.", "init.\uffff").values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillQueries(Map<String, String> queries, String propertiesFileName) throws IOException {
        URL resource = this.getClass().getResource(propertiesFileName);
        if (resource == null) {
            this.log.info("File '{}' is not found.", (Object)propertiesFileName);
            return;
        }
        this.log.info("Load configuration from '{}'.", (Object)resource);
        InputStream is = resource.openStream();
        try {
            Properties properties = new Properties();
            properties.load(is);
            for (String key : properties.stringPropertyNames()) {
                queries.put(key, properties.getProperty(key));
            }
            is.close();
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
    }

    private int getIntValue(Map<String, String> queries, String prop, int defValue) {
        String stringValue = queries.get(prop);
        int value = defValue;
        if (stringValue != null) {
            try {
                value = Integer.parseInt(stringValue);
            }
            catch (Exception e) {
                this.log.warn("Cannot parse value from {} = {}! Default value is used.", new Object[]{prop, stringValue, e});
            }
        }
        return value;
    }

    private String getRequired(Map<String, String> queries, String prop) {
        String value = queries.get(prop);
        if (value == null) {
            throw new IllegalArgumentException("Cannot get value for " + prop + " property.");
        }
        return value;
    }

    private void resolve(TreeMap<String, String> queries) {
        Set<String> keys = queries.keySet();
        for (String key : keys) {
            String value = queries.get(key);
            if (value == null) continue;
            value = new StrSubstitutor(queries).replace(value);
            queries.put(key, value);
        }
    }
}

