/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.file;

import java.io.File;
import java.util.ArrayList;
import java.util.TimerTask;
import org.openl.rules.repository.api.Listener;
import org.openl.rules.repository.file.FileTimeStamp;

public final class FileChangesMonitor
extends TimerTask {
    private final File baseDir;
    private final Listener listener;
    private ArrayList<FileTimeStamp> timestamps;

    FileChangesMonitor(File baseDir, Listener listener) {
        this.baseDir = baseDir;
        this.listener = listener;
        ArrayList<FileTimeStamp> timestamps = new ArrayList<FileTimeStamp>();
        this.collect(baseDir, timestamps);
        this.timestamps = timestamps;
    }

    private void collect(File file, ArrayList<FileTimeStamp> result) {
        if (file.isDirectory()) {
            File[] filesArray = file.listFiles();
            if (filesArray != null) {
                for (File f : filesArray) {
                    this.collect(f, result);
                }
            }
        } else {
            result.add(new FileTimeStamp(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        int quantity = this.timestamps.size();
        ArrayList<FileTimeStamp> newTimestamps = new ArrayList<FileTimeStamp>(quantity + 10);
        this.collect(this.baseDir, newTimestamps);
        boolean changed = false;
        if (newTimestamps.size() != quantity) {
            changed = true;
        } else {
            for (FileTimeStamp entry : this.timestamps) {
                if (!entry.isModified()) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.timestamps = newTimestamps;
            Listener listener = this.listener;
            synchronized (listener) {
                this.listener.onChange();
            }
        }
    }
}

