/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.common.impl;

import java.util.Date;
import org.openl.rules.common.Property;
import org.openl.rules.common.PropertyException;
import org.openl.rules.common.ValueType;

public class PropertyImpl
implements Property {
    private static final long serialVersionUID = 3446381998422819894L;
    private String name;
    private ValueType type;
    private Object value;

    public PropertyImpl(String name, Date value) {
        this(name, ValueType.DATE, value);
    }

    public PropertyImpl(String name, String value) {
        this(name, ValueType.STRING, value);
    }

    public PropertyImpl(String name, ValueType type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    protected void checkType(ValueType type) throws PropertyException {
        if (this.type != type) {
            throw new PropertyException("Property has {0} type", null, new Object[]{this.type});
        }
    }

    @Override
    public Date getDate() throws PropertyException {
        this.checkType(ValueType.DATE);
        return (Date)this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getString() {
        return this.value.toString();
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Date value) throws PropertyException {
        this.checkType(ValueType.DATE);
        this.value = value;
    }

    @Override
    public void setValue(String value) throws PropertyException {
        this.checkType(ValueType.STRING);
        this.value = value;
    }
}

