/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.common.impl;

import java.util.Map;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.ProjectVersion;
import org.openl.rules.common.VersionInfo;

public class RepositoryProjectVersionImpl
implements ProjectVersion {
    private static final long serialVersionUID = -5156747482692477220L;
    public static final String DELIMETER = ".";
    private int major = Short.MAX_VALUE;
    private int minor = Short.MAX_VALUE;
    private String revision;
    private transient String versionName;
    private VersionInfo versionInfo;
    private Map<String, Object> versionProperties;
    private String versionComment;

    @Override
    public String getVersionComment() {
        return this.versionComment;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = versionComment;
    }

    public RepositoryProjectVersionImpl(CommonVersion version, VersionInfo versionInfo) {
        this.major = version.getMajor();
        this.minor = version.getMinor();
        this.revision = version.getRevision();
        this.versionInfo = versionInfo;
    }

    public RepositoryProjectVersionImpl(CommonVersion version, VersionInfo versionInfo, String versionComment, Map<String, Object> versionProperties) {
        this.revision = version.getRevision();
        this.major = version.getMajor();
        this.minor = version.getMinor();
        this.versionInfo = versionInfo;
        this.versionComment = versionComment;
        this.versionProperties = versionProperties;
    }

    public RepositoryProjectVersionImpl(String revision, VersionInfo versionInfo) {
        this.revision = revision;
        this.versionInfo = versionInfo;
    }

    @Override
    public int compareTo(CommonVersion o) {
        if (this.revision.equals(o.getRevision())) {
            return 0;
        }
        if (this.revision.equals("0")) {
            return -1;
        }
        if (this.major != o.getMajor()) {
            return this.major < o.getMajor() ? -1 : 1;
        }
        if (this.minor != o.getMinor()) {
            return this.minor < o.getMinor() ? -1 : 1;
        }
        if (!this.revision.equals(o.getRevision())) {
            return this.revision.compareTo(o.getRevision());
        }
        return 0;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ProjectVersion && this.compareTo((ProjectVersion)o) == 0;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @Override
    public String getVersionName() {
        if (this.versionName == null) {
            this.versionName = this.major != Short.MAX_VALUE && this.minor != Short.MAX_VALUE && this.major != -1 && this.minor != -1 ? this.major + DELIMETER + this.minor + DELIMETER + this.revision : this.revision;
        }
        return this.versionName;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.revision.hashCode();
        return result;
    }

    @Override
    public Map<String, Object> getVersionProperties() {
        return this.versionProperties;
    }

    public void setVersionProperties(Map<String, Object> versionProperties) {
        this.versionProperties = versionProperties;
    }
}

