/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.FileItem;
import org.openl.rules.repository.api.Listener;
import org.openl.rules.repository.api.Repository;
import org.openl.rules.repository.common.ChangesMonitor;
import org.openl.rules.repository.common.RevisionGetter;
import org.openl.rules.repository.db.Settings;
import org.openl.util.IOUtils;
import org.openl.util.StringUtils;
import org.openl.util.db.JDBCDriverRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBRepository
implements Repository,
Closeable,
RRepositoryFactory {
    private final Logger log = LoggerFactory.getLogger(DBRepository.class);
    private Settings settings;
    private ChangesMonitor monitor;

    @Override
    public List<FileData> list(String path) throws IOException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.selectAllMetainfo);
            statement.setString(1, this.makePathPattern(path));
            rs = statement.executeQuery();
            ArrayList<FileData> fileDatas = new ArrayList<FileData>();
            while (rs.next()) {
                FileData fileData = this.createFileData(rs);
                fileDatas.add(fileData);
            }
            rs.close();
            statement.close();
            ArrayList<FileData> arrayList = fileDatas;
            this.safeClose(rs);
            this.safeClose(statement);
            this.safeClose(connection);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    @Override
    public FileData check(String name) throws IOException {
        return this.getLatestVersionFileData(name);
    }

    @Override
    public FileItem read(String name) throws IOException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.readActualFile);
            statement.setString(1, name);
            rs = statement.executeQuery();
            FileItem fileItem = null;
            if (rs.next()) {
                fileItem = this.createFileItem(rs);
            }
            rs.close();
            statement.close();
            FileItem fileItem2 = fileItem;
            this.safeClose(rs);
            this.safeClose(statement);
            this.safeClose(connection);
            return fileItem2;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    @Override
    public FileData save(FileData data, InputStream stream) throws IOException {
        return this.insertFile(data, stream);
    }

    @Override
    public boolean delete(FileData path) {
        FileData data;
        try {
            data = this.getLatestVersionFileData(path.getName());
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        if (data != null) {
            try {
                this.insertFile(data, null);
                this.invokeListener();
                return true;
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public FileData copy(String srcName, FileData destData) throws IOException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.copyFile);
            statement.setString(1, destData.getName());
            statement.setString(2, destData.getAuthor());
            statement.setString(3, destData.getComment());
            statement.setString(4, srcName);
            statement.executeUpdate();
            this.invokeListener();
            FileData fileData = destData;
            this.safeClose(statement);
            this.safeClose(connection);
            return fileData;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    @Override
    public FileData rename(String path, FileData destData) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setListener(Listener callback) {
        this.monitor.setListener(callback);
    }

    @Override
    public List<FileData> listHistory(String name) throws IOException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.selectAllHistoryMetainfo);
            statement.setString(1, name);
            rs = statement.executeQuery();
            ArrayList<FileData> fileDatas = new ArrayList<FileData>();
            while (rs.next()) {
                FileData fileData = this.createFileData(rs);
                fileDatas.add(fileData);
            }
            rs.close();
            statement.close();
            ArrayList<FileData> arrayList = fileDatas;
            this.safeClose(rs);
            this.safeClose(statement);
            this.safeClose(connection);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    @Override
    public FileData checkHistory(String name, String version) throws IOException {
        return version == null ? this.check(name) : this.getHistoryVersionFileData(name, version);
    }

    @Override
    public FileItem readHistory(String name, String version) throws IOException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.readHistoricFile);
            statement.setLong(1, Long.valueOf(version));
            statement.setString(2, name);
            rs = statement.executeQuery();
            FileItem fileItem = null;
            if (rs.next()) {
                fileItem = this.createFileItem(rs);
            }
            rs.close();
            statement.close();
            FileItem fileItem2 = fileItem;
            this.safeClose(rs);
            this.safeClose(statement);
            this.safeClose(connection);
            return fileItem2;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteHistory(String name, String version) {
        PreparedStatement statement;
        Connection connection;
        block12: {
            if (version == null) {
                PreparedStatement statement2;
                Connection connection2;
                block11: {
                    connection2 = null;
                    statement2 = null;
                    connection2 = this.getConnection();
                    statement2 = connection2.prepareStatement(this.settings.deleteAllHistory);
                    statement2.setString(1, name);
                    int rows = statement2.executeUpdate();
                    if (rows <= 0) break block11;
                    this.invokeListener();
                    boolean bl = true;
                    this.safeClose(statement2);
                    this.safeClose(connection2);
                    return bl;
                }
                try {
                    boolean bl = false;
                    this.safeClose(statement2);
                    this.safeClose(connection2);
                    return bl;
                }
                catch (SQLException e) {
                    try {
                        this.log.error(e.getMessage(), (Throwable)e);
                        boolean bl = false;
                        this.safeClose(statement2);
                        this.safeClose(connection2);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        this.safeClose(statement2);
                        this.safeClose(connection2);
                        throw throwable;
                    }
                }
            }
            connection = null;
            statement = null;
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.deleteVersion);
            statement.setLong(1, Long.valueOf(version));
            statement.setString(2, name);
            int rows = statement.executeUpdate();
            if (rows <= 0) break block12;
            this.invokeListener();
            boolean bl = true;
            this.safeClose(statement);
            this.safeClose(connection);
            return bl;
        }
        try {
            boolean bl = false;
            this.safeClose(statement);
            this.safeClose(connection);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.log.error(e.getMessage(), (Throwable)e);
                boolean bl = false;
                this.safeClose(statement);
                this.safeClose(connection);
                return bl;
            }
            catch (Throwable throwable) {
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    @Override
    public FileData copyHistory(String srcName, FileData destData, String version) throws IOException {
        if (version == null) {
            return this.copy(srcName, destData);
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.copyHistory);
            statement.setString(1, destData.getName());
            statement.setString(2, destData.getAuthor());
            statement.setString(3, destData.getComment());
            statement.setLong(4, Long.valueOf(version));
            statement.setString(5, srcName);
            statement.executeUpdate();
            this.invokeListener();
            FileData fileData = destData;
            this.safeClose(statement);
            this.safeClose(connection);
            return fileData;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    protected abstract Connection getConnection() throws SQLException;

    private FileData getLatestVersionFileData(String name) throws IOException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.readActualFileMetainfo);
            statement.setString(1, name);
            rs = statement.executeQuery();
            FileData fileData = null;
            if (rs.next()) {
                fileData = this.createFileData(rs);
            }
            rs.close();
            statement.close();
            FileData fileData2 = fileData;
            this.safeClose(rs);
            this.safeClose(statement);
            this.safeClose(connection);
            return fileData2;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    private FileData getHistoryVersionFileData(String name, String version) throws IOException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.readHistoricFileMetainfo);
            statement.setLong(1, Long.valueOf(version));
            statement.setString(2, name);
            rs = statement.executeQuery();
            FileData fileData = null;
            if (rs.next()) {
                fileData = this.createFileData(rs);
            }
            rs.close();
            statement.close();
            FileData fileData2 = fileData;
            this.safeClose(rs);
            this.safeClose(statement);
            this.safeClose(connection);
            return fileData2;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    private FileItem createFileItem(ResultSet rs) throws SQLException {
        FileData fileData = this.createFileData(rs);
        InputStream data = rs.getBinaryStream("file_data");
        if (data == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)data, (OutputStream)out);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return new FileItem(fileData, new ByteArrayInputStream(out.toByteArray()));
    }

    private FileData createFileData(ResultSet rs) throws SQLException {
        FileData fileData = new FileData();
        fileData.setName(rs.getString("file_name"));
        fileData.setSize(rs.getLong("file_size"));
        fileData.setAuthor(rs.getString("author"));
        fileData.setComment(rs.getString("file_comment"));
        fileData.setModifiedAt(rs.getTimestamp("modified_at"));
        fileData.setVersion(rs.getString("id"));
        fileData.setDeleted(rs.getBoolean("deleted"));
        return fileData;
    }

    protected void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                this.log.warn("Unexpected sql failure", (Throwable)e);
            }
        }
    }

    protected void safeClose(Connection connection) {
        if (connection != null) {
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to commit", (Throwable)e);
            }
            try {
                connection.close();
            }
            catch (Exception e) {
                this.log.warn("Unexpected sql failure", (Throwable)e);
            }
        }
    }

    private String makePathPattern(String path) {
        return path.replace("$", "$$").replace("%", "$%") + "%";
    }

    protected void safeClose(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (Exception e) {
                this.log.warn("Unexpected sql failure", (Throwable)e);
            }
        }
    }

    private void invokeListener() {
        this.monitor.fireOnChange();
    }

    @Override
    public void close() throws IOException {
        if (this.monitor != null) {
            this.monitor.release();
            this.monitor = null;
        }
    }

    private FileData insertFile(FileData data, InputStream stream) throws IOException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.insertFile);
            statement.setString(1, data.getName());
            statement.setString(2, data.getAuthor());
            statement.setString(3, data.getComment());
            if (stream != null) {
                statement.setBinaryStream(4, stream);
            } else {
                statement.setBinaryStream(4, (InputStream)null, 0);
            }
            statement.executeUpdate();
            data.setVersion(null);
            this.invokeListener();
            FileData fileData = data;
            this.safeClose(statement);
            this.safeClose(connection);
            return fileData;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(statement);
                this.safeClose(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        JDBCDriverRegister.registerDrivers();
        Exception actualException = null;
        try {
            Connection connection = this.getConnection();
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                String databaseCode = metaData.getDatabaseProductName().toLowerCase().replace(" ", "_");
                int majorVersion = metaData.getDatabaseMajorVersion();
                int minorVersion = metaData.getDatabaseMinorVersion();
                this.log.info("Driver name      : {}", (Object)metaData.getDriverName());
                this.log.info("Driver version   : {}", (Object)metaData.getDriverVersion());
                this.log.info("Database name    : {}", (Object)metaData.getDatabaseProductName());
                this.log.info("Database version : {}", (Object)metaData.getDatabaseProductVersion());
                this.log.info("Database code    : {}-v{}.{}", new Object[]{databaseCode, majorVersion, minorVersion});
                this.settings = new Settings(databaseCode, majorVersion, minorVersion);
                this.initializeDatabase(connection, databaseCode);
                this.monitor = new ChangesMonitor(new DBRepositoryRevisionGetter(), this.settings.timerPeriod);
            }
            catch (Exception e) {
                actualException = e;
            }
            finally {
                block23: {
                    block22: {
                        try {
                            if (!connection.getAutoCommit()) {
                                connection.commit();
                            }
                        }
                        catch (Exception e) {
                            if (actualException != null) break block22;
                            actualException = e;
                        }
                    }
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        if (actualException != null) break block23;
                        actualException = e;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to initialize repository", e);
        }
        if (actualException != null) {
            throw new IllegalStateException("Failed to initialize repository", actualException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDatabase(Connection connection, String databaseCode) throws SQLException {
        if (this.tableExists(connection, databaseCode)) {
            return;
        }
        Statement statement = connection.createStatement();
        try {
            for (String query : this.settings.initStatements) {
                if (!StringUtils.isNotBlank((CharSequence)query)) continue;
                statement.execute(query);
            }
        }
        finally {
            this.safeClose(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(Connection connection, String databaseCode) throws SQLException {
        ResultSet rs = null;
        String tableName = this.settings.tableName;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String repoTable = metaData.storesUpperCaseIdentifiers() ? tableName.toUpperCase() : tableName;
            rs = "oracle".equals(databaseCode) ? metaData.getTables(null, metaData.getUserName(), repoTable, new String[]{"TABLE"}) : metaData.getTables(null, null, repoTable, new String[]{"TABLE"});
            boolean bl = rs.next();
            this.safeClose(rs);
            return bl;
        }
        catch (Throwable throwable) {
            this.safeClose(rs);
            throw throwable;
        }
    }

    private class DBRepositoryRevisionGetter
    implements RevisionGetter {
        private DBRepositoryRevisionGetter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getRevision() {
            String changeSet = null;
            Connection connection = null;
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                connection = DBRepository.this.getConnection();
                statement = connection.prepareStatement(((DBRepository)DBRepository.this).settings.selectLastChange);
                rs = statement.executeQuery();
                if (rs.next()) {
                    changeSet = rs.getString(1);
                }
                DBRepository.this.safeClose(rs);
                DBRepository.this.safeClose(statement);
                DBRepository.this.safeClose(connection);
            }
            catch (Exception e) {
                try {
                    DBRepository.this.log.warn(e.getMessage(), (Throwable)e);
                    DBRepository.this.safeClose(rs);
                    DBRepository.this.safeClose(statement);
                    DBRepository.this.safeClose(connection);
                }
                catch (Throwable throwable) {
                    DBRepository.this.safeClose(rs);
                    DBRepository.this.safeClose(statement);
                    DBRepository.this.safeClose(connection);
                    throw throwable;
                }
            }
            return changeSet;
        }
    }
}

