/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.FileItem;
import org.openl.rules.repository.api.Listener;
import org.openl.rules.repository.api.Repository;
import org.openl.rules.repository.common.ChangesMonitor;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.file.FileChangesMonitor;
import org.openl.util.FileUtils;
import org.openl.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRepository
implements Repository,
RRepositoryFactory,
Closeable {
    private final Logger log = LoggerFactory.getLogger(FileRepository.class);
    private File root;
    private int rootPathLength;
    private ChangesMonitor monitor;

    public void setRoot(File root) {
        this.root = root;
    }

    public void setUri(String path) {
        this.root = new File(path);
    }

    @Override
    public void initialize() throws RRepositoryException {
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RRepositoryException(e.getMessage(), e);
        }
    }

    private void init() throws IOException {
        this.root.mkdirs();
        if (!this.root.exists() || !this.root.isDirectory()) {
            throw new IOException("Failed to initialize the root directory: [" + this.root + "]");
        }
        String rootPath = this.root.getCanonicalPath();
        this.rootPathLength = rootPath.length() + 1;
        this.monitor = new ChangesMonitor(new FileChangesMonitor(this.getRoot()), 10);
    }

    @Override
    public List<FileData> list(String path) throws IOException {
        LinkedList<FileData> files = new LinkedList<FileData>();
        File directory = new File(this.root, path);
        this.listFiles(files, directory);
        return files;
    }

    @Override
    public FileData check(String name) throws IOException {
        File file = new File(this.root, name);
        if (file.exists()) {
            return this.getFileData(file);
        }
        return null;
    }

    @Override
    public FileItem read(String name) throws IOException {
        File file = new File(this.root, name);
        if (file.exists()) {
            FileData data = this.getFileData(file);
            FileInputStream stream = new FileInputStream(file);
            return new FileItem(data, stream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileData save(FileData data, InputStream stream) throws IOException {
        String name = data.getName();
        File file = new File(this.root, name);
        file.getParentFile().mkdirs();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
            IOUtils.copy((InputStream)stream, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)output);
        return this.getFileData(file);
    }

    @Override
    public boolean delete(FileData data) {
        File file = new File(this.root, data.getName());
        boolean deleted = file.delete();
        while (!(file = file.getParentFile()).equals(this.root) && file.delete()) {
        }
        return deleted;
    }

    @Override
    public FileData copy(String srcName, FileData destData) throws IOException {
        File srcFile = new File(this.root, srcName);
        String destName = destData.getName();
        File destFile = new File(this.root, destName);
        FileUtils.copy((File)srcFile, (File)destFile);
        return this.getFileData(destFile);
    }

    @Override
    public FileData rename(String srcName, FileData destData) throws IOException {
        File srcFile = new File(this.root, srcName);
        String destName = destData.getName();
        File destFile = new File(this.root, destName);
        boolean renamed = srcFile.renameTo(destFile);
        if (!renamed) {
            throw new IOException("Impossible to rename the file from [" + srcFile + "] to [" + destFile + "]");
        }
        while (!(srcFile = srcFile.getParentFile()).equals(this.root) && srcFile.delete()) {
        }
        return this.getFileData(destFile);
    }

    @Override
    public void setListener(Listener callback) {
        this.monitor.setListener(callback);
    }

    @Override
    public List<FileData> listHistory(String name) throws IOException {
        File file = new File(this.root, name);
        try {
            if (file.exists()) {
                FileData data = this.getFileData(file);
                return Collections.singletonList(data);
            }
        }
        catch (Exception ex) {
            this.log.warn("The file cannot be resolved: [{}]", (Object)file, (Object)ex);
        }
        return Collections.emptyList();
    }

    @Override
    public FileData checkHistory(String name, String version) throws IOException {
        if (version == null) {
            return this.check(name);
        }
        return null;
    }

    @Override
    public FileItem readHistory(String name, String version) throws IOException {
        if (version == null) {
            return this.read(name);
        }
        return null;
    }

    @Override
    public boolean deleteHistory(String name, String version) {
        FileData fileData = new FileData();
        fileData.setName(name);
        return version == null && this.delete(fileData);
    }

    @Override
    public FileData copyHistory(String srcName, FileData destData, String version) throws IOException {
        if (version == null) {
            return this.copy(srcName, destData);
        }
        throw new FileNotFoundException("File versions is not supported.");
    }

    private void listFiles(Collection<FileData> files, File directory) {
        File[] found = directory.listFiles();
        if (found != null) {
            for (File file : found) {
                if (file.isDirectory()) {
                    this.listFiles(files, file);
                    continue;
                }
                try {
                    FileData data = this.getFileData(file);
                    files.add(data);
                }
                catch (Exception ex) {
                    this.log.warn("The file cannot be resolved in the directory {}.", (Object)directory, (Object)ex);
                }
            }
        }
    }

    private FileData getFileData(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File [" + file + "] does not exist.");
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("File [" + file + "] is not a file.");
        }
        if (this.rootPathLength == 0) {
            this.init();
        }
        FileData data = new FileData();
        String canonicalPath = file.getCanonicalPath();
        String relativePath = canonicalPath.substring(this.rootPathLength);
        String converted = relativePath.replace('\\', '/');
        data.setName(converted);
        long timestamp = file.lastModified();
        Date date = new Date(timestamp);
        data.setModifiedAt(date);
        long size = file.length();
        data.setSize(size);
        return data;
    }

    public File getRoot() {
        return this.root;
    }

    @Override
    public void close() throws IOException {
        if (this.monitor != null) {
            this.monitor.release();
            this.monitor = null;
        }
    }

    protected void invokeListener() {
        if (this.monitor != null) {
            this.monitor.fireOnChange();
        }
    }
}

