/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.openl.rules.repository.db.DBRepository;
import org.openl.util.StringUtils;

public class DatasourceDBRepositoryFactory
extends DBRepository {
    private DataSource dataSource;
    private String uri;
    private String login;
    private String password;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    protected Connection getConnection() throws SQLException {
        if (StringUtils.isBlank((CharSequence)this.login)) {
            return this.dataSource.getConnection();
        }
        return this.dataSource.getConnection(this.login, this.password);
    }

    @Override
    public void initialize() {
        this.init();
        super.initialize();
    }

    private void init() {
        if (this.dataSource != null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.uri)) {
            throw new IllegalStateException("Required 'uri' property is not defined.");
        }
        InitialContext initialContext = this.createInitialContext();
        Throwable exception = null;
        try {
            this.dataSource = (DataSource)initialContext.lookup(this.uri);
        }
        catch (Throwable e) {
            exception = new IllegalStateException("Cannot determine JNDI [ " + this.uri + " ] name", e);
            throw exception;
        }
        finally {
            if (exception != null) {
                try {
                    initialContext.close();
                }
                catch (Throwable e) {
                    exception.addSuppressed(new IllegalStateException("Cannot close JNDI context", e));
                }
            } else {
                this.closeInitialContext(initialContext);
            }
        }
        if (this.dataSource == null) {
            throw new IllegalStateException("DataSource has not been found in JNDI context by 'uri' : " + this.uri);
        }
    }

    private InitialContext createInitialContext() {
        try {
            return new InitialContext();
        }
        catch (NamingException e) {
            throw new IllegalStateException("Cannot initialize JNDI context", e);
        }
    }

    private void closeInitialContext(InitialContext initialContext) {
        try {
            initialContext.close();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot close JNDI context", e);
        }
    }
}

