/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.file;

import java.io.File;
import java.util.ArrayList;
import org.openl.rules.repository.common.RevisionGetter;
import org.openl.rules.repository.file.FileTimeStamp;

public final class FileChangesMonitor
implements RevisionGetter {
    private final File baseDir;
    private ArrayList<FileTimeStamp> timestamps = new ArrayList(0);
    private int revision;

    FileChangesMonitor(File baseDir) {
        this.baseDir = baseDir;
    }

    private void collect(File file, ArrayList<FileTimeStamp> result) {
        if (file.isDirectory()) {
            File[] filesArray = file.listFiles();
            if (filesArray != null) {
                for (File f : filesArray) {
                    this.collect(f, result);
                }
            }
        } else {
            result.add(new FileTimeStamp(file));
        }
    }

    @Override
    public Object getRevision() {
        int quantity = this.timestamps.size();
        ArrayList<FileTimeStamp> newTimestamps = new ArrayList<FileTimeStamp>(quantity + 10);
        this.collect(this.baseDir, newTimestamps);
        boolean changed = false;
        if (newTimestamps.size() != quantity) {
            changed = true;
        } else {
            for (FileTimeStamp entry : this.timestamps) {
                if (!entry.isModified()) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.timestamps = newTimestamps;
            ++this.revision;
        }
        return this.revision;
    }
}

