/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.api.ChangesetType;
import org.openl.rules.repository.api.Features;
import org.openl.rules.repository.api.FeaturesBuilder;
import org.openl.rules.repository.api.FileChange;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.FileItem;
import org.openl.rules.repository.api.FolderItem;
import org.openl.rules.repository.api.FolderRepository;
import org.openl.rules.repository.api.Listener;
import org.openl.rules.repository.common.ChangesMonitor;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.file.FileChangesMonitor;
import org.openl.util.FileUtils;
import org.openl.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRepository
implements FolderRepository,
RRepositoryFactory,
Closeable {
    private final Logger log = LoggerFactory.getLogger(FileSystemRepository.class);
    private File root;
    private int rootPathLength;
    private ChangesMonitor monitor;

    public void setRoot(File root) {
        this.root = root;
    }

    public void setUri(String path) {
        this.root = new File(path);
    }

    @Override
    public void initialize() throws RRepositoryException {
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RRepositoryException(e.getMessage(), e);
        }
    }

    private void init() throws IOException {
        this.root.mkdirs();
        if (!this.root.exists() || !this.root.isDirectory()) {
            throw new IOException("Failed to initialize the root directory: [" + this.root + "]");
        }
        String rootPath = this.root.getCanonicalPath();
        this.rootPathLength = rootPath.length() + 1;
        this.monitor = new ChangesMonitor(new FileChangesMonitor(this.getRoot()), 10);
    }

    @Override
    public List<FileData> list(String path) throws IOException {
        LinkedList<FileData> files = new LinkedList<FileData>();
        File directory = new File(this.root, path);
        this.listFiles(files, directory);
        return files;
    }

    @Override
    public FileData check(String name) throws IOException {
        File file = new File(this.root, name);
        if (file.exists()) {
            return this.getFileData(file);
        }
        return null;
    }

    @Override
    public FileItem read(String name) throws IOException {
        File file = new File(this.root, name);
        if (file.exists()) {
            FileData data = this.getFileData(file);
            FileInputStream stream = new FileInputStream(file);
            return new FileItem(data, stream);
        }
        return null;
    }

    @Override
    public FileData save(FileData data, InputStream stream) throws IOException {
        String name = data.getName();
        File file = new File(this.root, name);
        file.getParentFile().mkdirs();
        try (FileOutputStream output = new FileOutputStream(file);){
            IOUtils.copy((InputStream)stream, (OutputStream)output);
        }
        if (data.getModifiedAt() != null && !file.setLastModified(data.getModifiedAt().getTime())) {
            this.log.warn("Can't set modified time to file {}", (Object)name);
        }
        return this.getFileData(file);
    }

    @Override
    public List<FileData> save(List<FileItem> fileItems) throws IOException {
        ArrayList<FileData> result = new ArrayList<FileData>();
        for (FileItem fileItem : fileItems) {
            FileData saved = this.save(fileItem.getData(), fileItem.getStream());
            result.add(saved);
        }
        return result;
    }

    @Override
    public boolean delete(FileData data) {
        boolean deleted;
        File file = new File(this.root, data.getName());
        try {
            FileUtils.delete((File)file);
            deleted = true;
        }
        catch (IOException e) {
            deleted = false;
        }
        while (!(file = file.getParentFile()).equals(this.root) && file.delete()) {
        }
        return deleted;
    }

    private FileData copy(String srcName, FileData destData) throws IOException {
        File srcFile = new File(this.root, srcName);
        String destName = destData.getName();
        File destFile = new File(this.root, destName);
        FileUtils.copy((File)srcFile, (File)destFile);
        return this.getFileData(destFile);
    }

    @Override
    public void setListener(Listener callback) {
        if (this.monitor != null) {
            this.monitor.setListener(callback);
        }
    }

    @Override
    public List<FileData> listHistory(String name) {
        File file = new File(this.root, name);
        try {
            if (file.exists()) {
                FileData data = this.getFileData(file);
                return Collections.singletonList(data);
            }
        }
        catch (Exception ex) {
            this.log.warn("The file cannot be resolved: [{}]", (Object)file, (Object)ex);
        }
        return Collections.emptyList();
    }

    @Override
    public FileData checkHistory(String name, String version) throws IOException {
        if (version == null) {
            return this.check(name);
        }
        return null;
    }

    @Override
    public FileItem readHistory(String name, String version) throws IOException {
        if (version == null) {
            return this.read(name);
        }
        return null;
    }

    @Override
    public boolean deleteHistory(FileData data) {
        return data.getVersion() == null && this.delete(data);
    }

    @Override
    public FileData copyHistory(String srcName, FileData destData, String version) throws IOException {
        if (version == null) {
            return this.copy(srcName, destData);
        }
        throw new FileNotFoundException("File versions are not supported.");
    }

    @Override
    public Features supports() {
        return new FeaturesBuilder(this).setVersions(false).build();
    }

    private void listFiles(Collection<FileData> files, File directory) {
        File[] found = directory.listFiles();
        if (found != null) {
            for (File file : found) {
                if (file.isDirectory()) {
                    this.listFiles(files, file);
                    continue;
                }
                try {
                    FileData data = this.getFileData(file);
                    files.add(data);
                }
                catch (Exception ex) {
                    this.log.warn("The file cannot be resolved in the directory {}.", (Object)directory, (Object)ex);
                }
            }
        }
    }

    protected FileData getFileData(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File [" + file + "] does not exist.");
        }
        if (this.rootPathLength == 0) {
            this.init();
        }
        FileData data = new FileData();
        String canonicalPath = file.getCanonicalPath();
        String relativePath = canonicalPath.substring(this.rootPathLength);
        String converted = relativePath.replace('\\', '/');
        data.setName(converted);
        long timestamp = file.lastModified();
        Date date = new Date(timestamp);
        data.setModifiedAt(date);
        if (file.isFile()) {
            long size = file.length();
            data.setSize(size);
        }
        return data;
    }

    public File getRoot() {
        return this.root;
    }

    @Override
    public void close() {
        if (this.monitor != null) {
            this.monitor.release();
            this.monitor = null;
        }
    }

    protected void invokeListener() {
        if (this.monitor != null) {
            this.monitor.fireOnChange();
        }
    }

    @Override
    public List<FileData> listFolders(String path) {
        LinkedList<FileData> files = new LinkedList<FileData>();
        File directory = new File(this.root, path);
        File[] found = directory.listFiles();
        if (found != null) {
            for (File file : found) {
                if (!file.isDirectory()) continue;
                try {
                    if (this.rootPathLength == 0) {
                        this.init();
                    }
                    FileData data = new FileData();
                    String relativePath = file.getCanonicalPath().substring(this.rootPathLength);
                    data.setName(relativePath.replace('\\', '/'));
                    data.setModifiedAt(new Date(file.lastModified()));
                    files.add(data);
                }
                catch (Exception ex) {
                    this.log.warn("Folder cannot be resolved in the directory {}.", (Object)directory, (Object)ex);
                }
            }
        }
        return files;
    }

    @Override
    public List<FileData> listFiles(String path, String version) throws IOException {
        if (version == null) {
            return this.list(path);
        }
        return Collections.emptyList();
    }

    @Override
    public FileData save(FileData folderData, Iterable<FileChange> files, ChangesetType changesetType) throws IOException {
        ArrayList<File> savedFiles = new ArrayList<File>();
        for (FileChange change : files) {
            FileData data = change.getData();
            File file = new File(this.root, data.getName());
            savedFiles.add(file);
            this.createParent(file);
            InputStream stream = change.getStream();
            if (stream != null) {
                try (FileOutputStream output = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)stream, (OutputStream)output);
                }
                if (data.getModifiedAt() == null || file.setLastModified(data.getModifiedAt().getTime())) continue;
                this.log.warn("Can't set modified time to file {}", (Object)data.getName());
                continue;
            }
            FileUtils.deleteQuietly((File)file);
        }
        File folder = new File(this.root, folderData.getName());
        if (changesetType == ChangesetType.FULL) {
            this.removeAbsentFiles(folder, savedFiles);
        }
        return folder.exists() ? this.getFileData(folder) : null;
    }

    @Override
    public List<FileData> save(List<FolderItem> folderItems, ChangesetType changesetType) throws IOException {
        ArrayList<FileData> result = new ArrayList<FileData>();
        for (FolderItem folderItem : folderItems) {
            FileData saved = this.save(folderItem.getData(), folderItem.getFiles(), changesetType);
            result.add(saved);
        }
        return result;
    }

    private void removeAbsentFiles(File directory, Collection<File> toSave) {
        File[] found = directory.listFiles();
        if (found != null) {
            for (File file : found) {
                if (this.isSkip(file)) continue;
                if (file.isDirectory()) {
                    this.removeAbsentFiles(file, toSave);
                    continue;
                }
                if (toSave.contains(file)) continue;
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    protected boolean isSkip(File file) {
        return false;
    }

    private void createParent(File file) throws FileNotFoundException {
        File parentFile = file.getParentFile();
        if (!parentFile.mkdirs() && !parentFile.exists()) {
            throw new FileNotFoundException("Can't create the folder " + parentFile.getAbsolutePath());
        }
    }
}

