/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.folder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openl.rules.repository.api.FileChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangesFromZip
implements Iterable<FileChange> {
    private final Logger log = LoggerFactory.getLogger(FileChangesFromZip.class);
    private final ZipInputStream stream;
    private final String folderTo;

    public FileChangesFromZip(ZipInputStream stream, String folderTo) {
        this.stream = stream;
        this.folderTo = folderTo;
    }

    @Override
    public Iterator<FileChange> iterator() {
        return new Iterator<FileChange>(){
            private ZipEntry entry;

            @Override
            public boolean hasNext() {
                try {
                    do {
                        this.entry = FileChangesFromZip.this.stream.getNextEntry();
                    } while (this.entry != null && this.entry.isDirectory());
                }
                catch (IOException e) {
                    FileChangesFromZip.this.log.error(e.getMessage(), (Throwable)e);
                    this.entry = null;
                }
                return this.entry != null;
            }

            @Override
            public FileChange next() {
                return new FileChange(FileChangesFromZip.this.folderTo + "/" + this.entry.getName(), (InputStream)FileChangesFromZip.this.stream);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove is not supported");
            }
        };
    }
}

