/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.common.impl;

import java.util.regex.Pattern;
import org.openl.rules.common.CommonVersion;

public class CommonVersionImpl
implements CommonVersion {
    private static final Pattern ONLY_DIGITS = Pattern.compile("\\d+");
    private int major = Short.MAX_VALUE;
    private int minor = Short.MAX_VALUE;
    private String revision = "0";
    private transient String versionName;

    public CommonVersionImpl(CommonVersion version) {
        this.major = version.getMajor();
        this.minor = version.getMinor();
        this.revision = version.getRevision();
    }

    public CommonVersionImpl(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = "" + revision;
    }

    public CommonVersionImpl(int revision) {
        this.revision = "" + revision;
    }

    public CommonVersionImpl(String s) {
        if (!s.matches("\\d+\\.\\d+(\\.\\d+.*)?")) {
            this.revision = s;
            return;
        }
        String[] version = s.split("\\.");
        if (version.length == 1) {
            this.revision = version[0];
        } else {
            this.major = Integer.parseInt(version[0]);
            this.minor = Integer.parseInt(version[1]);
            if (version.length > 2) {
                this.revision = version[2];
            }
        }
    }

    @Override
    public int compareTo(CommonVersion o) {
        if (this.revision.equals(o.getRevision())) {
            return 0;
        }
        if (this.revision.equals("0")) {
            return -1;
        }
        if (o.getRevision().equals("0")) {
            return 1;
        }
        if (this.major != o.getMajor()) {
            return this.major < o.getMajor() ? -1 : 1;
        }
        if (this.minor != o.getMinor()) {
            return this.minor < o.getMinor() ? -1 : 1;
        }
        return this.compareRevision(o);
    }

    private int compareRevision(CommonVersion other) {
        String otherRevision = other.getRevision();
        if (ONLY_DIGITS.matcher(this.revision).matches() && ONLY_DIGITS.matcher(otherRevision).matches()) {
            return Integer.parseInt(this.revision) - Integer.parseInt(otherRevision);
        }
        return this.revision.compareTo(otherRevision);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommonVersion)) {
            return false;
        }
        return this.compareTo((CommonVersion)o) == 0;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public String getVersionName() {
        if (this.versionName == null) {
            this.versionName = this.major != Short.MAX_VALUE && this.minor != Short.MAX_VALUE && this.major != -1 && this.minor != -1 ? this.major + "." + this.minor + "." + this.revision : this.revision;
        }
        return this.versionName;
    }

    @Override
    public String getShortVersion() {
        String version = this.getVersionName();
        return version == null || version.length() < 6 ? version : version.substring(0, 6);
    }

    public int hashCode() {
        return this.major << 22 ^ this.minor << 11 ^ this.revision.hashCode();
    }

    public String toString() {
        return "versionName = " + this.getVersionName();
    }
}

