/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.openl.rules.repository.api.Repository;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertyResolver;

public class RepositoryInstatiator {
    public static final String REPOSITORY_PREFIX = "repository.";

    private static Logger log() {
        return LoggerFactory.getLogger(RepositoryInstatiator.class);
    }

    public static Repository newRepository(String configName, PropertyResolver propertyResolver) throws RRepositoryException {
        String factoryClass = propertyResolver.getProperty(REPOSITORY_PREFIX + configName + ".factory");
        try {
            Repository repository = RepositoryInstatiator.newInstance(factoryClass);
            RepositoryInstatiator.setParams(repository, propertyResolver, configName);
            RepositoryInstatiator.initialize(repository);
            return repository;
        }
        catch (Exception e) {
            String message = "Failed to initialize repository: " + configName;
            RepositoryInstatiator.log().error(message, (Throwable)e);
            throw new RRepositoryException(message, e);
        }
    }

    public static Repository newRepository(String factory, Map<String, String> params) {
        Repository repository = RepositoryInstatiator.newInstance(factory);
        if (params != null) {
            RepositoryInstatiator.setParams(repository, params);
        }
        RepositoryInstatiator.initialize(repository);
        return repository;
    }

    private static Repository newInstance(String factory) {
        Object instance;
        try {
            Class<?> clazz = Class.forName(factory);
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate a repository: " + factory, e);
        }
        catch (UnsupportedClassVersionError e) {
            throw new IllegalStateException("Library is compiled using newer version of JDK.", e);
        }
        try {
            return (Repository)instance;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(String.format("%s must be an implementation of %s.", instance.getClass().getTypeName(), Repository.class.getTypeName()), e);
        }
    }

    private static void setParams(Object instance, Map<String, String> params) {
        Class<?> clazz = instance.getClass();
        for (Map.Entry<String, String> param : params.entrySet()) {
            String value = param.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            String name = param.getKey();
            RepositoryInstatiator.injectValue(instance, clazz, value, name);
        }
    }

    private static void injectValue(Object instance, Class<?> clazz, String value, String fieldName) {
        String setter = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        try {
            Method setMethod = clazz.getMethod(setter, String.class);
            setMethod.invoke(instance, value);
        }
        catch (NoSuchMethodException e) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals(setter) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                try {
                    method.invoke(instance, RepositoryInstatiator.convert(parameterTypes[0], value));
                }
                catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                }
                catch (InvocationTargetException e1) {
                    throw new IllegalStateException("Failed to invoke " + setter + "(" + parameterTypes[0].getSimpleName() + ") method in: " + clazz, e1);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to invoke method '%s.%s(String)'.", clazz.getTypeName(), fieldName), e);
        }
    }

    private static void setParams(Object instance, PropertyResolver propertyResolver, String configName) {
        Class<?> clazz = instance.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            String propertyName = RepositoryInstatiator.buildPropertyName(configName, fieldName);
            String propertyValue = propertyResolver.getProperty(propertyName);
            boolean propertyExists = StringUtils.isNotBlank((CharSequence)propertyValue);
            if (!propertyExists) continue;
            RepositoryInstatiator.injectValue(instance, clazz, propertyValue, fieldName);
        }
    }

    private static String buildPropertyName(String configName, String name) {
        return REPOSITORY_PREFIX + configName + "." + RepositoryInstatiator.toPropertiesCase(name);
    }

    private static String toPropertiesCase(String key) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        for (char aChar : chars = key.toCharArray()) {
            char c = aChar;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
                sb.append("-").append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static Object convert(Class<?> parameterType, String value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (parameterType.isPrimitive()) {
            parameterType = ClassUtils.primitiveToWrapper(parameterType);
        }
        Method valueOfMethod = parameterType.getMethod("valueOf", String.class);
        return valueOfMethod.invoke(null, value);
    }

    private static void initialize(Object instance) {
        Class<?> clazz = instance.getClass();
        try {
            Method initMethod = clazz.getMethod("initialize", new Class[0]);
            initMethod.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Failed on method '%s.initialize()' call.", clazz), e);
        }
    }
}

