/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.api;

import java.util.Iterator;
import org.openl.rules.repository.api.AdditionalData;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.FileItem;
import org.openl.rules.repository.api.PathConverter;

public class ConflictResolveData
implements AdditionalData<ConflictResolveData> {
    private final String commitToMerge;
    private final Iterable<FileItem> resolvedFiles;
    private final String mergeMessage;

    public ConflictResolveData(String commitToMerge, Iterable<FileItem> resolvedFiles, String mergeMessage) {
        this.commitToMerge = commitToMerge;
        this.resolvedFiles = resolvedFiles;
        this.mergeMessage = mergeMessage;
    }

    public String getCommitToMerge() {
        return this.commitToMerge;
    }

    public Iterable<FileItem> getResolvedFiles() {
        return this.resolvedFiles;
    }

    public String getMergeMessage() {
        return this.mergeMessage;
    }

    @Override
    public ConflictResolveData convertPaths(final PathConverter converter) {
        Iterable<FileItem> convertedFolders = new Iterable<FileItem>(){

            @Override
            public Iterator<FileItem> iterator() {
                return new Iterator<FileItem>(){
                    private final Iterator<FileItem> delegate;
                    {
                        this.delegate = ConflictResolveData.this.resolvedFiles.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegate.hasNext();
                    }

                    @Override
                    public FileItem next() {
                        FileItem oldPath = this.delegate.next();
                        FileData data = oldPath.getData();
                        data.setName(converter.convert(oldPath.getData().getName()));
                        return new FileItem(data, oldPath.getStream());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove is not supported");
                    }
                };
            }
        };
        return new ConflictResolveData(this.commitToMerge, convertedFolders, this.mergeMessage);
    }
}

