/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.common;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openl.rules.repository.api.Listener;
import org.openl.rules.repository.common.RevisionGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangesMonitor
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(ChangesMonitor.class);
    private RevisionGetter getter;
    private int period;
    private ScheduledExecutorService scheduledPool;
    private ScheduledFuture<?> scheduled;
    private Listener callback;
    private Object lastChange;

    public ChangesMonitor(RevisionGetter getter, int period) {
        this.getter = getter;
        this.period = period;
    }

    public synchronized void setListener(Listener listener) {
        this.callback = listener;
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
        }
        if (listener == null) {
            this.scheduled = null;
            this.lastChange = null;
        } else {
            if (this.scheduledPool == null) {
                this.scheduledPool = Executors.newSingleThreadScheduledExecutor();
            }
            this.lastChange = this.getRevision();
            this.scheduled = this.scheduledPool.scheduleWithFixedDelay(this, this.period, this.period, TimeUnit.SECONDS);
        }
    }

    @Override
    public void run() {
        try {
            Object currentChange = this.getRevision();
            if (currentChange == null) {
                return;
            }
            if (currentChange.equals(this.lastChange)) {
                return;
            }
            this.lastChange = currentChange;
            this.fireOnChange();
        }
        catch (Throwable th) {
            this.log.warn("An exception has occurred during checking the repository", th);
        }
    }

    public void fireOnChange() {
        Listener listener = this.callback;
        try {
            if (listener != null) {
                listener.onChange();
            }
        }
        catch (Throwable th) {
            this.log.warn("An exception has occurred in onChange() method in '{}' listener", (Object)listener, (Object)th);
        }
    }

    public synchronized void release() {
        this.getter = null;
        if (this.scheduledPool != null) {
            this.scheduledPool.shutdownNow();
        }
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
            this.scheduled = null;
        }
        if (this.scheduledPool != null) {
            try {
                this.scheduledPool.awaitTermination(this.period, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.scheduledPool = null;
        }
    }

    private Object getRevision() {
        try {
            return this.getter.getRevision();
        }
        catch (Throwable th) {
            this.log.warn("An exception has occurred during retrieving the last change set from the repository", th);
            return null;
        }
    }
}

