/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.api.Features;
import org.openl.rules.repository.api.FeaturesBuilder;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.FileItem;
import org.openl.rules.repository.api.Listener;
import org.openl.rules.repository.api.Repository;
import org.openl.rules.repository.common.ChangesMonitor;
import org.openl.rules.repository.common.RevisionGetter;
import org.openl.rules.repository.db.Settings;
import org.openl.util.IOUtils;
import org.openl.util.StringUtils;
import org.openl.util.db.JDBCDriverRegister;
import org.openl.util.db.SqlDBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBRepository
implements Repository,
Closeable,
RRepositoryFactory {
    private final Logger log = LoggerFactory.getLogger(DBRepository.class);
    private Settings settings;
    private ChangesMonitor monitor;

    @Override
    public List<FileData> list(String path) throws IOException {
        ArrayList<FileData> arrayList;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.selectAllMetainfo);
            statement.setString(1, this.makePathPattern(path));
            rs = statement.executeQuery();
            ArrayList<FileData> fileDatas = new ArrayList<FileData>();
            while (rs.next()) {
                FileData fileData = this.createFileData(rs);
                fileDatas.add(fileData);
            }
            rs.close();
            statement.close();
            arrayList = fileDatas;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(rs);
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((ResultSet)rs);
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return arrayList;
    }

    @Override
    public FileData check(String name) throws IOException {
        return this.getLatestVersionFileData(name);
    }

    @Override
    public FileItem read(String name) throws IOException {
        FileItem fileItem;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.readActualFile);
            statement.setString(1, name);
            rs = statement.executeQuery();
            FileItem fileItem2 = null;
            if (rs.next()) {
                fileItem2 = this.createFileItem(rs);
            }
            rs.close();
            statement.close();
            fileItem = fileItem2;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(rs);
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((ResultSet)rs);
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return fileItem;
    }

    @Override
    public FileData save(FileData data, InputStream stream) throws IOException {
        return this.insertFile(data, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileData> save(List<FileItem> fileItems) throws IOException {
        ArrayList<FileData> result = new ArrayList<FileData>();
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            for (FileItem fileItem : fileItems) {
                FileData data = fileItem.getData();
                PreparedStatement statement = null;
                try {
                    statement = this.createInsertFileStatement(connection, data, fileItem.getStream());
                    statement.executeUpdate();
                }
                catch (Throwable throwable) {
                    SqlDBUtils.safeClose(statement);
                    throw throwable;
                }
                SqlDBUtils.safeClose((Statement)statement);
                data.setVersion(null);
                result.add(data);
            }
            connection.commit();
            this.invokeListener();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            SqlDBUtils.safeClose((Connection)connection);
        }
        return result;
    }

    @Override
    public boolean delete(FileData path) throws IOException {
        FileData data;
        try {
            data = this.getLatestVersionFileData(path.getName());
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        if (data != null) {
            try {
                this.insertFile(data, null);
                this.invokeListener();
                return true;
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return false;
    }

    private FileData copy(String srcName, FileData destData) throws IOException {
        FileData fileData;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.copyFile);
            statement.setString(1, destData.getName());
            statement.setString(2, destData.getAuthor());
            statement.setString(3, destData.getComment());
            statement.setString(4, srcName);
            statement.executeUpdate();
            this.invokeListener();
            fileData = destData;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return fileData;
    }

    @Override
    public void setListener(Listener callback) {
        if (this.monitor != null) {
            this.monitor.setListener(callback);
        }
    }

    @Override
    public List<FileData> listHistory(String name) throws IOException {
        ArrayList<FileData> arrayList;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.selectAllHistoryMetainfo);
            statement.setString(1, name);
            rs = statement.executeQuery();
            ArrayList<FileData> fileDatas = new ArrayList<FileData>();
            while (rs.next()) {
                FileData fileData = this.createFileData(rs);
                fileDatas.add(fileData);
            }
            rs.close();
            statement.close();
            arrayList = fileDatas;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(rs);
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((ResultSet)rs);
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return arrayList;
    }

    @Override
    public FileData checkHistory(String name, String version) throws IOException {
        return version == null ? this.check(name) : this.getHistoryVersionFileData(name, version);
    }

    @Override
    public FileItem readHistory(String name, String version) throws IOException {
        FileItem fileItem;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.readHistoricFile);
            statement.setLong(1, Long.parseLong(version));
            statement.setString(2, name);
            rs = statement.executeQuery();
            FileItem fileItem2 = null;
            if (rs.next()) {
                fileItem2 = this.createFileItem(rs);
            }
            rs.close();
            statement.close();
            fileItem = fileItem2;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(rs);
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((ResultSet)rs);
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return fileItem;
    }

    @Override
    public boolean deleteHistory(FileData data) throws IOException {
        boolean bl;
        PreparedStatement statement;
        Connection connection;
        block12: {
            String name = data.getName();
            String version = data.getVersion();
            if (version == null) {
                boolean bl2;
                PreparedStatement statement2;
                Connection connection2;
                block11: {
                    connection2 = null;
                    statement2 = null;
                    connection2 = this.getConnection();
                    statement2 = connection2.prepareStatement(this.settings.deleteAllHistory);
                    statement2.setString(1, name);
                    int rows = statement2.executeUpdate();
                    if (rows <= 0) break block11;
                    this.invokeListener();
                    boolean bl3 = true;
                    SqlDBUtils.safeClose((Statement)statement2);
                    SqlDBUtils.safeClose((Connection)connection2);
                    return bl3;
                }
                try {
                    bl2 = false;
                }
                catch (SQLException e) {
                    try {
                        this.log.error(e.getMessage(), (Throwable)e);
                        throw new IOException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        SqlDBUtils.safeClose(statement2);
                        SqlDBUtils.safeClose((Connection)connection2);
                        throw throwable;
                    }
                }
                SqlDBUtils.safeClose((Statement)statement2);
                SqlDBUtils.safeClose((Connection)connection2);
                return bl2;
            }
            connection = null;
            statement = null;
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.deleteVersion);
            statement.setLong(1, Long.parseLong(version));
            statement.setString(2, name);
            int rows = statement.executeUpdate();
            if (rows <= 0) break block12;
            this.invokeListener();
            boolean bl4 = true;
            SqlDBUtils.safeClose((Statement)statement);
            SqlDBUtils.safeClose((Connection)connection);
            return bl4;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new IOException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return bl;
    }

    @Override
    public FileData copyHistory(String srcName, FileData destData, String version) throws IOException {
        FileData fileData;
        if (version == null) {
            return this.copy(srcName, destData);
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.copyHistory);
            statement.setString(1, destData.getName());
            statement.setString(2, destData.getAuthor());
            statement.setString(3, destData.getComment());
            statement.setLong(4, Long.parseLong(version));
            statement.setString(5, srcName);
            statement.executeUpdate();
            this.invokeListener();
            fileData = destData;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return fileData;
    }

    @Override
    public Features supports() {
        return new FeaturesBuilder(this).build();
    }

    protected abstract Connection getConnection() throws SQLException;

    private FileData getLatestVersionFileData(String name) throws IOException {
        FileData fileData;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.readActualFileMetainfo);
            statement.setString(1, name);
            rs = statement.executeQuery();
            FileData fileData2 = null;
            if (rs.next()) {
                fileData2 = this.createFileData(rs);
            }
            rs.close();
            statement.close();
            fileData = fileData2;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(rs);
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((ResultSet)rs);
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return fileData;
    }

    private FileData getHistoryVersionFileData(String name, String version) throws IOException {
        FileData fileData;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.readHistoricFileMetainfo);
            statement.setLong(1, Long.parseLong(version));
            statement.setString(2, name);
            rs = statement.executeQuery();
            FileData fileData2 = null;
            if (rs.next()) {
                fileData2 = this.createFileData(rs);
            }
            rs.close();
            statement.close();
            fileData = fileData2;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(rs);
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((ResultSet)rs);
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return fileData;
    }

    private FileItem createFileItem(ResultSet rs) throws SQLException {
        FileData fileData = this.createFileData(rs);
        InputStream data = rs.getBinaryStream("file_data");
        if (data == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)data, (OutputStream)out);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return new FileItem(fileData, (InputStream)new ByteArrayInputStream(out.toByteArray()));
    }

    private FileData createFileData(ResultSet rs) throws SQLException {
        FileData fileData = new FileData();
        fileData.setName(rs.getString("file_name"));
        fileData.setSize(rs.getLong("file_size"));
        fileData.setAuthor(rs.getString("author"));
        fileData.setComment(rs.getString("file_comment"));
        fileData.setModifiedAt(rs.getTimestamp("modified_at"));
        fileData.setVersion(rs.getString("id"));
        fileData.setDeleted(rs.getBoolean("deleted"));
        return fileData;
    }

    private String makePathPattern(String path) {
        return path.replace("$", "$$").replace("%", "$%") + "%";
    }

    private void invokeListener() {
        this.monitor.fireOnChange();
    }

    @Override
    public void close() {
        if (this.monitor != null) {
            this.monitor.release();
            this.monitor = null;
        }
    }

    private FileData insertFile(FileData data, InputStream stream) throws IOException {
        FileData fileData;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = this.createInsertFileStatement(connection, data, stream);
            statement.executeUpdate();
            data.setVersion(null);
            this.invokeListener();
            fileData = data;
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
        }
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return fileData;
    }

    private PreparedStatement createInsertFileStatement(Connection connection, FileData data, InputStream stream) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(this.settings.insertFile);
        statement.setString(1, data.getName());
        statement.setString(2, data.getAuthor());
        statement.setString(3, data.getComment());
        if (stream != null) {
            statement.setBinaryStream(4, stream);
        } else {
            statement.setBinaryStream(4, (InputStream)null, 0);
        }
        return statement;
    }

    @Override
    public void initialize() {
        try {
            JDBCDriverRegister.registerDrivers();
            this.loadDBsettings();
            this.initializeDatabase();
            this.monitor = new ChangesMonitor(new DBRepositoryRevisionGetter(), this.settings.timerPeriod);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize a repository", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDBsettings() throws IOException, SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            String databaseCode = metaData.getDatabaseProductName().toLowerCase().replace(" ", "_");
            int majorVersion = metaData.getDatabaseMajorVersion();
            int minorVersion = metaData.getDatabaseMinorVersion();
            this.log.info("Driver name      : {}", (Object)metaData.getDriverName());
            this.log.info("Driver version   : {}", (Object)metaData.getDriverVersion());
            this.log.info("Database name    : {}", (Object)metaData.getDatabaseProductName());
            this.log.info("Database version : {}", (Object)metaData.getDatabaseProductVersion());
            this.log.info("Database code    : {}-v{}.{}", new Object[]{databaseCode, majorVersion, minorVersion});
            this.settings = new Settings(databaseCode, majorVersion, minorVersion);
        }
        finally {
            SqlDBUtils.safeClose((Connection)connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeDatabase() throws SQLException {
        Statement statement;
        Connection connection;
        block7: {
            Object revision = this.checkRepository();
            if (!(revision instanceof Throwable)) {
                this.log.info("SQL result: {}. The repository is already initialized.", revision);
                return;
            }
            this.log.info("SQL error: {}", (Object)((Throwable)revision).getMessage());
            this.log.info("Initializing  the repository in the DB...");
            connection = null;
            statement = null;
            Boolean autoCommit = null;
            try {
                connection = this.getConnection();
                autoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                for (String query : this.settings.initStatements) {
                    if (!StringUtils.isNotBlank((CharSequence)query)) continue;
                    statement.execute(query);
                }
                connection.commit();
                this.log.info("The repository has been initialized.");
                if (autoCommit == null) break block7;
            }
            catch (Exception e) {
                try {
                    if (connection == null) throw e;
                    connection.rollback();
                    throw e;
                }
                catch (Throwable throwable) {
                    if (autoCommit != null) {
                        connection.setAutoCommit(autoCommit);
                    }
                    SqlDBUtils.safeClose(statement);
                    SqlDBUtils.safeClose((Connection)connection);
                    throw throwable;
                }
            }
            connection.setAutoCommit(autoCommit);
        }
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkRepository() {
        String changeSet = null;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(this.settings.selectLastChange);
            rs = statement.executeQuery();
            if (rs.next()) {
                changeSet = rs.getString(1);
            }
        }
        catch (Exception e) {
            Exception exception;
            try {
                exception = e;
            }
            catch (Throwable throwable) {
                SqlDBUtils.safeClose(rs);
                SqlDBUtils.safeClose(statement);
                SqlDBUtils.safeClose((Connection)connection);
                throw throwable;
            }
            SqlDBUtils.safeClose(rs);
            SqlDBUtils.safeClose((Statement)statement);
            SqlDBUtils.safeClose((Connection)connection);
            return exception;
        }
        SqlDBUtils.safeClose((ResultSet)rs);
        SqlDBUtils.safeClose((Statement)statement);
        SqlDBUtils.safeClose((Connection)connection);
        return changeSet;
    }

    private class DBRepositoryRevisionGetter
    implements RevisionGetter {
        private DBRepositoryRevisionGetter() {
        }

        @Override
        public Object getRevision() {
            Object revision = DBRepository.this.checkRepository();
            if (revision instanceof Throwable) {
                DBRepository.this.log.warn("Cannot check revision of the repository", (Throwable)revision);
                return null;
            }
            return revision;
        }
    }
}

