/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core.interceptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.binding.MethodUtil;
import org.openl.rules.datatype.gen.ASMUtils;
import org.openl.rules.ruleservice.core.InstantiationException;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactoryHelper;
import org.openl.rules.ruleservice.core.annotations.ExternalParam;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethod;
import org.openl.rules.ruleservice.core.interceptors.AnyType;
import org.openl.rules.ruleservice.core.interceptors.RulesType;
import org.openl.types.IOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.generation.InterfaceTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicInterfaceAnnotationEnhancerHelper {
    private DynamicInterfaceAnnotationEnhancerHelper() {
    }

    private static void processServiceExtraMethods(ClassVisitor classVisitor, Class<?> templateClass) {
        for (Method method : templateClass.getMethods()) {
            if (!method.isAnnotationPresent(ServiceExtraMethod.class)) continue;
            classVisitor.visitMethod(1025, method.getName(), Type.getMethodDescriptor((Method)method), null, null);
        }
    }

    public static Class<?> decorate(Class<?> originalClass, Class<?> templateClass, IOpenClass openClass, ClassLoader classLoader) throws Exception {
        if (!templateClass.isInterface() && !Modifier.isAbstract(templateClass.getModifiers())) {
            throw new InstantiationException("Only interfaces or abstract classes are supported");
        }
        String enhancedClassName = originalClass.getName() + "$Intercepted";
        ClassWriter cw = new ClassWriter(0);
        DynamicInterfaceAnnotationEnhancerClassVisitor dynamicInterfaceAnnotationEnhancerClassVisitor = new DynamicInterfaceAnnotationEnhancerClassVisitor((ClassVisitor)cw, templateClass, openClass, classLoader);
        DynamicInterfaceAnnotationEnhancerHelper.processServiceExtraMethods(dynamicInterfaceAnnotationEnhancerClassVisitor, templateClass);
        InterfaceTransformer transformer = new InterfaceTransformer(originalClass, enhancedClassName);
        transformer.accept((ClassVisitor)dynamicInterfaceAnnotationEnhancerClassVisitor);
        cw.visitEnd();
        DynamicInterfaceAnnotationEnhancerHelper.logMissedMethods(dynamicInterfaceAnnotationEnhancerClassVisitor);
        return ClassUtils.defineClass((String)enhancedClassName, (byte[])cw.toByteArray(), (ClassLoader)classLoader);
    }

    private static void logMissedMethods(DynamicInterfaceAnnotationEnhancerClassVisitor dynamicInterfaceAnnotationEnhancerClassVisitor) {
        Logger log = LoggerFactory.getLogger(DynamicInterfaceAnnotationEnhancerHelper.class);
        if (log.isWarnEnabled()) {
            for (Method method : dynamicInterfaceAnnotationEnhancerClassVisitor.getMissedMethods()) {
                if (method.getDeclaringClass() == Object.class) continue;
                log.warn("Method '{}' from annotation template {} is not found in the service class.", (Object)MethodUtil.printQualifiedMethodName((Method)method), (Object)(method.getDeclaringClass().isInterface() ? "interface" : "class"));
            }
        }
    }

    private static class DynamicInterfaceAnnotationEnhancerClassVisitor
    extends ClassVisitor {
        private static final String DECORATED_CLASS_NAME_SUFFIX = "$Intercepted";
        private final Class<?> templateClass;
        private final Set<Method> foundMethods = new HashSet<Method>();
        private final IOpenClass openClass;
        private final ClassLoader classLoader;
        private final Map<String, List<Method>> templateClassMethodsByName;

        public DynamicInterfaceAnnotationEnhancerClassVisitor(ClassVisitor arg0, Class<?> templateClass, IOpenClass openClass, ClassLoader classLoader) {
            super(327680, arg0);
            this.templateClass = templateClass;
            this.openClass = openClass;
            this.classLoader = classLoader;
            this.templateClassMethodsByName = ASMUtils.buildMap(templateClass);
        }

        public Method[] getMissedMethods() {
            HashSet<Method> tmp = new HashSet<Method>(Arrays.asList(this.templateClass.getMethods()));
            tmp.removeAll(this.foundMethods);
            return tmp.toArray(new Method[0]);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            Annotation[] annotations;
            super.visit(version, access, name, signature, superName, interfaces);
            for (Annotation annotation : annotations = this.templateClass.getAnnotations()) {
                AnnotationVisitor annotationVisitor = this.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true);
                InterfaceTransformer.processAnnotation((Annotation)annotation, (AnnotationVisitor)annotationVisitor);
            }
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (this.templateClass != null) {
                Executable templateMethod = null;
                List<Method> methods = this.templateClassMethodsByName.get(name);
                if (methods != null) {
                    for (Method method : methods) {
                        Type[] typesInTemplateMethod = (Type[])Arrays.stream(method.getParameters()).filter(e -> !e.isAnnotationPresent(ExternalParam.class)).map(e -> Type.getType(e.getType())).toArray(Type[]::new);
                        Type[] typesInCurrentMethod = Type.getArgumentTypes((String)descriptor);
                        if (typesInCurrentMethod.length != typesInTemplateMethod.length) continue;
                        boolean isCompatible = true;
                        for (int i = 0; i < typesInCurrentMethod.length; ++i) {
                            RulesType rulesType;
                            if (typesInCurrentMethod[i].equals((Object)typesInTemplateMethod[i])) continue;
                            Parameter parameter = method.getParameters()[i];
                            boolean isCompatibleParameter = false;
                            AnyType anyType = parameter.getAnnotation(AnyType.class);
                            if (anyType != null) {
                                String pattern = anyType.value();
                                if (pattern.isEmpty()) {
                                    isCompatibleParameter = true;
                                } else if (Pattern.matches(pattern, typesInCurrentMethod[i].getClassName())) {
                                    isCompatibleParameter = true;
                                }
                            }
                            if ((rulesType = parameter.getAnnotation(RulesType.class)) != null) {
                                try {
                                    Class<?> type = RuleServiceInstantiationFactoryHelper.findOrLoadType(rulesType, this.openClass, this.classLoader);
                                    String d = typesInCurrentMethod[i].getDescriptor();
                                    while (d.startsWith("[")) {
                                        d = d.substring(1);
                                    }
                                    if (Objects.equals(Type.getType(type), Type.getType((String)d))) {
                                        isCompatibleParameter = true;
                                    }
                                }
                                catch (ClassNotFoundException e2) {
                                    throw new InstantiationException(String.format("Failed to apply annotation template class to the service class. Failed to load type '%s' that used in @RulesType annotation.", rulesType.value()));
                                }
                            }
                            if (isCompatibleParameter) continue;
                            isCompatible = false;
                            break;
                        }
                        if (!isCompatible) continue;
                        if (templateMethod == null) {
                            templateMethod = method;
                            continue;
                        }
                        throw new InstantiationException(String.format("Failed to apply annotation template class to the service class. It is a non-obvious choice of '%s' method.", MethodUtil.printMethod((String)method.getName(), (Class[])method.getParameterTypes())));
                    }
                }
                if (templateMethod != null) {
                    this.foundMethods.add((Method)templateMethod);
                    Type[] argumentTypes = Type.getArgumentTypes(templateMethod);
                    Type[] originalMethodArgumentTypes = Type.getArgumentTypes((String)descriptor);
                    int i = 0;
                    int j = 0;
                    for (Parameter parameter : templateMethod.getParameters()) {
                        if (!parameter.isAnnotationPresent(ExternalParam.class)) {
                            argumentTypes[i] = originalMethodArgumentTypes[j];
                            ++j;
                        }
                        ++i;
                    }
                    MethodVisitor mv = super.visitMethod(access, name, Type.getMethodDescriptor((Type)Type.getType(((Method)templateMethod).getReturnType()), (Type[])argumentTypes), signature, exceptions);
                    Annotation[] annotations = templateMethod.getAnnotations();
                    for (Annotation annotation : annotations) {
                        AnnotationVisitor annotationVisitor = mv.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true);
                        InterfaceTransformer.processAnnotation((Annotation)annotation, (AnnotationVisitor)annotationVisitor);
                    }
                    i = 0;
                    for (Parameter parameter : templateMethod.getParameters()) {
                        for (Annotation annotation : parameter.getAnnotations()) {
                            AnnotationVisitor annotationVisitor = mv.visitParameterAnnotation(i, Type.getDescriptor(annotation.annotationType()), true);
                            InterfaceTransformer.processAnnotation((Annotation)annotation, (AnnotationVisitor)annotationVisitor);
                        }
                        ++i;
                    }
                    return mv;
                }
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }
}

